"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.time2CountWin = exports.getMetrics = exports.addToMetric = void 0;
var _lodash = _interopRequireDefault(require("lodash"));
var _constants = require("./constants");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const time2CountWin = exports.time2CountWin = new Map();
const addToMetric = (entity, action, counter, reportMetadata) => {
  const count = 1;
  // remove outdated key-value pairs
  trim();
  const timeKey = getKey(Date.now());
  const rollingCounters = time2CountWin.get(timeKey);
  time2CountWin.set(timeKey, updateCounters(entity, action, counter, rollingCounters || _lodash.default.cloneDeep(_constants.DEFAULT_ROLLING_COUNTER), count, reportMetadata));
};
exports.addToMetric = addToMetric;
const getMetrics = () => {
  const preTimeKey = getPreKey(Date.now());
  const rollingCounters = time2CountWin.get(preTimeKey);
  const metrics = buildMetrics(rollingCounters);
  return metrics;
};
exports.getMetrics = getMetrics;
const trim = () => {
  if (time2CountWin.size > _constants.CAPACITY) {
    const currentKey = getKey(Date.now() - _constants.WINDOW * 1000);
    time2CountWin.forEach((_value, key, map) => {
      if (key < currentKey) {
        map.delete(key);
      }
    });
  }
};
const getKey = milliseconds => {
  return Math.floor(milliseconds / 1000 / _constants.INTERVAL);
};
const getPreKey = milliseconds => {
  return getKey(milliseconds) - 1;
};
const isEntity = arg => {
  return arg === 'report' || arg === 'report_definition' || arg === 'report_source';
};
const buildMetrics = rollingCounters => {
  if (!rollingCounters) {
    rollingCounters = _constants.DEFAULT_ROLLING_COUNTER;
  }
  const basicMetrics = _lodash.default.merge(rollingCounters, _constants.GLOBAL_BASIC_COUNTER);
  const overallActionMetrics = {
    request_total: 0,
    request_count: 0,
    success_count: 0,
    failed_request_count_system_error: 0,
    failed_request_count_user_error: 0
  };
  Object.keys(basicMetrics).forEach(keys => {
    if (isEntity(keys)) {
      for (const [action, counters] of Object.entries(basicMetrics[keys])) {
        overallActionMetrics.request_count += (counters === null || counters === void 0 ? void 0 : counters.count) || 0;
        overallActionMetrics.request_total += (counters === null || counters === void 0 ? void 0 : counters.total) || 0;
        overallActionMetrics.failed_request_count_system_error += (counters === null || counters === void 0 ? void 0 : counters.system_error) || 0;
        overallActionMetrics.failed_request_count_user_error += (counters === null || counters === void 0 ? void 0 : counters.user_error) || 0;
      }
    }
  });
  overallActionMetrics.success_count = overallActionMetrics.request_count - (overallActionMetrics.failed_request_count_system_error + overallActionMetrics.failed_request_count_user_error);
  return {
    ...basicMetrics,
    ...overallActionMetrics
  };
};
const updateCounters = (entity, action, counter, rollingCounter, count, reportMetadata) => {
  // update usage metrics
  if (reportMetadata) {
    const {
      report_definition: {
        report_params: {
          report_source: source,
          core_params: {
            report_format: format
          }
        }
      }
    } = reportMetadata;

    // @ts-ignore
    rollingCounter[source.toLowerCase().replace(' ', '_')][format]['download'][counter] += count;
    // update basic counter for total request count
    if (counter === 'count') {
      //@ts-ignore
      _constants.GLOBAL_BASIC_COUNTER[source.toLowerCase().replace(' ', '_')][format]['download']['total']++;
    }
  } else {
    // update action metric, per API
    // @ts-ignore
    rollingCounter[entity][action][counter] += count;
    if (counter === 'count') {
      // @ts-ignore
      _constants.GLOBAL_BASIC_COUNTER[entity][action]['total']++;
    }
  }
  return rollingCounter;
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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