"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
require("core-js/modules/es.regexp.flags.js");
require("core-js/modules/es.typed-array.set.js");
var _lodash = _interopRequireDefault(require("lodash"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); } /*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
class QueryService {
  constructor(_client, dataSourceEnabled, logger) {
    _defineProperty(this, "client", void 0);
    _defineProperty(this, "dataSourceEnabled", void 0);
    _defineProperty(this, "logger", void 0);
    _defineProperty(this, "describeQueryPostInternal", async (request, format, responseFormat, body, context) => {
      try {
        const params = {
          body: JSON.stringify(body)
        };
        let client = this.client;
        let queryResponse;
        const {
          dataSourceMDSId
        } = request.query;
        if (this.dataSourceEnabled && dataSourceMDSId) {
          client = context.dataSource.opensearch.legacy.getClient(dataSourceMDSId);
          queryResponse = await client.callAPI(format, params);
        } else {
          queryResponse = await this.client.asScoped(request).callAsCurrentUser(format, params);
        }
        return {
          data: {
            ok: true,
            resp: _lodash.default.isEqual(responseFormat, 'json') ? JSON.stringify(queryResponse) : queryResponse
          }
        };
      } catch (err) {
        this.logger.info('error describeQueryPostInternal');
        this.logger.info(err);
        return {
          data: {
            ok: false,
            resp: err.message,
            body: err.body,
            statusCode: err.statusCode || 400
          }
        };
      }
    });
    _defineProperty(this, "describeQueryJobIdInternal", async (request, format, jobId, responseFormat, context, dataSourceMDSId) => {
      try {
        let client = this.client;
        let queryResponse;
        if (this.dataSourceEnabled && dataSourceMDSId) {
          client = context.dataSource.opensearch.legacy.getClient(dataSourceMDSId);
          queryResponse = await client.callAPI(format, {
            jobId: jobId
          });
        } else {
          queryResponse = await this.client.asScoped(request).callAsCurrentUser(format, {
            jobId: jobId
          });
        }
        return {
          data: {
            ok: true,
            resp: _lodash.default.isEqual(responseFormat, 'json') ? JSON.stringify(queryResponse) : queryResponse
          }
        };
      } catch (err) {
        this.logger.info(err);
        this.logger.info(request.query);
        return {
          data: {
            ok: false,
            resp: err.message,
            body: err.body,
            statusCode: err.statusCode || 400
          }
        };
      }
    });
    _defineProperty(this, "describeQueryGetInternalSync", async (request, format, responseFormat, context) => {
      try {
        let client = this.client;
        let queryResponse;
        const dataSourceMDSId = request.params.dataSourceMDSId;
        if (this.dataSourceEnabled && dataSourceMDSId) {
          client = context.dataSource.opensearch.legacy.getClient(dataSourceMDSId);
          queryResponse = await client.callAPI(format);
        } else {
          queryResponse = await this.client.asScoped(request).callAsCurrentUser(format);
        }
        return {
          data: {
            ok: true,
            resp: _lodash.default.isEqual(responseFormat, 'json') ? JSON.stringify(queryResponse) : queryResponse
          }
        };
      } catch (err) {
        this.logger.info('error describeQueryGetInternalSync');
        this.logger.info(err);
        this.logger.info(request.query);
        console.log(err, request.query);
        return {
          data: {
            ok: false,
            resp: err.message,
            body: err.body,
            statusCode: err.statusCode || 400
          }
        };
      }
    });
    _defineProperty(this, "describeSQLQuery", async (context, request) => {
      return this.describeQueryPostInternal(request, 'sql.sqlQuery', 'json', request.body, context);
    });
    _defineProperty(this, "describePPLQuery", async (context, request) => {
      return this.describeQueryPostInternal(request, 'sql.pplQuery', 'json', request.body, context);
    });
    _defineProperty(this, "describeSQLCsv", async (context, request) => {
      return this.describeQueryPostInternal(request, 'sql.sqlCsv', null, request.body, context);
    });
    _defineProperty(this, "describePPLCsv", async (context, request) => {
      return this.describeQueryPostInternal(request, 'sql.pplCsv', null, request.body, context);
    });
    _defineProperty(this, "describeSQLJson", async (context, request) => {
      return this.describeQueryPostInternal(request, 'sql.sqlJson', 'json', request.body, context);
    });
    _defineProperty(this, "describePPLJson", async (context, request) => {
      return this.describeQueryPostInternal(request, 'sql.pplJson', 'json', request.body, context);
    });
    _defineProperty(this, "describeSQLText", async (context, request) => {
      return this.describeQueryPostInternal(request, 'sql.sqlText', null, request.body, context);
    });
    _defineProperty(this, "describePPLText", async (context, request) => {
      return this.describeQueryPostInternal(request, 'sql.pplText', null, request.body, context);
    });
    _defineProperty(this, "describeSQLAsyncQuery", async (context, request) => {
      return this.describeQueryPostInternal(request, 'sql.sparkSqlQuery', null, request.body, context);
    });
    _defineProperty(this, "describeSQLAsyncGetQuery", async (context, request, jobId, dataSourceMDSId) => {
      return this.describeQueryJobIdInternal(request, 'sql.sparkSqlGetQuery', jobId, null, context, dataSourceMDSId);
    });
    _defineProperty(this, "describeSyncQueryDataSources", async (context, request) => {
      return this.describeQueryGetInternalSync(request, 'sql.datasourcesGetQuery', null, context);
    });
    _defineProperty(this, "describeAsyncDeleteQuery", async (context, request, jobId, dataSourceMDSId) => {
      return this.describeQueryJobIdInternal(request, 'sql.asyncDeleteQuery', jobId, null, context, dataSourceMDSId);
    });
    this.client = _client;
    this.dataSourceEnabled = dataSourceEnabled;
    this.logger = logger;
  }
}
exports.default = QueryService;
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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