/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkFormatProperties3
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int LINEARTILINGFEATURES;
    public static final int OPTIMALTILINGFEATURES;
    public static final int BUFFERFEATURES;

    public VkFormatProperties3(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkFormatProperties3.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkFormatProperties3.nsType(this.address());
    }

    @NativeType(value="void *")
    public long pNext() {
        return VkFormatProperties3.npNext(this.address());
    }

    @NativeType(value="VkFormatFeatureFlags2")
    public long linearTilingFeatures() {
        return VkFormatProperties3.nlinearTilingFeatures(this.address());
    }

    @NativeType(value="VkFormatFeatureFlags2")
    public long optimalTilingFeatures() {
        return VkFormatProperties3.noptimalTilingFeatures(this.address());
    }

    @NativeType(value="VkFormatFeatureFlags2")
    public long bufferFeatures() {
        return VkFormatProperties3.nbufferFeatures(this.address());
    }

    public VkFormatProperties3 sType(@NativeType(value="VkStructureType") int value) {
        VkFormatProperties3.nsType(this.address(), value);
        return this;
    }

    public VkFormatProperties3 sType$Default() {
        return this.sType(1000360000);
    }

    public VkFormatProperties3 pNext(@NativeType(value="void *") long value) {
        VkFormatProperties3.npNext(this.address(), value);
        return this;
    }

    public VkFormatProperties3 set(int sType, long pNext) {
        this.sType(sType);
        this.pNext(pNext);
        return this;
    }

    public VkFormatProperties3 set(VkFormatProperties3 src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkFormatProperties3 malloc() {
        return (VkFormatProperties3)VkFormatProperties3.wrap(VkFormatProperties3.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkFormatProperties3 calloc() {
        return (VkFormatProperties3)VkFormatProperties3.wrap(VkFormatProperties3.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkFormatProperties3 create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkFormatProperties3)VkFormatProperties3.wrap(VkFormatProperties3.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkFormatProperties3 create(long address) {
        return (VkFormatProperties3)VkFormatProperties3.wrap(VkFormatProperties3.class, (long)address);
    }

    @Nullable
    public static VkFormatProperties3 createSafe(long address) {
        return address == 0L ? null : (VkFormatProperties3)VkFormatProperties3.wrap(VkFormatProperties3.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkFormatProperties3.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkFormatProperties3.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkFormatProperties3.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkFormatProperties3.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkFormatProperties3.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkFormatProperties3.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkFormatProperties3.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkFormatProperties3 malloc(MemoryStack stack) {
        return (VkFormatProperties3)VkFormatProperties3.wrap(VkFormatProperties3.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkFormatProperties3 calloc(MemoryStack stack) {
        return (VkFormatProperties3)VkFormatProperties3.wrap(VkFormatProperties3.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)VkFormatProperties3.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)VkFormatProperties3.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static long nlinearTilingFeatures(long struct) {
        return UNSAFE.getLong(null, struct + (long)LINEARTILINGFEATURES);
    }

    public static long noptimalTilingFeatures(long struct) {
        return UNSAFE.getLong(null, struct + (long)OPTIMALTILINGFEATURES);
    }

    public static long nbufferFeatures(long struct) {
        return UNSAFE.getLong(null, struct + (long)BUFFERFEATURES);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    static {
        Struct.Layout layout = VkFormatProperties3.__struct((Struct.Member[])new Struct.Member[]{VkFormatProperties3.__member((int)4), VkFormatProperties3.__member((int)POINTER_SIZE), VkFormatProperties3.__member((int)8), VkFormatProperties3.__member((int)8), VkFormatProperties3.__member((int)8)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        LINEARTILINGFEATURES = layout.offsetof(2);
        OPTIMALTILINGFEATURES = layout.offsetof(3);
        BUFFERFEATURES = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VkFormatProperties3, Buffer>
    implements NativeResource {
        private static final VkFormatProperties3 ELEMENT_FACTORY = VkFormatProperties3.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkFormatProperties3 getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkFormatProperties3.nsType(this.address());
        }

        @NativeType(value="void *")
        public long pNext() {
            return VkFormatProperties3.npNext(this.address());
        }

        @NativeType(value="VkFormatFeatureFlags2")
        public long linearTilingFeatures() {
            return VkFormatProperties3.nlinearTilingFeatures(this.address());
        }

        @NativeType(value="VkFormatFeatureFlags2")
        public long optimalTilingFeatures() {
            return VkFormatProperties3.noptimalTilingFeatures(this.address());
        }

        @NativeType(value="VkFormatFeatureFlags2")
        public long bufferFeatures() {
            return VkFormatProperties3.nbufferFeatures(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkFormatProperties3.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000360000);
        }

        public Buffer pNext(@NativeType(value="void *") long value) {
            VkFormatProperties3.npNext(this.address(), value);
            return this;
        }
    }
}

