/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.utils.resolver.implementations;

import com.sun.org.apache.xml.internal.security.signature.XMLSignatureInput;
import com.sun.org.apache.xml.internal.security.utils.resolver.ResourceResolverContext;
import com.sun.org.apache.xml.internal.security.utils.resolver.ResourceResolverException;
import com.sun.org.apache.xml.internal.security.utils.resolver.ResourceResolverSpi;
import com.sun.org.slf4j.internal.Logger;
import com.sun.org.slf4j.internal.LoggerFactory;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;

public class ResolverLocalFilesystem
extends ResourceResolverSpi {
    private static final Logger LOG = LoggerFactory.getLogger(ResolverLocalFilesystem.class);

    @Override
    public boolean engineIsThreadSafe() {
        return true;
    }

    @Override
    public XMLSignatureInput engineResolveURI(ResourceResolverContext resourceResolverContext) throws ResourceResolverException {
        try {
            URI uRI = ResolverLocalFilesystem.getNewURI(resourceResolverContext.uriToResolve, resourceResolverContext.baseUri);
            InputStream inputStream = Files.newInputStream(Paths.get(uRI), new OpenOption[0]);
            XMLSignatureInput xMLSignatureInput = new XMLSignatureInput(inputStream);
            xMLSignatureInput.setSecureValidation(resourceResolverContext.secureValidation);
            xMLSignatureInput.setSourceURI(uRI.toString());
            return xMLSignatureInput;
        }
        catch (Exception exception) {
            throw new ResourceResolverException(exception, resourceResolverContext.uriToResolve, resourceResolverContext.baseUri, "generic.EmptyMessage");
        }
    }

    @Override
    public boolean engineCanResolveURI(ResourceResolverContext resourceResolverContext) {
        if (resourceResolverContext.uriToResolve == null) {
            return false;
        }
        if (resourceResolverContext.uriToResolve.equals("") || resourceResolverContext.uriToResolve.charAt(0) == '#' || resourceResolverContext.uriToResolve.startsWith("http:")) {
            return false;
        }
        try {
            LOG.debug("I was asked whether I can resolve {}", resourceResolverContext.uriToResolve);
            if (resourceResolverContext.uriToResolve.startsWith("file:") || resourceResolverContext.baseUri.startsWith("file:")) {
                LOG.debug("I state that I can resolve {}", resourceResolverContext.uriToResolve);
                return true;
            }
        }
        catch (Exception exception) {
            LOG.debug(exception.getMessage(), exception);
        }
        LOG.debug("But I can't");
        return false;
    }

    private static URI getNewURI(String string, String string2) throws URISyntaxException {
        URI uRI = null;
        uRI = string2 == null || "".equals(string2) ? new URI(string) : new URI(string2).resolve(string);
        if (uRI.getFragment() != null) {
            URI uRI2 = new URI(uRI.getScheme(), uRI.getSchemeSpecificPart(), null);
            return uRI2;
        }
        return uRI;
    }
}

