/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.security.policyeditor;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.channels.FileLock;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.jnlp.security.policyeditor.CustomPermission;
import net.sourceforge.jnlp.security.policyeditor.InvalidPolicyException;
import net.sourceforge.jnlp.security.policyeditor.PolicyEditorPermissions;
import net.sourceforge.jnlp.security.policyeditor.PolicyEntry;
import net.sourceforge.jnlp.util.FileUtils;
import net.sourceforge.jnlp.util.MD5SumWatcher;
import net.sourceforge.jnlp.util.logging.OutputController;

public class PolicyFileModel {
    private static final String AUTOGENERATED_NOTICE = "/* DO NOT MODIFY! AUTO-GENERATED */";
    private File file;
    public final Map<String, Map<PolicyEditorPermissions, Boolean>> codebasePermissionsMap = Collections.synchronizedMap(new HashMap());
    private final Map<String, Set<CustomPermission>> customPermissionsMap = Collections.synchronizedMap(new HashMap());
    private MD5SumWatcher fileWatcher;

    PolicyFileModel(String filepath) {
        this(new File(filepath));
    }

    PolicyFileModel(File file) {
        this.setFile(file);
    }

    PolicyFileModel() {
    }

    synchronized void setFile(File file) {
        this.file = file;
    }

    synchronized File getFile() {
        return this.file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void openAndParsePolicyFile() throws IOException, InvalidPolicyException {
        this.fileWatcher = new MD5SumWatcher(this.file);
        this.fileWatcher.update();
        this.codebasePermissionsMap.clear();
        this.customPermissionsMap.clear();
        FileLock fileLock = FileUtils.getFileLock(this.file.getAbsolutePath(), false, true);
        try {
            String contents = FileUtils.loadFileAsString(this.file);
            Set<PolicyEntry> entries = PolicyFileModel.parsePolicyString(contents);
            Map<String, Map<PolicyEditorPermissions, Boolean>> map = this.codebasePermissionsMap;
            synchronized (map) {
                Map<String, Set<CustomPermission>> map2 = this.customPermissionsMap;
                synchronized (map2) {
                    for (PolicyEntry entry : entries) {
                        this.addCodebase(entry.getCodebase());
                        for (PolicyEditorPermissions permission : entry.getPermissions()) {
                            this.setPermission(entry.getCodebase(), permission, true);
                        }
                        this.addCustomPermissions(entry.getCodebase(), entry.getCustomPermissions());
                    }
                }
            }
        }
        finally {
            try {
                fileLock.release();
            }
            catch (IOException e) {
                OutputController.getLogger().log(e);
            }
        }
    }

    static Set<PolicyEntry> parsePolicyString(String contents) throws InvalidPolicyException {
        HashSet<PolicyEntry> policyEntries = new HashSet<PolicyEntry>();
        StringBuilder sb = new StringBuilder();
        String[] lines = contents.split("\\r?\\n+");
        boolean openBlock = false;
        boolean closeBlock = false;
        for (String line : lines) {
            Pattern openBlockPattern = Pattern.compile("grant\\s*\"?\\s*(?:codeBase)?\\s*\"?[^\"\\s]*\"?\\s*\\{");
            Matcher openBlockMatcher = openBlockPattern.matcher(line);
            if (openBlockMatcher.matches()) {
                openBlock = true;
            }
            if (line.matches("\\s*\\};\\s*")) {
                closeBlock = true;
            }
            if (openBlock) {
                sb.append(line);
                sb.append('\n');
            }
            if (!openBlock || !closeBlock) continue;
            closeBlock = false;
            openBlock = false;
            policyEntries.add(PolicyEntry.fromString(sb.toString()));
            sb = new StringBuilder();
        }
        return policyEntries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void savePolicyFile() throws FileNotFoundException, IOException {
        StringBuilder sb = new StringBuilder();
        sb.append(AUTOGENERATED_NOTICE);
        String currentDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(Calendar.getInstance().getTime());
        sb.append("\n/* Generated by PolicyEditor at ").append(currentDate).append(" */");
        sb.append(System.getProperty("line.separator"));
        FileLock fileLock = null;
        try {
            fileLock = FileUtils.getFileLock(this.file.getAbsolutePath(), false, true);
            Map<String, Map<PolicyEditorPermissions, Boolean>> map = this.codebasePermissionsMap;
            synchronized (map) {
                for (String codebase : this.codebasePermissionsMap.keySet()) {
                    HashSet<PolicyEditorPermissions> enabledPermissions = new HashSet<PolicyEditorPermissions>();
                    for (Map.Entry<PolicyEditorPermissions, Boolean> entry : this.codebasePermissionsMap.get(codebase).entrySet()) {
                        if (!entry.getValue().booleanValue()) continue;
                        enabledPermissions.add(entry.getKey());
                    }
                    sb.append(new PolicyEntry(codebase, enabledPermissions, (Collection<CustomPermission>)this.customPermissionsMap.get(codebase)).toString());
                }
            }
        }
        catch (IOException e) {
            OutputController.getLogger().log(e);
        }
        finally {
            if (fileLock != null) {
                try {
                    fileLock.release();
                }
                catch (IOException e) {
                    OutputController.getLogger().log(e);
                }
            }
        }
        FileUtils.saveFile(sb.toString(), this.file);
        this.fileWatcher = new MD5SumWatcher(this.file);
        this.fileWatcher.update();
    }

    synchronized boolean hasChanged() throws FileNotFoundException, IOException {
        return this.fileWatcher != null && this.fileWatcher.update();
    }

    synchronized Set<String> getCodebases() {
        return new HashSet<String>(this.codebasePermissionsMap.keySet());
    }

    synchronized boolean addCodebase(String codebase) {
        Objects.requireNonNull(codebase);
        boolean existingCodebase = true;
        if (!this.codebasePermissionsMap.containsKey(codebase)) {
            HashMap<PolicyEditorPermissions, Boolean> map = new HashMap<PolicyEditorPermissions, Boolean>();
            for (PolicyEditorPermissions perm : PolicyEditorPermissions.values()) {
                map.put(perm, false);
            }
            this.codebasePermissionsMap.put(codebase, map);
            existingCodebase = false;
        }
        if (!this.customPermissionsMap.containsKey(codebase)) {
            HashSet set = new HashSet();
            this.customPermissionsMap.put(codebase, set);
            existingCodebase = false;
        }
        return existingCodebase;
    }

    synchronized void clearPermissions() {
        this.codebasePermissionsMap.clear();
        this.clearCustomPermissions();
    }

    synchronized void removeCodebase(String codebase) {
        Objects.requireNonNull(codebase);
        this.codebasePermissionsMap.remove(codebase);
        this.customPermissionsMap.remove(codebase);
    }

    synchronized void setPermission(String codebase, PolicyEditorPermissions permission, boolean state) {
        Objects.requireNonNull(codebase);
        Objects.requireNonNull(permission);
        this.addCodebase(codebase);
        this.codebasePermissionsMap.get(codebase).put(permission, state);
    }

    synchronized boolean getPermission(String codebase, PolicyEditorPermissions permission) {
        Objects.requireNonNull(codebase);
        Objects.requireNonNull(permission);
        if (!this.codebasePermissionsMap.containsKey(codebase)) {
            return false;
        }
        return this.codebasePermissionsMap.get(codebase).get((Object)permission);
    }

    synchronized Map<String, Map<PolicyEditorPermissions, Boolean>> getCopyOfPermissions() {
        return new HashMap<String, Map<PolicyEditorPermissions, Boolean>>(this.codebasePermissionsMap);
    }

    synchronized void clearCustomPermissions() {
        this.customPermissionsMap.clear();
    }

    synchronized void clearCustomCodebase(String codebase) {
        Objects.requireNonNull(codebase);
        if (!this.customPermissionsMap.containsKey(codebase)) {
            return;
        }
        this.customPermissionsMap.get(codebase).clear();
    }

    synchronized void addCustomPermissions(String codebase, Collection<CustomPermission> permissions) {
        Objects.requireNonNull(codebase);
        Objects.requireNonNull(permissions);
        this.addCodebase(codebase);
        this.customPermissionsMap.get(codebase).addAll(permissions);
    }

    synchronized Map<String, Set<CustomPermission>> getCopyOfCustomPermissions() {
        return new HashMap<String, Set<CustomPermission>>(this.customPermissionsMap);
    }
}

