/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.configuration;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.api.internal.tasks.options.OptionReader;
import org.gradle.configuration.TaskDetails;
import org.gradle.execution.TaskSelectionException;
import org.gradle.execution.selection.BuildTaskSelector;

class TaskDetailsModel {
    private final String taskPath;
    private final List<TaskDetails> tasks;
    private final TaskSelectionException failure;

    private TaskDetailsModel(String taskPath, List<TaskDetails> tasks) {
        this.taskPath = taskPath;
        this.failure = null;
        this.tasks = tasks;
    }

    private TaskDetailsModel(String taskPath, TaskSelectionException failure) {
        this.taskPath = taskPath;
        this.tasks = Collections.emptyList();
        this.failure = failure;
    }

    public List<TaskDetails> getTasks() {
        if (this.failure != null) {
            throw this.failure;
        }
        return this.tasks;
    }

    public String getTaskPath() {
        return this.taskPath;
    }

    public static TaskDetailsModel from(String taskPath, BuildTaskSelector.BuildSpecificSelector taskSelector, OptionReader optionReader) {
        try {
            Stream selectedTasks = taskSelector.resolveTaskName(taskPath).getTasks().stream();
            List<TaskDetails> tasks = selectedTasks.map(t -> TaskDetails.from(t, optionReader)).sorted(TaskDetails.DEFAULT_COMPARATOR).collect(Collectors.toList());
            return new TaskDetailsModel(taskPath, tasks);
        }
        catch (TaskSelectionException exception) {
            return new TaskDetailsModel(taskPath, exception);
        }
    }
}

