/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.task;

import java.io.Serializable;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ConcurrencyThrottleSupport;
import org.springframework.util.CustomizableThreadCreator;

public class SimpleAsyncTaskExecutor
extends CustomizableThreadCreator
implements AsyncTaskExecutor,
Serializable {
    public static final String DEFAULT_THREAD_NAME_PREFIX = ClassUtils.getShortName(class$org$springframework$core$task$SimpleAsyncTaskExecutor == null ? (class$org$springframework$core$task$SimpleAsyncTaskExecutor = SimpleAsyncTaskExecutor.class$("org.springframework.core.task.SimpleAsyncTaskExecutor")) : class$org$springframework$core$task$SimpleAsyncTaskExecutor) + "-";
    public static final int UNBOUNDED_CONCURRENCY = -1;
    public static final int NO_CONCURRENCY = 0;
    private final ConcurrencyThrottleAdapter concurrencyThrottle = new ConcurrencyThrottleAdapter();
    static /* synthetic */ Class class$org$springframework$core$task$SimpleAsyncTaskExecutor;

    public SimpleAsyncTaskExecutor() {
    }

    public SimpleAsyncTaskExecutor(String threadNamePrefix) {
        super(threadNamePrefix);
    }

    public void setConcurrencyLimit(int concurrencyLimit) {
        this.concurrencyThrottle.setConcurrencyLimit(concurrencyLimit);
    }

    public int getConcurrencyLimit() {
        return this.concurrencyThrottle.getConcurrencyLimit();
    }

    public boolean isThrottleActive() {
        return this.concurrencyThrottle.isThrottleActive();
    }

    public void execute(Runnable task) {
        this.execute(task, Long.MAX_VALUE);
    }

    public void execute(Runnable task, long startTimeout) {
        Assert.notNull(task, "Runnable must not be null");
        if (this.isThrottleActive() && startTimeout > 0L) {
            this.concurrencyThrottle.beforeAccess();
            this.doExecute(new ConcurrencyThrottlingRunnable(task));
        } else {
            this.doExecute(task);
        }
    }

    protected void doExecute(Runnable task) {
        this.createThread(task).start();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ConcurrencyThrottlingRunnable
    implements Runnable {
        private final Runnable target;

        public ConcurrencyThrottlingRunnable(Runnable target) {
            this.target = target;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this.target.run();
            }
            finally {
                SimpleAsyncTaskExecutor.this.concurrencyThrottle.afterAccess();
            }
        }
    }

    private static class ConcurrencyThrottleAdapter
    extends ConcurrencyThrottleSupport {
        private ConcurrencyThrottleAdapter() {
        }

        protected void beforeAccess() {
            super.beforeAccess();
        }

        protected void afterAccess() {
            super.afterAccess();
        }
    }
}

