'\" t
.\" Copyright (c) 1999, Oracle and/or its affiliates.
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the "Software"),
.\" to deal in the Software without restriction, including without limitation
.\" the rights to use, copy, modify, merge, publish, distribute, sublicense,
.\" and/or sell copies of the Software, and to permit persons to whom the
.\" Software is furnished to do so, subject to the following conditions:
.\"
.\" The above copyright notice and this permission notice (including the next
.\" paragraph) shall be included in all copies or substantial portions of the
.\" Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
.\" IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
.\" FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
.\" THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
.\" LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
.\" FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
.\" DEALINGS IN THE SOFTWARE.
.\"
.TH XkbKeyKeyType __libmansuffix__ __xorgversion__ "XKB FUNCTIONS"
.SH NAME
XkbKeyKeyType \- Obtain the index of a key type or the pointer to a key type
.SH SYNOPSIS
.HP
.B XkbKeyTypePtr XkbKeyKeyType
.BI "(\^XkbDescPtr " "xkb" "\^,"
.BI "KeyCode " "keycode" "\^,"
.BI "int " "group" "\^);"
.if n .ti +5n
.if t .ti +.5i
.SH ARGUMENTS
.TP
.I xkb
Xkb description of interest
.TP
.I keycode
keycode of interest
.TP
.I group
group index
.SH DESCRIPTION
.LP
.I XkbKeyKeyType
returns a pointer to the key type in the 
.I types 
vector of the client map in 
.I xkb 
corresponding to the given 
.I keycode 
and 
.I group 
index.
.SH STRUCTURES
.LP
.nf

typedef struct {                             /\&* Key Type */
	XkbModsRec              mods;           /\&* modifiers used to compute shift level */
	unsigned char           num_levels;     /\&* total # shift levels, do not modify directly */
	unsigned char           map_count;      /\&* # entries in map, preserve (if non-NULL) */
	XkbKTMapEntryPtr        map;            /\&* vector of modifiers for each shift level */
	XkbModsPtr              preserve;       /\&* mods to preserve for corresponding map entry */
	Atom                    name;           /\&* name of key type */
	Atom *                  level_names;    /\&* array of names of each shift level */
} XkbKeyTypeRec, *XkbKeyTypePtr;

.fi
