/*
 * Decompiled with CFR 0.152.
 */
package com.google.auto.value.processor;

import autovalue.shaded.com.google.common.base.CharMatcher;
import com.google.auto.value.processor.JavaScanner;

class Reformatter {
    private static final CharMatcher OPERATORS = CharMatcher.anyOf("+-*%&|^<>=?:.").precomputed();

    /*
     * Enabled aggressive block sorting
     */
    static String fixup(String s) {
        StringBuilder out = new StringBuilder();
        JavaScanner scanner = new JavaScanner(s);
        s = scanner.string();
        int len = s.length();
        int start = 0;
        int previous = 0;
        int braces = 0;
        int parens = 0;
        int end = 0;
        while (true) {
            block19: {
                if (start >= len) {
                    return out.toString();
                }
                end = scanner.tokenEnd(start);
                switch (s.charAt(start)) {
                    case '(': {
                        ++parens;
                        break;
                    }
                    case ')': {
                        --parens;
                        break;
                    }
                    case '{': {
                        ++braces;
                        break;
                    }
                    case '}': {
                        --braces;
                        break;
                    }
                    case ' ': {
                        if (start > 0 && s.charAt(previous) != '(' && "\n.,;)".indexOf(s.charAt(end)) < 0) {
                            out.append(' ');
                        }
                        break block19;
                    }
                    case '\n': {
                        if (end < len && s.charAt(end) != '\n') {
                            char prev = s.charAt(previous);
                            char next = s.charAt(end);
                            if (out.length() > 0 && (prev != '(' || next != ')')) {
                                out.append('\n');
                                int indent = braces * 2;
                                if (parens > 0 || OPERATORS.matches(next)) {
                                    indent += 4;
                                } else if (next == '}') {
                                    indent -= 2;
                                }
                                for (int i = 0; i < indent; ++i) {
                                    out.append(' ');
                                }
                            }
                            break block19;
                        } else if (parens == 0 && braces < 2 && s.charAt(previous) != '\n' && out.length() > 0) {
                            out.append('\n');
                        }
                        break block19;
                    }
                }
                out.append(s, start, end);
            }
            previous = start;
            start = end;
        }
    }

    private Reformatter() {
    }
}

