/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.autoconfigure;

import io.opentelemetry.api.metrics.MeterProvider;
import io.opentelemetry.exporter.internal.retry.RetryPolicy;
import io.opentelemetry.exporter.internal.retry.RetryUtil;
import io.opentelemetry.exporter.jaeger.JaegerGrpcSpanExporter;
import io.opentelemetry.exporter.jaeger.JaegerGrpcSpanExporterBuilder;
import io.opentelemetry.exporter.otlp.http.trace.OtlpHttpSpanExporter;
import io.opentelemetry.exporter.otlp.http.trace.OtlpHttpSpanExporterBuilder;
import io.opentelemetry.exporter.otlp.trace.OtlpGrpcSpanExporter;
import io.opentelemetry.exporter.otlp.trace.OtlpGrpcSpanExporterBuilder;
import io.opentelemetry.sdk.autoconfigure.ClasspathUtil;
import io.opentelemetry.sdk.autoconfigure.NamedSpiManager;
import io.opentelemetry.sdk.autoconfigure.OtlpConfigUtil;
import io.opentelemetry.sdk.autoconfigure.SpiUtil;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigurationException;
import io.opentelemetry.sdk.autoconfigure.spi.internal.DefaultConfigProperties;
import io.opentelemetry.sdk.autoconfigure.spi.traces.ConfigurableSpanExporterProvider;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;

final class SpanExporterConfiguration {
    private static final String EXPORTER_NONE = "none";
    private static final Map<String, String> EXPORTER_ARTIFACT_ID_BY_NAME = new HashMap<String, String>();

    static Map<String, SpanExporter> configureSpanExporters(ConfigProperties config, ClassLoader serviceClassLoader, MeterProvider meterProvider, BiFunction<? super SpanExporter, ConfigProperties, ? extends SpanExporter> spanExporterCustomizer) {
        Set<String> exporterNames = DefaultConfigProperties.getSet((ConfigProperties)config, (String)"otel.traces.exporter");
        if (exporterNames.contains(EXPORTER_NONE)) {
            if (exporterNames.size() > 1) {
                throw new ConfigurationException("otel.traces.exporter contains none along with other exporters");
            }
            SpanExporter noop = SpanExporter.composite((SpanExporter[])new SpanExporter[0]);
            SpanExporter customized = spanExporterCustomizer.apply((SpanExporter)noop, config);
            if (customized == noop) {
                return Collections.emptyMap();
            }
            return Collections.singletonMap(EXPORTER_NONE, customized);
        }
        if (exporterNames.isEmpty()) {
            exporterNames = Collections.singleton("otlp");
        }
        NamedSpiManager<SpanExporter> spiExportersManager = SpanExporterConfiguration.spanExporterSpiManager(config, serviceClassLoader);
        return exporterNames.stream().collect(Collectors.toMap(Function.identity(), exporterName -> (SpanExporter)spanExporterCustomizer.apply(SpanExporterConfiguration.configureExporter(exporterName, config, spiExportersManager, meterProvider), config)));
    }

    static NamedSpiManager<SpanExporter> spanExporterSpiManager(ConfigProperties config, ClassLoader serviceClassLoader) {
        return SpiUtil.loadConfigurable(ConfigurableSpanExporterProvider.class, ConfigurableSpanExporterProvider::getName, ConfigurableSpanExporterProvider::createExporter, config, serviceClassLoader);
    }

    static SpanExporter configureExporter(String name, ConfigProperties config, NamedSpiManager<SpanExporter> spiExportersManager, MeterProvider meterProvider) {
        switch (name) {
            case "otlp": {
                return SpanExporterConfiguration.configureOtlp(config, meterProvider);
            }
            case "jaeger": {
                return SpanExporterConfiguration.configureJaeger(config, meterProvider);
            }
        }
        SpanExporter spiExporter = spiExportersManager.getByName(name);
        if (spiExporter == null) {
            String artifactId = EXPORTER_ARTIFACT_ID_BY_NAME.get(name);
            if (artifactId != null) {
                throw new ConfigurationException("otel.traces.exporter set to \"" + name + "\" but " + artifactId + " not found on classpath. Make sure to add it as a dependency.");
            }
            throw new ConfigurationException("Unrecognized value for otel.traces.exporter: " + name);
        }
        return spiExporter;
    }

    static SpanExporter configureOtlp(ConfigProperties config, MeterProvider meterProvider) {
        String protocol = OtlpConfigUtil.getOtlpProtocol("traces", config);
        if (protocol.equals("http/protobuf")) {
            ClasspathUtil.checkClassExists("io.opentelemetry.exporter.otlp.http.trace.OtlpHttpSpanExporter", "OTLP HTTP Trace Exporter", "opentelemetry-exporter-otlp-http-trace");
            OtlpHttpSpanExporterBuilder builder = OtlpHttpSpanExporter.builder();
            OtlpConfigUtil.configureOtlpExporterBuilder("traces", config, arg_0 -> ((OtlpHttpSpanExporterBuilder)builder).setEndpoint(arg_0), (arg_0, arg_1) -> ((OtlpHttpSpanExporterBuilder)builder).addHeader(arg_0, arg_1), arg_0 -> ((OtlpHttpSpanExporterBuilder)builder).setCompression(arg_0), arg_0 -> ((OtlpHttpSpanExporterBuilder)builder).setTimeout(arg_0), arg_0 -> ((OtlpHttpSpanExporterBuilder)builder).setTrustedCertificates(arg_0), (arg_0, arg_1) -> ((OtlpHttpSpanExporterBuilder)builder).setClientTls(arg_0, arg_1), retryPolicy -> RetryUtil.setRetryPolicyOnDelegate((Object)builder, (RetryPolicy)retryPolicy));
            builder.setMeterProvider(meterProvider);
            return builder.build();
        }
        if (protocol.equals("grpc")) {
            ClasspathUtil.checkClassExists("io.opentelemetry.exporter.otlp.trace.OtlpGrpcSpanExporter", "OTLP gRPC Trace Exporter", "opentelemetry-exporter-otlp");
            OtlpGrpcSpanExporterBuilder builder = OtlpGrpcSpanExporter.builder();
            OtlpConfigUtil.configureOtlpExporterBuilder("traces", config, arg_0 -> ((OtlpGrpcSpanExporterBuilder)builder).setEndpoint(arg_0), (arg_0, arg_1) -> ((OtlpGrpcSpanExporterBuilder)builder).addHeader(arg_0, arg_1), arg_0 -> ((OtlpGrpcSpanExporterBuilder)builder).setCompression(arg_0), arg_0 -> ((OtlpGrpcSpanExporterBuilder)builder).setTimeout(arg_0), arg_0 -> ((OtlpGrpcSpanExporterBuilder)builder).setTrustedCertificates(arg_0), (arg_0, arg_1) -> ((OtlpGrpcSpanExporterBuilder)builder).setClientTls(arg_0, arg_1), retryPolicy -> RetryUtil.setRetryPolicyOnDelegate((Object)builder, (RetryPolicy)retryPolicy));
            builder.setMeterProvider(meterProvider);
            return builder.build();
        }
        throw new ConfigurationException("Unsupported OTLP traces protocol: " + protocol);
    }

    private static SpanExporter configureJaeger(ConfigProperties config, MeterProvider meterProvider) {
        Duration timeout;
        ClasspathUtil.checkClassExists("io.opentelemetry.exporter.jaeger.JaegerGrpcSpanExporter", "Jaeger gRPC Exporter", "opentelemetry-exporter-jaeger");
        JaegerGrpcSpanExporterBuilder builder = JaegerGrpcSpanExporter.builder();
        String endpoint = config.getString("otel.exporter.jaeger.endpoint");
        if (endpoint != null) {
            builder.setEndpoint(endpoint);
        }
        if ((timeout = config.getDuration("otel.exporter.jaeger.timeout")) != null) {
            builder.setTimeout(timeout);
        }
        builder.setMeterProvider(meterProvider);
        return builder.build();
    }

    private SpanExporterConfiguration() {
    }

    static {
        EXPORTER_ARTIFACT_ID_BY_NAME.put("logging", "opentelemetry-exporter-logging");
        EXPORTER_ARTIFACT_ID_BY_NAME.put("logging-otlp", "opentelemetry-exporter-logging-otlp");
        EXPORTER_ARTIFACT_ID_BY_NAME.put("zipkin", "opentelemetry-exporter-zipkin");
    }
}

