/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.sis.internal.referencing.DirectPositionView;
import org.apache.sis.internal.referencing.RTreeNode;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.referencing.operation.transform.AbstractMathTransform;
import org.apache.sis.referencing.operation.transform.IterationStrategy;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Utilities;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;

class SpecializableTransform
extends AbstractMathTransform
implements Serializable {
    private static final long serialVersionUID = -7379277748632094312L;
    private final MathTransform global;
    private final RTreeNode domains;
    private MathTransform inverse;

    SpecializableTransform(MathTransform mathTransform, Map<Envelope, MathTransform> map) {
        this.global = mathTransform;
        RTreeNode rTreeNode = null;
        int n = mathTransform.getSourceDimensions();
        int n2 = mathTransform.getTargetDimensions();
        for (Map.Entry<Envelope, MathTransform> entry : map.entrySet()) {
            MathTransform mathTransform2 = entry.getValue();
            ArgumentChecks.ensureDimensionsMatch("specializations", n, n2, mathTransform2);
            List<Object> list = Collections.emptyList();
            if (mathTransform2 instanceof SpecializableTransform) {
                list = ((SpecializableTransform)mathTransform2).roots();
                mathTransform2 = ((SpecializableTransform)mathTransform2).global;
            }
            SubArea subArea = new SubArea(entry.getKey(), mathTransform2);
            ArgumentChecks.ensureDimensionMatches("envelope", n, subArea);
            if (subArea.isEmpty()) continue;
            if (rTreeNode == null) {
                rTreeNode = subArea;
            } else {
                rTreeNode.addNode(subArea);
            }
            for (SubArea subArea2 : list) {
                SubArea subArea3 = new SubArea(subArea2, subArea2.transform);
                subArea3.intersect(subArea);
                if (subArea3.isEmpty()) continue;
                rTreeNode.addNode(subArea3);
            }
        }
        this.domains = rTreeNode != null ? rTreeNode.finish() : null;
    }

    private List<SubArea> roots() {
        if (this.domains == null) {
            return Collections.emptyList();
        }
        if (this.domains instanceof SubArea) {
            return Collections.singletonList((SubArea)this.domains);
        }
        return this.domains.getChildren();
    }

    final MathTransform getSubstitute() {
        return this.domains == null ? this.global : null;
    }

    @Override
    public final int getSourceDimensions() {
        return this.global.getSourceDimensions();
    }

    @Override
    public final int getTargetDimensions() {
        return this.global.getTargetDimensions();
    }

    private SubArea locate(DirectPosition directPosition) {
        RTreeNode rTreeNode = RTreeNode.locate(this.domains, directPosition);
        return rTreeNode instanceof SubArea ? (SubArea)rTreeNode : null;
    }

    private MathTransform forDomain(DirectPosition directPosition) {
        RTreeNode rTreeNode = RTreeNode.locate(this.domains, directPosition);
        return rTreeNode instanceof SubArea ? ((SubArea)rTreeNode).transform : this.global;
    }

    @Override
    public final DirectPosition transform(DirectPosition directPosition, DirectPosition directPosition2) throws TransformException {
        return this.forDomain(directPosition).transform(directPosition, directPosition2);
    }

    @Override
    public final Matrix derivative(DirectPosition directPosition) throws TransformException {
        return this.forDomain(directPosition).derivative(directPosition);
    }

    @Override
    public final Matrix transform(double[] dArray, int n, double[] dArray2, int n2, boolean bl) throws TransformException {
        Matrix matrix;
        DirectPositionView.Double double_ = new DirectPositionView.Double(dArray, n, this.global.getSourceDimensions());
        MathTransform mathTransform = this.forDomain(double_);
        if (mathTransform instanceof AbstractMathTransform) {
            return ((AbstractMathTransform)mathTransform).transform(dArray, n, dArray2, n2, bl);
        }
        Matrix matrix2 = matrix = bl ? mathTransform.derivative((DirectPosition)double_) : null;
        if (dArray2 != null) {
            mathTransform.transform(dArray, n, dArray2, n2, 1);
        }
        return matrix;
    }

    private void transform(TransformCall transformCall, DirectPositionView directPositionView, int n, int n2, int n3, int n4) throws TransformException {
        boolean bl = n2 < 0;
        SubArea subArea = this.locate(directPositionView);
        while (n4 > 0) {
            MathTransform mathTransform;
            int n5 = directPositionView.offset;
            if (subArea == null) {
                mathTransform = this.global;
                do {
                    directPositionView.offset += n2;
                } while (--n4 > 0 && (subArea = this.locate(directPositionView)) == null);
            } else {
                RTreeNode rTreeNode = subArea;
                mathTransform = subArea.transform;
                do {
                    directPositionView.offset += n2;
                } while (--n4 > 0 && (rTreeNode = SubArea.locate(subArea, directPositionView)) == subArea);
                subArea = rTreeNode instanceof SubArea ? rTreeNode : null;
            }
            int n6 = (directPositionView.offset - n5) / n2;
            int n7 = n;
            n += n3 * n6;
            if (bl) {
                n5 = directPositionView.offset - n2;
                n7 = n - n3;
            }
            transformCall.apply(mathTransform, n5, n7, n6);
        }
    }

    @Override
    public final void transform(double[] dArray, int n4, double[] dArray2, int n5, int n6) throws TransformException {
        int n7 = this.getSourceDimensions();
        int n8 = this.getTargetDimensions();
        if (dArray == dArray2) {
            switch (IterationStrategy.suggest(n4, n7, n5, n8, n6)) {
                case ASCENDING: {
                    break;
                }
                case DESCENDING: {
                    n4 += (n6 - 1) * n7;
                    n7 = -n7;
                    n5 += (n6 - 1) * n8;
                    n8 = -n8;
                    break;
                }
                default: {
                    dArray = Arrays.copyOfRange(dArray, n4, n4 + n6 * n7);
                    n4 = 0;
                }
            }
        }
        double[] dArray3 = dArray;
        this.transform((mathTransform, n, n2, n3) -> mathTransform.transform(dArray3, n, dArray2, n2, n3), new DirectPositionView.Double(dArray, n4, Math.abs(n7)), n5, n7, n8, n6);
    }

    @Override
    public final void transform(float[] fArray, int n4, float[] fArray2, int n5, int n6) throws TransformException {
        int n7 = this.getSourceDimensions();
        int n8 = this.getTargetDimensions();
        if (fArray == fArray2) {
            switch (IterationStrategy.suggest(n4, n7, n5, n8, n6)) {
                case ASCENDING: {
                    break;
                }
                case DESCENDING: {
                    n4 += (n6 - 1) * n7;
                    n7 = -n7;
                    n5 += (n6 - 1) * n8;
                    n8 = -n8;
                    break;
                }
                default: {
                    fArray = Arrays.copyOfRange(fArray, n4, n4 + n6 * n7);
                    n4 = 0;
                }
            }
        }
        float[] fArray3 = fArray;
        this.transform((mathTransform, n, n2, n3) -> mathTransform.transform(fArray3, n, fArray2, n2, n3), new DirectPositionView.Float(fArray, n4, Math.abs(n7)), n5, n7, n8, n6);
    }

    @Override
    public final void transform(double[] dArray, int n4, float[] fArray, int n5, int n6) throws TransformException {
        int n7 = this.getSourceDimensions();
        int n8 = this.getTargetDimensions();
        this.transform((mathTransform, n, n2, n3) -> mathTransform.transform(dArray, n, fArray, n2, n3), new DirectPositionView.Double(dArray, n4, n7), n5, n7, n8, n6);
    }

    @Override
    public final void transform(float[] fArray, int n4, double[] dArray, int n5, int n6) throws TransformException {
        int n7 = this.getSourceDimensions();
        int n8 = this.getTargetDimensions();
        this.transform((mathTransform, n, n2, n3) -> mathTransform.transform(fArray, n, dArray, n2, n3), new DirectPositionView.Float(fArray, n4, n7), n5, n7, n8, n6);
    }

    @Override
    protected final int computeHashCode() {
        return super.computeHashCode() + 7 * this.global.hashCode() ^ Objects.hashCode(this.domains);
    }

    @Override
    public final boolean equals(Object object, ComparisonMode comparisonMode) {
        if (super.equals(object, comparisonMode)) {
            SpecializableTransform specializableTransform = (SpecializableTransform)object;
            return Utilities.deepEquals(this.global, specializableTransform.global, comparisonMode) && Objects.equals(this.domains, specializableTransform.domains);
        }
        return false;
    }

    @Override
    protected final String formatTo(Formatter formatter) {
        formatter.newLine();
        formatter.append(this.global);
        RTreeNode.walk(this.domains, rTreeNode -> {
            if (rTreeNode instanceof SubArea) {
                ((SubArea)rTreeNode).format(formatter);
            }
        });
        formatter.setInvalidWKT(SpecializableTransform.class, null);
        return "Specializable_MT";
    }

    @Override
    public synchronized MathTransform inverse() throws NoninvertibleTransformException {
        if (this.inverse == null) {
            this.inverse = this.createInverse();
        }
        return this.inverse;
    }

    Inverse createInverse() throws NoninvertibleTransformException {
        return new Inverse(this);
    }

    private static final class SubArea
    extends RTreeNode {
        private static final long serialVersionUID = -7668993675003269862L;
        final MathTransform transform;
        MathTransform inverse;

        SubArea(Envelope envelope, MathTransform mathTransform) {
            super(envelope);
            this.transform = mathTransform;
        }

        final void createInverseTransform() throws NoninvertibleTransformException {
            this.inverse = this.transform.inverse();
            for (RTreeNode rTreeNode : this.getChildren()) {
                ((SubArea)rTreeNode).createInverseTransform();
            }
        }

        final void format(Formatter formatter) {
            formatter.newLine();
            formatter.append(this);
            formatter.newLine();
            formatter.append(this.transform);
        }

        @Override
        public int hashCode() {
            return super.hashCode() ^ this.transform.hashCode();
        }

        @Override
        public boolean equals(Object object) {
            return super.equals(object) && this.transform.equals((Object)((SubArea)object).transform);
        }
    }

    @FunctionalInterface
    private static interface TransformCall {
        public void apply(MathTransform var1, int var2, int var3, int var4) throws TransformException;
    }

    static class Inverse
    extends AbstractMathTransform.Inverse
    implements Serializable {
        private static final long serialVersionUID = 1060617594604917167L;
        private final SpecializableTransform forward;
        private final MathTransform global;

        Inverse(SpecializableTransform specializableTransform) throws NoninvertibleTransformException {
            this.forward = specializableTransform;
            this.global = specializableTransform.global.inverse();
            for (SubArea subArea : specializableTransform.roots()) {
                subArea.createInverseTransform();
            }
        }

        @Override
        public MathTransform inverse() {
            return this.forward;
        }

        @Override
        public final DirectPosition transform(DirectPosition directPosition, DirectPosition directPosition2) throws TransformException {
            double[] dArray = directPosition.getCoordinate();
            SubArea subArea = this.forward.locate(directPosition2 = this.global.transform(directPosition, directPosition2));
            if (subArea != null) {
                directPosition2 = subArea.inverse.transform((DirectPosition)new DirectPositionView.Double(dArray), directPosition2);
            }
            return directPosition2;
        }

        @Override
        public final Matrix derivative(DirectPosition directPosition) throws TransformException {
            return this.transform(directPosition.getCoordinate(), 0, null, 0, true);
        }

        @Override
        public final Matrix transform(double[] dArray, int n, double[] dArray2, int n2, boolean bl) throws TransformException {
            Matrix matrix;
            int n3 = this.global.getSourceDimensions();
            int n4 = this.global.getTargetDimensions();
            if (dArray2 == null) {
                dArray2 = new double[n4];
                n2 = 0;
            } else if (dArray == dArray2 && n + n3 > n2 && n < n2 + n4) {
                dArray = Arrays.copyOfRange(dArray, n, n3);
                n = 0;
            }
            MathTransform mathTransform = this.global;
            boolean bl2 = false;
            do {
                if (mathTransform instanceof AbstractMathTransform) {
                    matrix = ((AbstractMathTransform)mathTransform).transform(dArray, n, dArray2, n2, bl);
                } else {
                    mathTransform.transform(dArray, n, dArray2, n2, 1);
                    Matrix matrix2 = matrix = bl ? mathTransform.derivative((DirectPosition)new DirectPositionView.Double(dArray, n, n3)) : null;
                }
                if (bl2) break;
                SubArea subArea = this.forward.locate(new DirectPositionView.Double(dArray2, n2, n4));
                if (subArea == null) continue;
                mathTransform = subArea.inverse;
                bl2 = true;
            } while (bl2);
            return matrix;
        }

        private void transform(TransformCall transformCall, double[] dArray, int n, int n2, int n3, int n4, int n5) throws TransformException {
            transformCall.apply(this.global, n, n2, n5);
            DirectPositionView.Double double_ = new DirectPositionView.Double(dArray, n2, n4);
            while (n5 > 0) {
                SubArea subArea = this.forward.locate(double_);
                if (subArea == null) {
                    double_.offset += n4;
                    --n5;
                    continue;
                }
                do {
                    RTreeNode rTreeNode = subArea;
                    int n6 = (double_.offset - n2) / n4;
                    n += n6 * n3;
                    n2 = double_.offset;
                    do {
                        double_.offset += n4;
                        if (--n5 > 0) continue;
                        rTreeNode = null;
                        break;
                    } while ((rTreeNode = RTreeNode.locate(subArea, double_)) == subArea);
                    n6 = (double_.offset - n2) / n4;
                    transformCall.apply(subArea.inverse, n, n2, n6);
                    subArea = rTreeNode instanceof SubArea ? rTreeNode : null;
                    n += n3 * n6;
                    n2 = double_.offset;
                } while (subArea != null);
            }
        }

        @Override
        public void transform(double[] dArray, int n4, double[] dArray2, int n5, int n6) throws TransformException {
            int n7;
            if (n6 <= 0) {
                return;
            }
            int n8 = this.global.getSourceDimensions();
            int n9 = this.global.getTargetDimensions();
            if (dArray == dArray2 && ((n7 = n4 + n6 * n8) > n5 || n5 + n6 * n9 > n4)) {
                dArray = Arrays.copyOfRange(dArray, n4, n7);
                n4 = 0;
            }
            double[] dArray3 = dArray;
            this.transform((mathTransform, n, n2, n3) -> mathTransform.transform(dArray3, n, dArray2, n2, n3), dArray2, n4, n5, n8, n9, n6);
        }

        @Override
        public void transform(float[] fArray, int n4, float[] fArray2, int n5, int n6) throws TransformException {
            if (n6 <= 0) {
                return;
            }
            int n7 = this.global.getSourceDimensions();
            int n8 = this.global.getTargetDimensions();
            double[] dArray = new double[n6 * n8];
            this.transform((mathTransform, n, n2, n3) -> mathTransform.transform(fArray, n, dArray, n2, n3), dArray, n4, 0, n7, n8, n6);
            n6 *= n8;
            for (int i = 0; i < n6; ++i) {
                fArray2[n5++] = (float)dArray[i];
            }
        }

        @Override
        public void transform(double[] dArray, int n4, float[] fArray, int n5, int n6) throws TransformException {
            if (n6 <= 0) {
                return;
            }
            int n7 = this.global.getSourceDimensions();
            int n8 = this.global.getTargetDimensions();
            double[] dArray2 = new double[n6 * n8];
            this.transform((mathTransform, n, n2, n3) -> mathTransform.transform(dArray, n, dArray2, n2, n3), dArray2, n4, 0, n7, n8, n6);
            n6 *= n8;
            for (int i = 0; i < n6; ++i) {
                fArray[n5++] = (float)dArray2[i];
            }
        }

        @Override
        public void transform(float[] fArray, int n4, double[] dArray, int n5, int n6) throws TransformException {
            if (n6 <= 0) {
                return;
            }
            int n7 = this.global.getSourceDimensions();
            int n8 = this.global.getTargetDimensions();
            this.transform((mathTransform, n, n2, n3) -> mathTransform.transform(fArray, n, dArray, n2, n3), dArray, n4, n5, n7, n8, n6);
        }
    }
}

