/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.proj4j.datum;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.locationtech.proj4j.ProjCoordinate;
import org.locationtech.proj4j.datum.Ellipsoid;
import org.locationtech.proj4j.datum.Grid;
import org.locationtech.proj4j.util.ProjectionMath;

public class Datum
implements Serializable {
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_WGS84 = 1;
    public static final int TYPE_3PARAM = 2;
    public static final int TYPE_7PARAM = 3;
    public static final int TYPE_GRIDSHIFT = 4;
    private static final double[] DEFAULT_TRANSFORM = new double[]{0.0, 0.0, 0.0};
    public static final Datum WGS84 = new Datum("WGS84", 0.0, 0.0, 0.0, Ellipsoid.WGS84, "WGS84");
    public static final Datum GGRS87 = new Datum("GGRS87", -199.87, 74.79, 246.62, Ellipsoid.GRS80, "Greek_Geodetic_Reference_System_1987");
    public static final Datum NAD83 = new Datum("NAD83", 0.0, 0.0, 0.0, Ellipsoid.GRS80, "North_American_Datum_1983");
    public static final Datum NAD27;
    public static final Datum POTSDAM;
    public static final Datum CARTHAGE;
    public static final Datum HERMANNSKOGEL;
    public static final Datum IRE65;
    public static final Datum NZGD49;
    public static final Datum OSGB36;
    private String code;
    private String name;
    private Ellipsoid ellipsoid;
    private double[] transform = DEFAULT_TRANSFORM;
    private List<Grid> grids = null;
    public static final double ELLIPSOID_E2_TOLERANCE = 5.0E-11;

    private Datum(String code, List<Grid> grids, Ellipsoid ellipsoid, String name) {
        this(code, null, grids, ellipsoid, name);
    }

    public Datum(String code, double deltaX, double deltaY, double deltaZ, Ellipsoid ellipsoid, String name) {
        this(code, new double[]{deltaX, deltaY, deltaZ}, null, ellipsoid, name);
    }

    public Datum(String code, double deltaX, double deltaY, double deltaZ, double rx, double ry, double rz, double mbf, Ellipsoid ellipsoid, String name) {
        this(code, new double[]{deltaX, deltaY, deltaZ, rx, ry, rz, mbf}, null, ellipsoid, name);
    }

    public Datum(String code, double[] transform, List<Grid> grids, Ellipsoid ellipsoid, String name) {
        this.code = code;
        this.name = name;
        this.ellipsoid = ellipsoid;
        this.grids = grids;
        if (transform != null && transform.length > 3) {
            transform[3] = transform[3] * 4.84813681109536E-6;
            transform[4] = transform[4] * 4.84813681109536E-6;
            transform[5] = transform[5] * 4.84813681109536E-6;
            transform[6] = transform[6] / 1000000.0 + 1.0;
        }
        this.transform = transform;
    }

    public String getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "[Datum-" + this.name + "]";
    }

    public Ellipsoid getEllipsoid() {
        return this.ellipsoid;
    }

    public double[] getTransformToWGS84() {
        return this.transform;
    }

    public int getTransformType() {
        if (this.grids != null && this.grids.size() > 0) {
            return 4;
        }
        if (Ellipsoid.WGS84.equals(this.ellipsoid) || Ellipsoid.GRS80.equals(this.ellipsoid)) {
            if (this.transform == null) {
                return 1;
            }
            if (ProjectionMath.isIdentity(this.transform)) {
                return 1;
            }
        }
        if (this.transform == null) {
            return 0;
        }
        if (this.transform.length == 3) {
            return 2;
        }
        if (this.transform.length == 7) {
            return 3;
        }
        return 0;
    }

    public boolean hasTransformToWGS84() {
        int transformType = this.getTransformType();
        return transformType == 2 || transformType == 3;
    }

    public boolean isEqual(Datum datum) {
        if (this.getTransformType() != datum.getTransformType()) {
            return false;
        }
        if (this.ellipsoid.getEquatorRadius() != this.ellipsoid.getEquatorRadius() && Math.abs(this.ellipsoid.getEccentricitySquared() - datum.ellipsoid.getEccentricitySquared()) > 5.0E-11) {
            return false;
        }
        if (this.getTransformType() == 2 || this.getTransformType() == 3) {
            for (int i = 0; i < this.transform.length; ++i) {
                if (this.transform[i] == datum.transform[i]) continue;
                return false;
            }
            return true;
        }
        if (this.getTransformType() == 4) {
            return this.grids.equals(datum.grids);
        }
        return true;
    }

    public void transformFromGeocentricToWgs84(ProjCoordinate p) {
        if (this.transform.length == 3) {
            p.x += this.transform[0];
            p.y += this.transform[1];
            p.z += this.transform[2];
        } else if (this.transform.length == 7) {
            double Dx_BF = this.transform[0];
            double Dy_BF = this.transform[1];
            double Dz_BF = this.transform[2];
            double Rx_BF = this.transform[3];
            double Ry_BF = this.transform[4];
            double Rz_BF = this.transform[5];
            double M_BF = this.transform[6];
            double x_out = M_BF * (p.x - Rz_BF * p.y + Ry_BF * p.z) + Dx_BF;
            double y_out = M_BF * (Rz_BF * p.x + p.y - Rx_BF * p.z) + Dy_BF;
            double z_out = M_BF * (-Ry_BF * p.x + Rx_BF * p.y + p.z) + Dz_BF;
            p.x = x_out;
            p.y = y_out;
            p.z = z_out;
        }
    }

    public void transformToGeocentricFromWgs84(ProjCoordinate p) {
        if (this.transform.length == 3) {
            p.x -= this.transform[0];
            p.y -= this.transform[1];
            p.z -= this.transform[2];
        } else if (this.transform.length == 7) {
            double Dx_BF = this.transform[0];
            double Dy_BF = this.transform[1];
            double Dz_BF = this.transform[2];
            double Rx_BF = this.transform[3];
            double Ry_BF = this.transform[4];
            double Rz_BF = this.transform[5];
            double M_BF = this.transform[6];
            double x_tmp = (p.x - Dx_BF) / M_BF;
            double y_tmp = (p.y - Dy_BF) / M_BF;
            double z_tmp = (p.z - Dz_BF) / M_BF;
            p.x = x_tmp + Rz_BF * y_tmp - Ry_BF * z_tmp;
            p.y = -Rz_BF * x_tmp + y_tmp + Rx_BF * z_tmp;
            p.z = Ry_BF * x_tmp - Rx_BF * y_tmp + z_tmp;
        }
    }

    public void shift(ProjCoordinate xy) {
        Grid.shift(this.grids, false, xy);
    }

    public void inverseShift(ProjCoordinate xy) {
        Grid.shift(this.grids, true, xy);
    }

    static {
        POTSDAM = new Datum("potsdam", 598.1, 73.7, 418.2, 0.202, 0.045, -2.455, 6.7, Ellipsoid.BESSEL, "Potsdam Rauenberg 1950 DHDN");
        CARTHAGE = new Datum("carthage", -263.0, 6.0, 431.0, Ellipsoid.CLARKE_1880, "Carthage 1934 Tunisia");
        HERMANNSKOGEL = new Datum("hermannskogel", 577.326, 90.129, 463.919, 5.137, 1.474, 5.297, 2.4232, Ellipsoid.BESSEL, "Hermannskogel");
        IRE65 = new Datum("ire65", 482.53, -130.596, 564.557, -1.042, -0.214, -0.631, 8.15, Ellipsoid.MOD_AIRY, "Ireland 1965");
        NZGD49 = new Datum("nzgd49", 59.47, -5.04, 187.44, 0.47, -0.1, 1.024, -4.5993, Ellipsoid.INTERNATIONAL, "New Zealand Geodetic Datum 1949");
        OSGB36 = new Datum("OSGB36", 446.448, -125.157, 542.06, 0.15, 0.247, 0.842, -20.489, Ellipsoid.AIRY, "Airy 1830");
        Datum temp = new Datum("NAD27", new ArrayList<Grid>(), Ellipsoid.CLARKE_1866, "North_American_Datum_1927");
        try {
            temp = new Datum("NAD27", Grid.fromNadGrids("@conus,@alaska,@ntv2_0.gsb,@ntv1_can.dat"), Ellipsoid.CLARKE_1866, "North_American_Datum_1927");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        NAD27 = temp;
    }
}

