/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.mapping;

import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.IntConsumer;
import java.util.function.LongConsumer;
import org.apache.solr.analytics.ExpressionFactory;
import org.apache.solr.analytics.util.function.BooleanConsumer;
import org.apache.solr.analytics.util.function.FloatConsumer;
import org.apache.solr.analytics.value.AnalyticsValue;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.BooleanValue;
import org.apache.solr.analytics.value.BooleanValueStream;
import org.apache.solr.analytics.value.DateValue;
import org.apache.solr.analytics.value.DateValueStream;
import org.apache.solr.analytics.value.DoubleValue;
import org.apache.solr.analytics.value.DoubleValueStream;
import org.apache.solr.analytics.value.FloatValue;
import org.apache.solr.analytics.value.FloatValueStream;
import org.apache.solr.analytics.value.IntValue;
import org.apache.solr.analytics.value.IntValueStream;
import org.apache.solr.analytics.value.LongValue;
import org.apache.solr.analytics.value.LongValueStream;
import org.apache.solr.analytics.value.StringValue;
import org.apache.solr.analytics.value.StringValueStream;
import org.apache.solr.common.SolrException;

public class RemoveFunction {
    public static final String name = "remove";
    public static final ExpressionFactory.CreatorFunction creatorFunction = params -> {
        if (params.length != 2) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The remove function requires 2 paramaters, " + params.length + " found.");
        }
        if (!(params[1] instanceof AnalyticsValue)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The remove function requires the remove (2nd) paramater to be single-valued.");
        }
        AnalyticsValueStream baseExpr = params[0];
        AnalyticsValue removeExpr = (AnalyticsValue)params[1];
        if (baseExpr instanceof DateValue && removeExpr instanceof DateValue) {
            return new DateRemoveFunction((DateValue)baseExpr, (DateValue)removeExpr);
        }
        if (baseExpr instanceof DateValueStream && removeExpr instanceof DateValue) {
            return new DateStreamRemoveFunction((DateValueStream)baseExpr, (DateValue)removeExpr);
        }
        if (baseExpr instanceof BooleanValue && removeExpr instanceof BooleanValue) {
            return new BooleanRemoveFunction((BooleanValue)baseExpr, (BooleanValue)removeExpr);
        }
        if (baseExpr instanceof BooleanValueStream && removeExpr instanceof BooleanValue) {
            return new BooleanStreamRemoveFunction((BooleanValueStream)baseExpr, (BooleanValue)removeExpr);
        }
        if (baseExpr instanceof IntValue && removeExpr instanceof IntValue) {
            return new IntRemoveFunction((IntValue)baseExpr, (IntValue)removeExpr);
        }
        if (baseExpr instanceof IntValueStream && removeExpr instanceof IntValue) {
            return new IntStreamRemoveFunction((IntValueStream)baseExpr, (IntValue)removeExpr);
        }
        if (baseExpr instanceof LongValue && removeExpr instanceof LongValue) {
            return new LongRemoveFunction((LongValue)baseExpr, (LongValue)removeExpr);
        }
        if (baseExpr instanceof LongValueStream && removeExpr instanceof LongValue) {
            return new LongStreamRemoveFunction((LongValueStream)baseExpr, (LongValue)removeExpr);
        }
        if (baseExpr instanceof FloatValue && removeExpr instanceof FloatValue) {
            return new FloatRemoveFunction((FloatValue)baseExpr, (FloatValue)removeExpr);
        }
        if (baseExpr instanceof FloatValueStream && removeExpr instanceof FloatValue) {
            return new FloatStreamRemoveFunction((FloatValueStream)baseExpr, (FloatValue)removeExpr);
        }
        if (baseExpr instanceof DoubleValue && removeExpr instanceof DoubleValue) {
            return new DoubleRemoveFunction((DoubleValue)baseExpr, (DoubleValue)removeExpr);
        }
        if (baseExpr instanceof DoubleValueStream && removeExpr instanceof DoubleValue) {
            return new DoubleStreamRemoveFunction((DoubleValueStream)baseExpr, (DoubleValue)removeExpr);
        }
        if (baseExpr instanceof StringValue && removeExpr instanceof StringValue) {
            return new StringRemoveFunction((StringValue)baseExpr, (StringValue)removeExpr);
        }
        if (baseExpr instanceof StringValueStream && removeExpr instanceof StringValue) {
            return new StringStreamRemoveFunction((StringValueStream)baseExpr, (StringValue)removeExpr);
        }
        if (baseExpr instanceof AnalyticsValue) {
            return new ValueRemoveFunction((AnalyticsValue)baseExpr, removeExpr);
        }
        return new StreamRemoveFunction(baseExpr, removeExpr);
    };

    static class StringRemoveFunction
    extends StringValue.AbstractStringValue {
        private final StringValue baseExpr;
        private final StringValue removeExpr;
        public static final String name = "remove";
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;
        boolean exists = false;

        public StringRemoveFunction(StringValue baseExpr, StringValue removeExpr) throws SolrException {
            this.baseExpr = baseExpr;
            this.removeExpr = removeExpr;
            this.exprStr = AnalyticsValueStream.createExpressionString("remove", baseExpr, removeExpr);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, baseExpr, removeExpr);
        }

        @Override
        public String getString() {
            String value = this.baseExpr.getString();
            this.exists = false;
            if (this.baseExpr.exists()) {
                this.exists = value.equals(this.removeExpr.getString()) ? !this.removeExpr.exists() : true;
            }
            return value;
        }

        @Override
        public boolean exists() {
            return this.exists;
        }

        @Override
        public String getName() {
            return "remove";
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class StringStreamRemoveFunction
    extends StringValueStream.AbstractStringValueStream {
        private final StringValueStream baseExpr;
        private final StringValue removeExpr;
        public static final String name = "remove";
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;

        public StringStreamRemoveFunction(StringValueStream baseExpr, StringValue removeExpr) throws SolrException {
            this.baseExpr = baseExpr;
            this.removeExpr = removeExpr;
            this.exprStr = AnalyticsValueStream.createExpressionString("remove", baseExpr, removeExpr);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, baseExpr, removeExpr);
        }

        @Override
        public void streamStrings(Consumer<String> cons) {
            String removeValue = this.removeExpr.getString();
            if (this.removeExpr.exists()) {
                this.baseExpr.streamStrings(value -> {
                    if (!removeValue.equals(value)) {
                        cons.accept((String)value);
                    }
                });
            } else {
                this.baseExpr.streamStrings(cons);
            }
        }

        @Override
        public String getName() {
            return "remove";
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class DateRemoveFunction
    extends DateValue.AbstractDateValue {
        private final DateValue baseExpr;
        private final DateValue removeExpr;
        public static final String name = "remove";
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;
        boolean exists = false;

        public DateRemoveFunction(DateValue baseExpr, DateValue removeExpr) throws SolrException {
            this.baseExpr = baseExpr;
            this.removeExpr = removeExpr;
            this.exprStr = AnalyticsValueStream.createExpressionString("remove", baseExpr, removeExpr);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, baseExpr, removeExpr);
        }

        @Override
        public long getLong() {
            long value = this.baseExpr.getLong();
            this.exists = false;
            if (this.baseExpr.exists()) {
                this.exists = value == this.removeExpr.getLong() ? !this.removeExpr.exists() : true;
            }
            return value;
        }

        @Override
        public boolean exists() {
            return this.exists;
        }

        @Override
        public String getName() {
            return "remove";
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class DateStreamRemoveFunction
    extends DateValueStream.AbstractDateValueStream {
        private final DateValueStream baseExpr;
        private final DateValue removeExpr;
        public static final String name = "remove";
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;

        public DateStreamRemoveFunction(DateValueStream baseExpr, DateValue removeExpr) throws SolrException {
            this.baseExpr = baseExpr;
            this.removeExpr = removeExpr;
            this.exprStr = AnalyticsValueStream.createExpressionString("remove", baseExpr, removeExpr);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, baseExpr, removeExpr);
        }

        @Override
        public void streamLongs(LongConsumer cons) {
            long removeValue = this.removeExpr.getLong();
            if (this.removeExpr.exists()) {
                this.baseExpr.streamLongs(value -> {
                    if (removeValue != value) {
                        cons.accept(value);
                    }
                });
            } else {
                this.baseExpr.streamLongs(cons);
            }
        }

        @Override
        public String getName() {
            return "remove";
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class DoubleRemoveFunction
    extends DoubleValue.AbstractDoubleValue {
        private final DoubleValue baseExpr;
        private final DoubleValue removeExpr;
        public static final String name = "remove";
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;
        boolean exists = false;

        public DoubleRemoveFunction(DoubleValue baseExpr, DoubleValue removeExpr) throws SolrException {
            this.baseExpr = baseExpr;
            this.removeExpr = removeExpr;
            this.exprStr = AnalyticsValueStream.createExpressionString("remove", baseExpr, removeExpr);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, baseExpr, removeExpr);
        }

        @Override
        public double getDouble() {
            double value = this.baseExpr.getDouble();
            this.exists = false;
            if (this.baseExpr.exists()) {
                this.exists = value == this.removeExpr.getDouble() ? !this.removeExpr.exists() : true;
            }
            return value;
        }

        @Override
        public boolean exists() {
            return this.exists;
        }

        @Override
        public String getName() {
            return "remove";
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class DoubleStreamRemoveFunction
    extends DoubleValueStream.AbstractDoubleValueStream {
        private final DoubleValueStream baseExpr;
        private final DoubleValue removeExpr;
        public static final String name = "remove";
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;

        public DoubleStreamRemoveFunction(DoubleValueStream baseExpr, DoubleValue removeExpr) throws SolrException {
            this.baseExpr = baseExpr;
            this.removeExpr = removeExpr;
            this.exprStr = AnalyticsValueStream.createExpressionString("remove", baseExpr, removeExpr);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, baseExpr, removeExpr);
        }

        @Override
        public void streamDoubles(DoubleConsumer cons) {
            double removeValue = this.removeExpr.getDouble();
            if (this.removeExpr.exists()) {
                this.baseExpr.streamDoubles(value -> {
                    if (removeValue != value) {
                        cons.accept(value);
                    }
                });
            } else {
                this.baseExpr.streamDoubles(cons);
            }
        }

        @Override
        public String getName() {
            return "remove";
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class FloatRemoveFunction
    extends FloatValue.AbstractFloatValue {
        private final FloatValue baseExpr;
        private final FloatValue removeExpr;
        public static final String name = "remove";
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;
        boolean exists = false;

        public FloatRemoveFunction(FloatValue baseExpr, FloatValue removeExpr) throws SolrException {
            this.baseExpr = baseExpr;
            this.removeExpr = removeExpr;
            this.exprStr = AnalyticsValueStream.createExpressionString("remove", baseExpr, removeExpr);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, baseExpr, removeExpr);
        }

        @Override
        public float getFloat() {
            float value = this.baseExpr.getFloat();
            this.exists = false;
            if (this.baseExpr.exists()) {
                this.exists = value == this.removeExpr.getFloat() ? !this.removeExpr.exists() : true;
            }
            return value;
        }

        @Override
        public boolean exists() {
            return this.exists;
        }

        @Override
        public String getName() {
            return "remove";
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class FloatStreamRemoveFunction
    extends FloatValueStream.AbstractFloatValueStream {
        private final FloatValueStream baseExpr;
        private final FloatValue removeExpr;
        public static final String name = "remove";
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;

        public FloatStreamRemoveFunction(FloatValueStream baseExpr, FloatValue removeExpr) throws SolrException {
            this.baseExpr = baseExpr;
            this.removeExpr = removeExpr;
            this.exprStr = AnalyticsValueStream.createExpressionString("remove", baseExpr, removeExpr);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, baseExpr, removeExpr);
        }

        @Override
        public void streamFloats(FloatConsumer cons) {
            float removeValue = this.removeExpr.getFloat();
            if (this.removeExpr.exists()) {
                this.baseExpr.streamFloats(value -> {
                    if (removeValue != value) {
                        cons.accept(value);
                    }
                });
            } else {
                this.baseExpr.streamFloats(cons);
            }
        }

        @Override
        public String getName() {
            return "remove";
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class LongRemoveFunction
    extends LongValue.AbstractLongValue {
        private final LongValue baseExpr;
        private final LongValue removeExpr;
        public static final String name = "remove";
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;
        boolean exists = false;

        public LongRemoveFunction(LongValue baseExpr, LongValue removeExpr) throws SolrException {
            this.baseExpr = baseExpr;
            this.removeExpr = removeExpr;
            this.exprStr = AnalyticsValueStream.createExpressionString("remove", baseExpr, removeExpr);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, baseExpr, removeExpr);
        }

        @Override
        public long getLong() {
            long value = this.baseExpr.getLong();
            this.exists = false;
            if (this.baseExpr.exists()) {
                this.exists = value == this.removeExpr.getLong() ? !this.removeExpr.exists() : true;
            }
            return value;
        }

        @Override
        public boolean exists() {
            return this.exists;
        }

        @Override
        public String getName() {
            return "remove";
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class LongStreamRemoveFunction
    extends LongValueStream.AbstractLongValueStream {
        private final LongValueStream baseExpr;
        private final LongValue removeExpr;
        public static final String name = "remove";
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;

        public LongStreamRemoveFunction(LongValueStream baseExpr, LongValue removeExpr) throws SolrException {
            this.baseExpr = baseExpr;
            this.removeExpr = removeExpr;
            this.exprStr = AnalyticsValueStream.createExpressionString("remove", baseExpr, removeExpr);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, baseExpr, removeExpr);
        }

        @Override
        public void streamLongs(LongConsumer cons) {
            long removeValue = this.removeExpr.getLong();
            if (this.removeExpr.exists()) {
                this.baseExpr.streamLongs(value -> {
                    if (removeValue != value) {
                        cons.accept(value);
                    }
                });
            } else {
                this.baseExpr.streamLongs(cons);
            }
        }

        @Override
        public String getName() {
            return "remove";
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class IntRemoveFunction
    extends IntValue.AbstractIntValue {
        private final IntValue baseExpr;
        private final IntValue removeExpr;
        public static final String name = "remove";
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;
        boolean exists = false;

        public IntRemoveFunction(IntValue baseExpr, IntValue removeExpr) throws SolrException {
            this.baseExpr = baseExpr;
            this.removeExpr = removeExpr;
            this.exprStr = AnalyticsValueStream.createExpressionString("remove", baseExpr, removeExpr);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, baseExpr, removeExpr);
        }

        @Override
        public int getInt() {
            int value = this.baseExpr.getInt();
            this.exists = false;
            if (this.baseExpr.exists()) {
                this.exists = value == this.removeExpr.getInt() ? !this.removeExpr.exists() : true;
            }
            return value;
        }

        @Override
        public boolean exists() {
            return this.exists;
        }

        @Override
        public String getName() {
            return "remove";
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class IntStreamRemoveFunction
    extends IntValueStream.AbstractIntValueStream {
        private final IntValueStream baseExpr;
        private final IntValue removeExpr;
        public static final String name = "remove";
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;

        public IntStreamRemoveFunction(IntValueStream baseExpr, IntValue removeExpr) throws SolrException {
            this.baseExpr = baseExpr;
            this.removeExpr = removeExpr;
            this.exprStr = AnalyticsValueStream.createExpressionString("remove", baseExpr, removeExpr);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, baseExpr, removeExpr);
        }

        @Override
        public void streamInts(IntConsumer cons) {
            int removeValue = this.removeExpr.getInt();
            if (this.removeExpr.exists()) {
                this.baseExpr.streamInts(value -> {
                    if (removeValue != value) {
                        cons.accept(value);
                    }
                });
            } else {
                this.baseExpr.streamInts(cons);
            }
        }

        @Override
        public String getName() {
            return "remove";
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class BooleanRemoveFunction
    extends BooleanValue.AbstractBooleanValue {
        private final BooleanValue baseExpr;
        private final BooleanValue removeExpr;
        public static final String name = "remove";
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;
        boolean exists = false;

        public BooleanRemoveFunction(BooleanValue baseExpr, BooleanValue removeExpr) throws SolrException {
            this.baseExpr = baseExpr;
            this.removeExpr = removeExpr;
            this.exprStr = AnalyticsValueStream.createExpressionString("remove", baseExpr, removeExpr);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, baseExpr, removeExpr);
        }

        @Override
        public boolean getBoolean() {
            boolean value = this.baseExpr.getBoolean();
            this.exists = false;
            if (this.baseExpr.exists()) {
                this.exists = value == this.removeExpr.getBoolean() ? !this.removeExpr.exists() : true;
            }
            return value;
        }

        @Override
        public boolean exists() {
            return this.exists;
        }

        @Override
        public String getName() {
            return "remove";
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class BooleanStreamRemoveFunction
    extends BooleanValueStream.AbstractBooleanValueStream {
        private final BooleanValueStream baseExpr;
        private final BooleanValue removeExpr;
        public static final String name = "remove";
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;

        public BooleanStreamRemoveFunction(BooleanValueStream baseExpr, BooleanValue removeExpr) throws SolrException {
            this.baseExpr = baseExpr;
            this.removeExpr = removeExpr;
            this.exprStr = AnalyticsValueStream.createExpressionString("remove", baseExpr, removeExpr);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, baseExpr, removeExpr);
        }

        @Override
        public void streamBooleans(BooleanConsumer cons) {
            boolean removeValue = this.removeExpr.getBoolean();
            if (this.removeExpr.exists()) {
                this.baseExpr.streamBooleans(value -> {
                    if (removeValue != value) {
                        cons.accept(value);
                    }
                });
            } else {
                this.baseExpr.streamBooleans(cons);
            }
        }

        @Override
        public String getName() {
            return "remove";
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class ValueRemoveFunction
    extends AnalyticsValue.AbstractAnalyticsValue {
        private final AnalyticsValue baseExpr;
        private final AnalyticsValue removeExpr;
        public static final String name = "remove";
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;
        boolean exists = false;

        public ValueRemoveFunction(AnalyticsValue baseExpr, AnalyticsValue removeExpr) throws SolrException {
            this.baseExpr = baseExpr;
            this.removeExpr = removeExpr;
            this.exprStr = AnalyticsValueStream.createExpressionString("remove", baseExpr, removeExpr);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, baseExpr, removeExpr);
        }

        @Override
        public Object getObject() {
            Object value = this.baseExpr.getObject();
            this.exists = false;
            if (this.baseExpr.exists()) {
                this.exists = value.equals(this.removeExpr.getObject()) ? !this.removeExpr.exists() : true;
            }
            return value;
        }

        @Override
        public boolean exists() {
            return this.exists;
        }

        @Override
        public String getName() {
            return "remove";
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class StreamRemoveFunction
    extends AnalyticsValueStream.AbstractAnalyticsValueStream {
        private final AnalyticsValueStream baseExpr;
        private final AnalyticsValue removeExpr;
        public static final String name = "remove";
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;

        public StreamRemoveFunction(AnalyticsValueStream baseExpr, AnalyticsValue removeExpr) throws SolrException {
            this.baseExpr = baseExpr;
            this.removeExpr = removeExpr;
            this.exprStr = AnalyticsValueStream.createExpressionString("remove", baseExpr, removeExpr);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, baseExpr, removeExpr);
        }

        @Override
        public void streamObjects(Consumer<Object> cons) {
            Object removeValue = this.removeExpr.getObject();
            if (this.removeExpr.exists()) {
                this.baseExpr.streamObjects(value -> {
                    if (!removeValue.equals(value)) {
                        cons.accept(value);
                    }
                });
            } else {
                this.baseExpr.streamObjects(cons);
            }
        }

        @Override
        public String getName() {
            return "remove";
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }
}

