/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryRescorer;
import org.apache.lucene.search.Rescorer;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.AbstractReRankQuery;
import org.apache.solr.search.QParser;
import org.apache.solr.search.QParserPlugin;
import org.apache.solr.search.ReRankOperator;
import org.apache.solr.search.SyntaxError;

public class ReRankQParserPlugin
extends QParserPlugin {
    public static final String NAME = "rerank";
    private static Query defaultQuery = new MatchAllDocsQuery();
    public static final String RERANK_QUERY = "reRankQuery";
    public static final String RERANK_DOCS = "reRankDocs";
    public static final int RERANK_DOCS_DEFAULT = 200;
    public static final String RERANK_WEIGHT = "reRankWeight";
    public static final double RERANK_WEIGHT_DEFAULT = 2.0;
    public static final String RERANK_OPERATOR = "reRankOperator";
    public static final String RERANK_OPERATOR_DEFAULT = "add";

    @Override
    public QParser createParser(String query, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
        return new ReRankQParser(query, localParams, params, req);
    }

    private static final class ReRankQuery
    extends AbstractReRankQuery {
        private final Query reRankQuery;
        private final double reRankWeight;
        private final ReRankOperator reRankOperator;

        public int hashCode() {
            return 31 * this.classHash() + this.mainQuery.hashCode() + this.reRankQuery.hashCode() + (int)this.reRankWeight + this.reRankDocs + this.reRankOperator.hashCode();
        }

        public boolean equals(Object other) {
            return this.sameClassAs(other) && this.equalsTo((ReRankQuery)this.getClass().cast(other));
        }

        private boolean equalsTo(ReRankQuery rrq) {
            return this.mainQuery.equals((Object)rrq.mainQuery) && this.reRankQuery.equals((Object)rrq.reRankQuery) && this.reRankWeight == rrq.reRankWeight && this.reRankDocs == rrq.reRankDocs && this.reRankOperator.equals((Object)rrq.reRankOperator);
        }

        public ReRankQuery(Query reRankQuery, int reRankDocs, double reRankWeight, ReRankOperator reRankOperator) {
            super(defaultQuery, reRankDocs, (Rescorer)new ReRankQueryRescorer(reRankQuery, reRankWeight, reRankOperator));
            this.reRankQuery = reRankQuery;
            this.reRankWeight = reRankWeight;
            this.reRankOperator = reRankOperator;
        }

        @Override
        public String toString(String s) {
            StringBuilder sb = new StringBuilder(100);
            sb.append("{!").append(ReRankQParserPlugin.NAME);
            sb.append(" mainQuery='").append(this.mainQuery.toString()).append("' ");
            sb.append(ReRankQParserPlugin.RERANK_QUERY).append("='").append(this.reRankQuery.toString()).append("' ");
            sb.append(ReRankQParserPlugin.RERANK_DOCS).append('=').append(this.reRankDocs).append(' ');
            sb.append(ReRankQParserPlugin.RERANK_WEIGHT).append('=').append(this.reRankWeight).append(' ');
            sb.append(ReRankQParserPlugin.RERANK_OPERATOR).append('=').append(this.reRankOperator.toLower()).append('}');
            return sb.toString();
        }

        @Override
        protected Query rewrite(Query rewrittenMainQuery) throws IOException {
            return new ReRankQuery(this.reRankQuery, this.reRankDocs, this.reRankWeight, this.reRankOperator).wrap(rewrittenMainQuery);
        }
    }

    private static final class ReRankQueryRescorer
    extends QueryRescorer {
        final BiFloatFunction scoreCombiner;

        public ReRankQueryRescorer(Query reRankQuery, double reRankWeight, ReRankOperator reRankOperator) {
            super(reRankQuery);
            switch (reRankOperator) {
                case ADD: {
                    this.scoreCombiner = (score, second) -> (float)((double)score + reRankWeight * (double)second);
                    break;
                }
                case MULTIPLY: {
                    this.scoreCombiner = (score, second) -> (float)((double)score * reRankWeight * (double)second);
                    break;
                }
                case REPLACE: {
                    this.scoreCombiner = (score, second) -> (float)(reRankWeight * (double)second);
                    break;
                }
                default: {
                    this.scoreCombiner = null;
                    throw new IllegalArgumentException("Unexpected: reRankOperator=" + reRankOperator);
                }
            }
        }

        protected float combine(float firstPassScore, boolean secondPassMatches, float secondPassScore) {
            float score = firstPassScore;
            if (secondPassMatches) {
                return this.scoreCombiner.func(score, secondPassScore);
            }
            return score;
        }

        @FunctionalInterface
        static interface BiFloatFunction {
            public float func(float var1, float var2);
        }
    }

    private static class ReRankQParser
    extends QParser {
        public ReRankQParser(String query, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
            super(query, localParams, params, req);
        }

        @Override
        public Query parse() throws SyntaxError {
            String reRankQueryString = this.localParams.get(ReRankQParserPlugin.RERANK_QUERY);
            if (StringUtils.isBlank((CharSequence)reRankQueryString)) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "reRankQuery parameter is mandatory");
            }
            QParser reRankParser = QParser.getParser(reRankQueryString, this.req);
            Query reRankQuery = reRankParser.parse();
            int reRankDocs = this.localParams.getInt(ReRankQParserPlugin.RERANK_DOCS, 200);
            reRankDocs = Math.max(1, reRankDocs);
            double reRankWeight = this.localParams.getDouble(ReRankQParserPlugin.RERANK_WEIGHT, 2.0);
            ReRankOperator reRankOperator = ReRankOperator.get(this.localParams.get(ReRankQParserPlugin.RERANK_OPERATOR, ReRankQParserPlugin.RERANK_OPERATOR_DEFAULT));
            return new ReRankQuery(reRankQuery, reRankDocs, reRankWeight, reRankOperator);
        }
    }
}

