/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.api;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.solr.common.MapWriter;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.jersey.JacksonReflectMapWriter;
import org.apache.solr.response.SolrQueryResponse;

public class V2ApiUtils {
    private V2ApiUtils() {
    }

    public static boolean isEnabled() {
        return !"true".equals(System.getProperty("disable.v2.api", "false"));
    }

    public static void flattenMapWithPrefix(Map<String, Object> toFlatten, Map<String, Object> destination, String additionalPrefix) {
        if (toFlatten == null || toFlatten.isEmpty() || destination == null) {
            return;
        }
        toFlatten.forEach((k, v) -> destination.put(additionalPrefix + k, v));
    }

    public static void flattenToCommaDelimitedString(Map<String, Object> destination, List<String> toFlatten, String newKey) {
        String flattenedStr = String.join((CharSequence)",", toFlatten);
        destination.put(newKey, flattenedStr);
    }

    public static void squashIntoSolrResponseWithoutHeader(SolrQueryResponse rsp, JacksonReflectMapWriter mw) {
        V2ApiUtils.squashIntoNamedList(rsp.getValues(), mw, true);
    }

    public static void squashIntoSolrResponseWithHeader(SolrQueryResponse rsp, JacksonReflectMapWriter mw) {
        V2ApiUtils.squashIntoNamedList(rsp.getValues(), mw, false);
    }

    public static void squashIntoNamedList(NamedList<Object> destination, JacksonReflectMapWriter mw) {
        V2ApiUtils.squashIntoNamedList(destination, mw, false);
    }

    private static void squashIntoNamedList(final NamedList<Object> destination, JacksonReflectMapWriter mw, final boolean trimHeader) {
        try {
            mw.writeMap(new MapWriter.EntryWriter(){

                public MapWriter.EntryWriter put(CharSequence key, Object value) {
                    String kStr = key.toString();
                    if (trimHeader && kStr.equals("responseHeader")) {
                        return null;
                    }
                    destination.add(kStr, value);
                    return this;
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

