/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin.api;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.solr.api.Command;
import org.apache.solr.api.EndPoint;
import org.apache.solr.api.PayloadObj;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.common.annotation.JsonProperty;
import org.apache.solr.common.params.CoreAdminParams;
import org.apache.solr.common.util.ReflectMapWriter;
import org.apache.solr.handler.ClusterAPI;
import org.apache.solr.handler.admin.CoreAdminHandler;
import org.apache.solr.security.PermissionNameProvider;

@EndPoint(path={"/cores/{core}"}, method={SolrRequest.METHOD.POST}, permission=PermissionNameProvider.Name.CORE_EDIT_PERM)
public class UnloadCoreAPI {
    private static final String V2_UNLOAD_CORE_CMD = "unload";
    private final CoreAdminHandler coreHandler;

    public UnloadCoreAPI(CoreAdminHandler coreHandler) {
        this.coreHandler = coreHandler;
    }

    @Command(name="unload")
    public void unloadCore(PayloadObj<UnloadCorePayload> obj) throws Exception {
        UnloadCorePayload v2Body = obj.get();
        Map v1Params = v2Body.toMap(new HashMap());
        v1Params.put("action", CoreAdminParams.CoreAdminAction.UNLOAD.name().toLowerCase(Locale.ROOT));
        v1Params.put("core", obj.getRequest().getPathTemplateValues().get("core"));
        this.coreHandler.handleRequestBody(ClusterAPI.wrapParams(obj.getRequest(), v1Params), obj.getResponse());
    }

    public static class UnloadCorePayload
    implements ReflectMapWriter {
        @JsonProperty
        public Boolean deleteIndex;
        @JsonProperty
        public Boolean deleteDataDir;
        @JsonProperty
        public Boolean deleteInstanceDir;
        @JsonProperty
        public String async;
    }
}

