/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin.api;

import io.swagger.v3.oas.annotations.Parameter;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.apache.solr.client.solrj.SolrResponse;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.params.RequiredSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.handler.admin.CollectionsHandler;
import org.apache.solr.handler.admin.api.AdminAPIBase;
import org.apache.solr.jersey.SolrJerseyResponse;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;

@Path(value="/collections/{collName}/shards/{shardName}/replicas/{replicaName}/properties/{propName}")
public class DeleteReplicaPropertyAPI
extends AdminAPIBase {
    @Inject
    public DeleteReplicaPropertyAPI(CoreContainer coreContainer, SolrQueryRequest solrQueryRequest, SolrQueryResponse solrQueryResponse) {
        super(coreContainer, solrQueryRequest, solrQueryResponse);
    }

    public SolrJerseyResponse deleteReplicaProperty(@Parameter(description="The name of the collection the replica belongs to.", required=true) @PathParam(value="collName") String collName, @Parameter(description="The name of the shard the replica belongs to.", required=true) @PathParam(value="shardName") String shardName, @Parameter(description="The replica, e.g., `core_node1`.", required=true) @PathParam(value="replicaName") String replicaName, @Parameter(description="The name of the property to delete.", required=true) @PathParam(value="propName") String propertyName) throws Exception {
        SolrJerseyResponse response = this.instantiateJerseyResponse(SolrJerseyResponse.class);
        CoreContainer coreContainer = this.fetchAndValidateZooKeeperAwareCoreContainer();
        DeleteReplicaPropertyAPI.recordCollectionForLogAndTracing(collName, this.solrQueryRequest);
        ZkNodeProps remoteMessage = DeleteReplicaPropertyAPI.createRemoteMessage(collName, shardName, replicaName, propertyName);
        SolrResponse remoteResponse = CollectionsHandler.submitCollectionApiCommand(coreContainer, coreContainer.getDistributedCollectionCommandRunner(), remoteMessage, CollectionParams.CollectionAction.DELETEREPLICAPROP, CollectionsHandler.DEFAULT_COLLECTION_OP_TIMEOUT);
        if (remoteResponse.getException() != null) {
            throw remoteResponse.getException();
        }
        return response;
    }

    public static SolrJerseyResponse invokeUsingV1Inputs(DeleteReplicaPropertyAPI apiInstance, SolrParams solrParams) throws Exception {
        RequiredSolrParams requiredParams = solrParams.required();
        String propNameToDelete = requiredParams.get("property");
        String trimmedPropNameToDelete = propNameToDelete.startsWith("property.") ? propNameToDelete.substring("property.".length()) : propNameToDelete;
        return apiInstance.deleteReplicaProperty(requiredParams.get("collection"), requiredParams.get("shard"), requiredParams.get("replica"), trimmedPropNameToDelete);
    }

    public static ZkNodeProps createRemoteMessage(String collName, String shardName, String replicaName, String propName) {
        Map<String, String> messageProperties = Map.of("operation", CollectionParams.CollectionAction.DELETEREPLICAPROP.toLower(), "collection", collName, "shard", shardName, "replica", replicaName, "property", propName);
        return new ZkNodeProps(messageProperties);
    }
}

