/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sdp.parser;

import gov.nist.core.Token;
import gov.nist.javax.sdp.fields.SDPField;
import gov.nist.javax.sdp.fields.TypedTime;
import gov.nist.javax.sdp.fields.ZoneAdjustment;
import gov.nist.javax.sdp.fields.ZoneField;
import gov.nist.javax.sdp.parser.Lexer;
import gov.nist.javax.sdp.parser.SDPParser;
import java.text.ParseException;

public class ZoneFieldParser
extends SDPParser {
    public ZoneFieldParser(String zoneField) {
        this.lexer = new Lexer("charLexer", zoneField);
    }

    public String getSign(String tokenValue) {
        if (tokenValue.startsWith("-")) {
            return "-";
        }
        return "+";
    }

    public TypedTime getTypedTime(String tokenValue) {
        TypedTime typedTime = new TypedTime();
        String offset = null;
        offset = tokenValue.startsWith("-") ? tokenValue.replace('-', ' ') : (tokenValue.startsWith("+") ? tokenValue.replace('+', ' ') : tokenValue);
        if (offset.endsWith("d")) {
            typedTime.setUnit("d");
            String t2 = offset.replace('d', ' ');
            typedTime.setTime(Integer.parseInt(t2.trim()));
        } else if (offset.endsWith("h")) {
            typedTime.setUnit("h");
            String t3 = offset.replace('h', ' ');
            typedTime.setTime(Integer.parseInt(t3.trim()));
        } else if (offset.endsWith("m")) {
            typedTime.setUnit("m");
            String t4 = offset.replace('m', ' ');
            typedTime.setTime(Integer.parseInt(t4.trim()));
        } else {
            typedTime.setUnit("s");
            if (offset.endsWith("s")) {
                String t5 = offset.replace('s', ' ');
                typedTime.setTime(Integer.parseInt(t5.trim()));
            } else {
                typedTime.setTime(Integer.parseInt(offset.trim()));
            }
        }
        return typedTime;
    }

    public ZoneField zoneField() throws ParseException {
        try {
            char la;
            ZoneField zoneField = new ZoneField();
            this.lexer.match(122);
            this.lexer.SPorHT();
            this.lexer.match(61);
            this.lexer.SPorHT();
            while (this.lexer.hasMoreChars() && (la = this.lexer.lookAhead(0)) != '\n' && la != '\r') {
                ZoneAdjustment zoneAdjustment = new ZoneAdjustment();
                this.lexer.match(4095);
                Token time = this.lexer.getNextToken();
                this.lexer.SPorHT();
                String timeValue = time.getTokenValue();
                if (timeValue.length() > 18) {
                    timeValue = timeValue.substring(timeValue.length() - 18);
                }
                zoneAdjustment.setTime(Long.parseLong(timeValue));
                this.lexer.match(4095);
                Token offset = this.lexer.getNextToken();
                this.lexer.SPorHT();
                String sign = this.getSign(offset.getTokenValue());
                TypedTime typedTime = this.getTypedTime(offset.getTokenValue());
                zoneAdjustment.setSign(sign);
                zoneAdjustment.setOffset(typedTime);
                zoneField.addZoneAdjustment(zoneAdjustment);
            }
            return zoneField;
        }
        catch (Exception e) {
            throw this.lexer.createParseException();
        }
    }

    @Override
    public SDPField parse() throws ParseException {
        return this.zoneField();
    }
}

