/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.device.debugger;

import io.reactivex.annotations.Nullable;
import jadx.core.dex.instructions.args.ArgType;
import jadx.gui.device.debugger.SmaliDebugger;
import jadx.gui.device.debugger.smali.RegisterInfo;
import jadx.gui.device.debugger.smali.SmaliRegister;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class RegisterObserver {
    private Map<Long, List<Info>> infoMap;
    private final List<Map.Entry<SmaliRegister, List<SmaliDebugger.RuntimeVarInfo>>> regList = new ArrayList<Map.Entry<SmaliRegister, List<SmaliDebugger.RuntimeVarInfo>>>();
    private boolean hasDbgInfo = false;

    private RegisterObserver() {
        this.infoMap = Collections.emptyMap();
    }

    public static RegisterObserver merge(List<SmaliDebugger.RuntimeVarInfo> rtRegs, List<SmaliRegister> smaliRegs) {
        RegisterObserver adapter = new RegisterObserver();
        boolean bl = adapter.hasDbgInfo = rtRegs.size() > 0;
        if (adapter.hasDbgInfo) {
            adapter.infoMap = new HashMap<Long, List<Info>>();
        }
        for (SmaliRegister sr : smaliRegs) {
            adapter.regList.add(new AbstractMap.SimpleEntry(sr, Collections.emptyList()));
        }
        adapter.regList.sort(Comparator.comparingInt(r -> ((SmaliRegister)r.getKey()).getRuntimeRegNum()));
        for (SmaliDebugger.RuntimeVarInfo rt : rtRegs) {
            ArgType at;
            Map.Entry<SmaliRegister, List<SmaliDebugger.RuntimeVarInfo>> entry = adapter.regList.get(rt.getRegNum());
            if (entry.getValue().isEmpty()) {
                entry.setValue(new ArrayList());
            }
            entry.getValue().add(rt);
            String type = rt.getSignature();
            if (type.isEmpty()) {
                type = rt.getType();
            }
            if ((at = ArgType.parse((String)type)) != null) {
                type = at.toString();
            }
            Info load = new Info(entry.getKey().getRegNum(), true, new AbstractMap.SimpleEntry<String, String>(rt.getName(), type));
            Info unload = new Info(entry.getKey().getRegNum(), false, null);
            adapter.infoMap.computeIfAbsent(Long.valueOf(rt.getStartOffset()), k -> new ArrayList()).add(load);
            adapter.infoMap.computeIfAbsent(Long.valueOf(rt.getEndOffset()), k -> new ArrayList()).add(unload);
        }
        return adapter;
    }

    public List<SmaliRegister> getInitializedList(long codeOffset) {
        List<SmaliRegister> ret = Collections.emptyList();
        for (Map.Entry<SmaliRegister, List<SmaliDebugger.RuntimeVarInfo>> info : this.regList) {
            if (!info.getKey().isInitialized(codeOffset)) continue;
            if (ret.isEmpty()) {
                ret = new ArrayList<SmaliRegister>();
            }
            ret.add(info.getKey());
        }
        return ret;
    }

    @Nullable
    public Map.Entry<String, String> getInfo(int runtimeNum, long codeOffset) {
        RegisterInfo info;
        Map.Entry<SmaliRegister, List<SmaliDebugger.RuntimeVarInfo>> list = this.regList.get(runtimeNum);
        Iterator<SmaliDebugger.RuntimeVarInfo> iterator = list.getValue().iterator();
        while (iterator.hasNext() && (long)(info = (RegisterInfo)iterator.next()).getStartOffset() <= codeOffset) {
            if (!info.isInitialized(codeOffset)) continue;
            return new AbstractMap.SimpleEntry<String, String>(info.getName(), info.getType());
        }
        return null;
    }

    public List<Info> getInfoAt(long codeOffset) {
        List<Info> list;
        if (this.hasDbgInfo && (list = this.infoMap.get(codeOffset)) != null) {
            return list;
        }
        return Collections.emptyList();
    }

    public static class Info {
        private final int smaliRegNum;
        private final boolean load;
        private final Map.Entry<String, String> info;

        private Info(int smaliRegNum, boolean load, Map.Entry<String, String> info) {
            this.smaliRegNum = smaliRegNum;
            this.load = load;
            this.info = info;
        }

        public int getSmaliRegNum() {
            return this.smaliRegNum;
        }

        public boolean isLoad() {
            return this.load;
        }

        public Map.Entry<String, String> getInfo() {
            return this.info;
        }
    }
}

