/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.input.java.data.code;

import jadx.api.plugins.input.insns.InsnIndexType;
import jadx.api.plugins.input.insns.Opcode;
import jadx.plugins.input.java.data.code.CodeDecodeState;
import jadx.plugins.input.java.data.code.JavaInsnData;
import jadx.plugins.input.java.data.code.JavaInsnInfo;
import jadx.plugins.input.java.data.code.StackState;
import jadx.plugins.input.java.data.code.decoders.IJavaInsnDecoder;
import jadx.plugins.input.java.data.code.decoders.InvokeDecoder;
import jadx.plugins.input.java.data.code.decoders.LoadConstDecoder;
import jadx.plugins.input.java.data.code.decoders.LookupSwitchDecoder;
import jadx.plugins.input.java.data.code.decoders.TableSwitchDecoder;
import jadx.plugins.input.java.data.code.decoders.WideDecoder;
import org.jetbrains.annotations.Nullable;

public class JavaInsnsRegister {
    private static final JavaInsnInfo[] INSN_INFO;
    public static final long FLOAT_ZERO;
    public static final long FLOAT_ONE;
    public static final long FLOAT_TWO;
    public static final long DOUBLE_ZERO;
    public static final long DOUBLE_ONE;

    private static IJavaInsnDecoder newArrayMulti() {
        return s -> {
            s.idx(s.u2());
            int dim = s.u1();
            JavaInsnData insn = s.insn();
            insn.setLiteral(dim);
            insn.setRegsCount(dim + 1);
            for (int i = dim; i > 0; --i) {
                s.pop(i);
            }
            s.push(0);
        };
    }

    private static IJavaInsnDecoder oneRegWithResult(StackState.SVType type) {
        return s -> s.pop(1).push(0, type);
    }

    private static IJavaInsnDecoder twoRegsWithResult(StackState.SVType type) {
        return s -> s.pop(2).pop(1).push(0, type);
    }

    private static IJavaInsnDecoder aget() {
        return s -> s.pop(2).pop(1).push(0);
    }

    private static IJavaInsnDecoder agetWide() {
        return s -> s.pop(2).pop(1).pushWide(0);
    }

    private static IJavaInsnDecoder aput() {
        return s -> s.pop(0).pop(2).pop(1);
    }

    private static IJavaInsnDecoder zeroCmp() {
        return s -> s.pop(0).jump(s.s2());
    }

    private static IJavaInsnDecoder cmp() {
        return s -> s.pop(1).pop(0).jump(s.s2());
    }

    private static void invoke(JavaInsnInfo[] arr, int opcode, String name, int payloadSize, Opcode apiOpcode) {
        InsnIndexType indexType = apiOpcode == Opcode.INVOKE_CUSTOM ? InsnIndexType.CALL_SITE : InsnIndexType.METHOD_REF;
        JavaInsnsRegister.register(arr, opcode, name, payloadSize, -1, apiOpcode, indexType, new InvokeDecoder(payloadSize, apiOpcode));
    }

    private static void constInsn(JavaInsnInfo[] arr, int opcode, String name, Opcode apiOpcode, long literal) {
        JavaInsnsRegister.register(arr, opcode, name, 0, 1, apiOpcode, InsnIndexType.NONE, state -> {
            state.insn().setLiteral(literal);
            state.push(0, apiOpcode == Opcode.CONST_WIDE ? StackState.SVType.WIDE : StackState.SVType.NARROW);
        });
    }

    private static void loadConst(JavaInsnInfo[] arr, int opcode, String name, boolean wide) {
        JavaInsnsRegister.register(arr, opcode, name, wide ? 2 : 1, 2, Opcode.CONST, InsnIndexType.NONE, new LoadConstDecoder(wide));
    }

    private static void register(JavaInsnInfo[] arr, int opcode, String name, int payloadSize, int regsCount, Opcode apiOpcode, IJavaInsnDecoder decoder) {
        JavaInsnsRegister.register(arr, opcode, name, payloadSize, regsCount, apiOpcode, InsnIndexType.NONE, decoder);
    }

    private static void register(JavaInsnInfo[] arr, int opcode, String name, int payloadSize, int regsCount, Opcode apiOpcode, InsnIndexType indexType, IJavaInsnDecoder decoder) {
        if (arr[opcode] != null) {
            throw new IllegalStateException("Duplicate opcode init: 0x" + Integer.toHexString(opcode));
        }
        arr[opcode] = new JavaInsnInfo(opcode, name, payloadSize, regsCount, apiOpcode, indexType, decoder);
    }

    @Nullable
    public static JavaInsnInfo get(int opcode) {
        return INSN_INFO[opcode];
    }

    static {
        FLOAT_ZERO = Float.floatToIntBits(0.0f);
        FLOAT_ONE = Float.floatToIntBits(1.0f);
        FLOAT_TWO = Float.floatToIntBits(2.0f);
        DOUBLE_ZERO = Double.doubleToLongBits(0.0);
        DOUBLE_ONE = Double.doubleToLongBits(1.0);
        JavaInsnInfo[] arr = new JavaInsnInfo[202];
        INSN_INFO = arr;
        JavaInsnsRegister.register(arr, 0, "nop", 0, 0, Opcode.NOP, null);
        JavaInsnsRegister.constInsn(arr, 1, "aconst_null", Opcode.CONST, 0L);
        JavaInsnsRegister.constInsn(arr, 2, "iconst_m1", Opcode.CONST, -1L);
        JavaInsnsRegister.constInsn(arr, 3, "iconst_0", Opcode.CONST, 0L);
        JavaInsnsRegister.constInsn(arr, 4, "iconst_1", Opcode.CONST, 1L);
        JavaInsnsRegister.constInsn(arr, 5, "iconst_2", Opcode.CONST, 2L);
        JavaInsnsRegister.constInsn(arr, 6, "iconst_3", Opcode.CONST, 3L);
        JavaInsnsRegister.constInsn(arr, 7, "iconst_4", Opcode.CONST, 4L);
        JavaInsnsRegister.constInsn(arr, 8, "iconst_5", Opcode.CONST, 5L);
        JavaInsnsRegister.constInsn(arr, 9, "lconst_0", Opcode.CONST_WIDE, 0L);
        JavaInsnsRegister.constInsn(arr, 10, "lconst_1", Opcode.CONST_WIDE, 1L);
        JavaInsnsRegister.constInsn(arr, 11, "fconst_0", Opcode.CONST, FLOAT_ZERO);
        JavaInsnsRegister.constInsn(arr, 12, "fconst_1", Opcode.CONST, FLOAT_ONE);
        JavaInsnsRegister.constInsn(arr, 13, "fconst_2", Opcode.CONST, FLOAT_TWO);
        JavaInsnsRegister.constInsn(arr, 14, "dconst_0", Opcode.CONST_WIDE, DOUBLE_ZERO);
        JavaInsnsRegister.constInsn(arr, 15, "dconst_1", Opcode.CONST_WIDE, DOUBLE_ONE);
        JavaInsnsRegister.register(arr, 16, "bipush", 1, 2, Opcode.CONST, s -> s.lit(s.s1()).push(0));
        JavaInsnsRegister.register(arr, 17, "sipush", 2, 2, Opcode.CONST, s -> s.lit(s.s2()).push(0));
        JavaInsnsRegister.loadConst(arr, 18, "ldc", false);
        JavaInsnsRegister.loadConst(arr, 19, "ldc_w", true);
        JavaInsnsRegister.loadConst(arr, 20, "ldc2_w", true);
        JavaInsnsRegister.register(arr, 21, "iload", 1, 2, Opcode.MOVE, s -> s.local(1, s.u1()).push(0));
        JavaInsnsRegister.register(arr, 22, "lload", 1, 2, Opcode.MOVE_WIDE, s -> s.local(1, s.u1()).pushWide(0));
        JavaInsnsRegister.register(arr, 23, "fload", 1, 2, Opcode.MOVE, s -> s.local(1, s.u1()).push(0));
        JavaInsnsRegister.register(arr, 24, "dload", 1, 2, Opcode.MOVE_WIDE, s -> s.local(1, s.u1()).pushWide(0));
        JavaInsnsRegister.register(arr, 25, "aload", 1, 2, Opcode.MOVE, s -> s.local(1, s.u1()).push(0));
        JavaInsnsRegister.register(arr, 26, "iload_0", 0, 2, Opcode.MOVE, s -> s.local(1, 0).push(0));
        JavaInsnsRegister.register(arr, 27, "iload_1", 0, 2, Opcode.MOVE, s -> s.local(1, 1).push(0));
        JavaInsnsRegister.register(arr, 28, "iload_2", 0, 2, Opcode.MOVE, s -> s.local(1, 2).push(0));
        JavaInsnsRegister.register(arr, 29, "iload_3", 0, 2, Opcode.MOVE, s -> s.local(1, 3).push(0));
        JavaInsnsRegister.register(arr, 30, "lload_0", 0, 2, Opcode.MOVE_WIDE, s -> s.local(1, 0).pushWide(0));
        JavaInsnsRegister.register(arr, 31, "lload_1", 0, 2, Opcode.MOVE_WIDE, s -> s.local(1, 1).pushWide(0));
        JavaInsnsRegister.register(arr, 32, "lload_2", 0, 2, Opcode.MOVE_WIDE, s -> s.local(1, 2).pushWide(0));
        JavaInsnsRegister.register(arr, 33, "lload_3", 0, 2, Opcode.MOVE_WIDE, s -> s.local(1, 3).pushWide(0));
        JavaInsnsRegister.register(arr, 34, "fload_0", 0, 2, Opcode.MOVE, s -> s.local(1, 0).push(0));
        JavaInsnsRegister.register(arr, 35, "fload_1", 0, 2, Opcode.MOVE, s -> s.local(1, 1).push(0));
        JavaInsnsRegister.register(arr, 36, "fload_2", 0, 2, Opcode.MOVE, s -> s.local(1, 2).push(0));
        JavaInsnsRegister.register(arr, 37, "fload_3", 0, 2, Opcode.MOVE, s -> s.local(1, 3).push(0));
        JavaInsnsRegister.register(arr, 38, "dload_0", 0, 2, Opcode.MOVE_WIDE, s -> s.local(1, 0).pushWide(0));
        JavaInsnsRegister.register(arr, 39, "dload_1", 0, 2, Opcode.MOVE_WIDE, s -> s.local(1, 1).pushWide(0));
        JavaInsnsRegister.register(arr, 40, "dload_2", 0, 2, Opcode.MOVE_WIDE, s -> s.local(1, 2).pushWide(0));
        JavaInsnsRegister.register(arr, 41, "dload_3", 0, 2, Opcode.MOVE_WIDE, s -> s.local(1, 3).pushWide(0));
        JavaInsnsRegister.register(arr, 42, "aload_0", 0, 2, Opcode.MOVE, s -> s.local(1, 0).push(0));
        JavaInsnsRegister.register(arr, 43, "aload_1", 0, 2, Opcode.MOVE, s -> s.local(1, 1).push(0));
        JavaInsnsRegister.register(arr, 44, "aload_2", 0, 2, Opcode.MOVE, s -> s.local(1, 2).push(0));
        JavaInsnsRegister.register(arr, 45, "aload_3", 0, 2, Opcode.MOVE, s -> s.local(1, 3).push(0));
        JavaInsnsRegister.register(arr, 46, "iaload", 0, 3, Opcode.AGET, JavaInsnsRegister.aget());
        JavaInsnsRegister.register(arr, 47, "laload", 0, 3, Opcode.AGET_WIDE, JavaInsnsRegister.agetWide());
        JavaInsnsRegister.register(arr, 48, "faload", 0, 3, Opcode.AGET, JavaInsnsRegister.aget());
        JavaInsnsRegister.register(arr, 49, "daload", 0, 3, Opcode.AGET_WIDE, JavaInsnsRegister.agetWide());
        JavaInsnsRegister.register(arr, 50, "aaload", 0, 3, Opcode.AGET_OBJECT, JavaInsnsRegister.aget());
        JavaInsnsRegister.register(arr, 51, "baload", 0, 3, Opcode.AGET_BYTE_BOOLEAN, JavaInsnsRegister.aget());
        JavaInsnsRegister.register(arr, 52, "caload", 0, 3, Opcode.AGET_CHAR, JavaInsnsRegister.aget());
        JavaInsnsRegister.register(arr, 53, "saload", 0, 3, Opcode.AGET_SHORT, JavaInsnsRegister.aget());
        JavaInsnsRegister.register(arr, 54, "istore", 1, 2, Opcode.MOVE, s -> s.pop(1).local(0, s.u1()));
        JavaInsnsRegister.register(arr, 55, "lstore", 1, 2, Opcode.MOVE_WIDE, s -> s.pop(1).local(0, s.u1()));
        JavaInsnsRegister.register(arr, 56, "fstore", 1, 2, Opcode.MOVE, s -> s.pop(1).local(0, s.u1()));
        JavaInsnsRegister.register(arr, 57, "dstore", 1, 2, Opcode.MOVE_WIDE, s -> s.pop(1).local(0, s.u1()));
        JavaInsnsRegister.register(arr, 58, "astore", 1, 2, Opcode.MOVE, s -> s.pop(1).local(0, s.u1()));
        JavaInsnsRegister.register(arr, 59, "istore_0", 0, 2, Opcode.MOVE, s -> s.pop(1).local(0, 0));
        JavaInsnsRegister.register(arr, 60, "istore_1", 0, 2, Opcode.MOVE, s -> s.pop(1).local(0, 1));
        JavaInsnsRegister.register(arr, 61, "istore_2", 0, 2, Opcode.MOVE, s -> s.pop(1).local(0, 2));
        JavaInsnsRegister.register(arr, 62, "istore_3", 0, 2, Opcode.MOVE, s -> s.pop(1).local(0, 3));
        JavaInsnsRegister.register(arr, 63, "lstore_0", 0, 2, Opcode.MOVE_WIDE, s -> s.pop(1).local(0, 0));
        JavaInsnsRegister.register(arr, 64, "lstore_1", 0, 2, Opcode.MOVE_WIDE, s -> s.pop(1).local(0, 1));
        JavaInsnsRegister.register(arr, 65, "lstore_2", 0, 2, Opcode.MOVE_WIDE, s -> s.pop(1).local(0, 2));
        JavaInsnsRegister.register(arr, 66, "lstore_3", 0, 2, Opcode.MOVE_WIDE, s -> s.pop(1).local(0, 3));
        JavaInsnsRegister.register(arr, 67, "fstore_0", 0, 2, Opcode.MOVE, s -> s.pop(1).local(0, 0));
        JavaInsnsRegister.register(arr, 68, "fstore_1", 0, 2, Opcode.MOVE, s -> s.pop(1).local(0, 1));
        JavaInsnsRegister.register(arr, 69, "fstore_2", 0, 2, Opcode.MOVE, s -> s.pop(1).local(0, 2));
        JavaInsnsRegister.register(arr, 70, "fstore_3", 0, 2, Opcode.MOVE, s -> s.pop(1).local(0, 3));
        JavaInsnsRegister.register(arr, 71, "dstore_0", 0, 2, Opcode.MOVE_WIDE, s -> s.pop(1).local(0, 0));
        JavaInsnsRegister.register(arr, 72, "dstore_1", 0, 2, Opcode.MOVE_WIDE, s -> s.pop(1).local(0, 1));
        JavaInsnsRegister.register(arr, 73, "dstore_2", 0, 2, Opcode.MOVE_WIDE, s -> s.pop(1).local(0, 2));
        JavaInsnsRegister.register(arr, 74, "dstore_3", 0, 2, Opcode.MOVE_WIDE, s -> s.pop(1).local(0, 3));
        JavaInsnsRegister.register(arr, 75, "astore_0", 0, 2, Opcode.MOVE, s -> s.pop(1).local(0, 0));
        JavaInsnsRegister.register(arr, 76, "astore_1", 0, 2, Opcode.MOVE, s -> s.pop(1).local(0, 1));
        JavaInsnsRegister.register(arr, 77, "astore_2", 0, 2, Opcode.MOVE, s -> s.pop(1).local(0, 2));
        JavaInsnsRegister.register(arr, 78, "astore_3", 0, 2, Opcode.MOVE, s -> s.pop(1).local(0, 3));
        JavaInsnsRegister.register(arr, 79, "iastore", 0, 3, Opcode.APUT, JavaInsnsRegister.aput());
        JavaInsnsRegister.register(arr, 80, "lastore", 0, 3, Opcode.APUT_WIDE, JavaInsnsRegister.aput());
        JavaInsnsRegister.register(arr, 81, "fastore", 0, 3, Opcode.APUT, JavaInsnsRegister.aput());
        JavaInsnsRegister.register(arr, 82, "dastore", 0, 3, Opcode.APUT_WIDE, JavaInsnsRegister.aput());
        JavaInsnsRegister.register(arr, 83, "aastore", 0, 3, Opcode.APUT_OBJECT, JavaInsnsRegister.aput());
        JavaInsnsRegister.register(arr, 84, "bastore", 0, 3, Opcode.APUT_BYTE_BOOLEAN, JavaInsnsRegister.aput());
        JavaInsnsRegister.register(arr, 85, "castore", 0, 3, Opcode.APUT_CHAR, JavaInsnsRegister.aput());
        JavaInsnsRegister.register(arr, 86, "sastore", 0, 3, Opcode.APUT_SHORT, JavaInsnsRegister.aput());
        JavaInsnsRegister.register(arr, 87, "pop", 0, 0, Opcode.NOP, CodeDecodeState::discard);
        JavaInsnsRegister.register(arr, 88, "pop2", 0, 0, Opcode.NOP, CodeDecodeState::discardWord);
        JavaInsnsRegister.register(arr, 89, "dup", 0, 2, Opcode.MOVE, s -> s.peek(1).push(0, s.peekType(1)));
        JavaInsnsRegister.register(arr, 90, "dup_x1", 0, 6, Opcode.MOVE_MULTI, s -> s.push(0, s.peekType(1)).peekFrom(1, 1).peekFrom(1, 2).peekFrom(2, 3).peekFrom(2, 4).peekFrom(0, 5));
        JavaInsnsRegister.register(arr, 91, "dup_x2", 0, 8, Opcode.MOVE_MULTI, s -> s.push(0, s.peekType(1)).peekFrom(1, 1).peekFrom(1, 2).peekFrom(2, 3).peekFrom(2, 4).peekFrom(3, 5).peekFrom(3, 6).peekFrom(0, 7));
        JavaInsnsRegister.register(arr, 92, "dup2", 0, 4, Opcode.MOVE_MULTI, s -> {
            if (s.peekType(0) == StackState.SVType.NARROW) {
                s.peekFrom(0, 3).peekFrom(1, 1).push(0, StackState.SVType.NARROW).push(2, StackState.SVType.NARROW);
            } else {
                s.peek(1).push(0, s.peekType(1));
            }
        });
        JavaInsnsRegister.register(arr, 93, "dup2_x1", 0, 10, Opcode.MOVE_MULTI, s -> {
            if (s.peekType(0) == StackState.SVType.NARROW) {
                s.push(0, StackState.SVType.NARROW).peekFrom(2, 1).push(2, StackState.SVType.NARROW).peekFrom(2, 3).peekFrom(2, 4).peekFrom(4, 5).peekFrom(3, 6).peekFrom(0, 7).peekFrom(4, 8).peekFrom(1, 9);
            } else {
                s.insn().setRegsCount(6);
                s.push(0, StackState.SVType.WIDE).peekFrom(1, 1).peekFrom(1, 2).peekFrom(2, 3).peekFrom(2, 4).peekFrom(0, 5);
            }
        });
        JavaInsnsRegister.register(arr, 95, "swap", 0, 6, Opcode.MOVE_MULTI, s -> s.peekFrom(-1, 0).peekFrom(1, 1).peekFrom(1, 2).peekFrom(0, 3).peekFrom(0, 4).peekFrom(-1, 5));
        JavaInsnsRegister.register(arr, 96, "iadd", 0, 3, Opcode.ADD_INT, JavaInsnsRegister.twoRegsWithResult(StackState.SVType.NARROW));
        JavaInsnsRegister.register(arr, 97, "ladd", 0, 3, Opcode.ADD_LONG, JavaInsnsRegister.twoRegsWithResult(StackState.SVType.WIDE));
        JavaInsnsRegister.register(arr, 98, "fadd", 0, 3, Opcode.ADD_FLOAT, JavaInsnsRegister.twoRegsWithResult(StackState.SVType.NARROW));
        JavaInsnsRegister.register(arr, 99, "dadd", 0, 3, Opcode.ADD_DOUBLE, JavaInsnsRegister.twoRegsWithResult(StackState.SVType.WIDE));
        JavaInsnsRegister.register(arr, 100, "isub", 0, 3, Opcode.SUB_INT, JavaInsnsRegister.twoRegsWithResult(StackState.SVType.NARROW));
        JavaInsnsRegister.register(arr, 101, "lsub", 0, 3, Opcode.SUB_LONG, JavaInsnsRegister.twoRegsWithResult(StackState.SVType.WIDE));
        JavaInsnsRegister.register(arr, 102, "fsub", 0, 3, Opcode.SUB_FLOAT, JavaInsnsRegister.twoRegsWithResult(StackState.SVType.NARROW));
        JavaInsnsRegister.register(arr, 103, "dsub", 0, 3, Opcode.SUB_DOUBLE, JavaInsnsRegister.twoRegsWithResult(StackState.SVType.WIDE));
        JavaInsnsRegister.register(arr, 104, "imul", 0, 3, Opcode.MUL_INT, JavaInsnsRegister.twoRegsWithResult(StackState.SVType.NARROW));
        JavaInsnsRegister.register(arr, 105, "lmul", 0, 3, Opcode.MUL_LONG, JavaInsnsRegister.twoRegsWithResult(StackState.SVType.WIDE));
        JavaInsnsRegister.register(arr, 106, "fmul", 0, 3, Opcode.MUL_FLOAT, JavaInsnsRegister.twoRegsWithResult(StackState.SVType.NARROW));
        JavaInsnsRegister.register(arr, 107, "dmul", 0, 3, Opcode.MUL_DOUBLE, JavaInsnsRegister.twoRegsWithResult(StackState.SVType.WIDE));
        JavaInsnsRegister.register(arr, 108, "idiv", 0, 3, Opcode.DIV_INT, JavaInsnsRegister.twoRegsWithResult(StackState.SVType.NARROW));
        JavaInsnsRegister.register(arr, 109, "ldiv", 0, 3, Opcode.DIV_LONG, JavaInsnsRegister.twoRegsWithResult(StackState.SVType.WIDE));
        JavaInsnsRegister.register(arr, 110, "fdiv", 0, 3, Opcode.DIV_FLOAT, JavaInsnsRegister.twoRegsWithResult(StackState.SVType.NARROW));
        JavaInsnsRegister.register(arr, 111, "ddiv", 0, 3, Opcode.DIV_DOUBLE, JavaInsnsRegister.twoRegsWithResult(StackState.SVType.WIDE));
        JavaInsnsRegister.register(arr, 112, "irem", 0, 3, Opcode.REM_INT, JavaInsnsRegister.twoRegsWithResult(StackState.SVType.NARROW));
        JavaInsnsRegister.register(arr, 113, "lrem", 0, 3, Opcode.REM_LONG, JavaInsnsRegister.twoRegsWithResult(StackState.SVType.WIDE));
        JavaInsnsRegister.register(arr, 114, "frem", 0, 3, Opcode.REM_FLOAT, JavaInsnsRegister.twoRegsWithResult(StackState.SVType.NARROW));
        JavaInsnsRegister.register(arr, 115, "drem", 0, 3, Opcode.REM_DOUBLE, JavaInsnsRegister.twoRegsWithResult(StackState.SVType.WIDE));
        JavaInsnsRegister.register(arr, 116, "ineg", 0, 2, Opcode.NEG_INT, JavaInsnsRegister.oneRegWithResult(StackState.SVType.NARROW));
        JavaInsnsRegister.register(arr, 117, "lneg", 0, 2, Opcode.NEG_LONG, JavaInsnsRegister.oneRegWithResult(StackState.SVType.WIDE));
        JavaInsnsRegister.register(arr, 118, "fneg", 0, 2, Opcode.NEG_FLOAT, JavaInsnsRegister.oneRegWithResult(StackState.SVType.NARROW));
        JavaInsnsRegister.register(arr, 119, "dneg", 0, 2, Opcode.NEG_DOUBLE, JavaInsnsRegister.oneRegWithResult(StackState.SVType.WIDE));
        JavaInsnsRegister.register(arr, 120, "ishl", 0, 3, Opcode.SHL_INT, JavaInsnsRegister.twoRegsWithResult(StackState.SVType.NARROW));
        JavaInsnsRegister.register(arr, 121, "lshl", 0, 3, Opcode.SHL_LONG, JavaInsnsRegister.twoRegsWithResult(StackState.SVType.WIDE));
        JavaInsnsRegister.register(arr, 122, "ishr", 0, 3, Opcode.SHR_INT, JavaInsnsRegister.twoRegsWithResult(StackState.SVType.NARROW));
        JavaInsnsRegister.register(arr, 123, "lshr", 0, 3, Opcode.SHR_LONG, JavaInsnsRegister.twoRegsWithResult(StackState.SVType.WIDE));
        JavaInsnsRegister.register(arr, 124, "iushr", 0, 3, Opcode.USHR_INT, JavaInsnsRegister.twoRegsWithResult(StackState.SVType.NARROW));
        JavaInsnsRegister.register(arr, 125, "lushr", 0, 3, Opcode.USHR_LONG, JavaInsnsRegister.twoRegsWithResult(StackState.SVType.WIDE));
        JavaInsnsRegister.register(arr, 126, "iand", 0, 3, Opcode.AND_INT, JavaInsnsRegister.twoRegsWithResult(StackState.SVType.NARROW));
        JavaInsnsRegister.register(arr, 127, "land", 0, 3, Opcode.AND_LONG, JavaInsnsRegister.twoRegsWithResult(StackState.SVType.WIDE));
        JavaInsnsRegister.register(arr, 128, "ior", 0, 3, Opcode.OR_INT, JavaInsnsRegister.twoRegsWithResult(StackState.SVType.NARROW));
        JavaInsnsRegister.register(arr, 129, "lor", 0, 3, Opcode.OR_LONG, JavaInsnsRegister.twoRegsWithResult(StackState.SVType.WIDE));
        JavaInsnsRegister.register(arr, 130, "ixor", 0, 3, Opcode.XOR_INT, JavaInsnsRegister.twoRegsWithResult(StackState.SVType.NARROW));
        JavaInsnsRegister.register(arr, 131, "lxor", 0, 3, Opcode.XOR_LONG, JavaInsnsRegister.twoRegsWithResult(StackState.SVType.WIDE));
        JavaInsnsRegister.register(arr, 132, "iinc", 2, 2, Opcode.ADD_INT_LIT, s -> {
            int varNum = s.u1();
            s.local(0, varNum).local(1, varNum).lit(s.reader().readS1());
        });
        JavaInsnsRegister.register(arr, 133, "i2l", 0, 2, Opcode.INT_TO_LONG, JavaInsnsRegister.oneRegWithResult(StackState.SVType.WIDE));
        JavaInsnsRegister.register(arr, 134, "i2f", 0, 2, Opcode.INT_TO_FLOAT, JavaInsnsRegister.oneRegWithResult(StackState.SVType.NARROW));
        JavaInsnsRegister.register(arr, 135, "i2d", 0, 2, Opcode.INT_TO_DOUBLE, JavaInsnsRegister.oneRegWithResult(StackState.SVType.WIDE));
        JavaInsnsRegister.register(arr, 136, "l2i", 0, 2, Opcode.LONG_TO_INT, JavaInsnsRegister.oneRegWithResult(StackState.SVType.NARROW));
        JavaInsnsRegister.register(arr, 137, "l2f", 0, 2, Opcode.LONG_TO_FLOAT, JavaInsnsRegister.oneRegWithResult(StackState.SVType.NARROW));
        JavaInsnsRegister.register(arr, 138, "l2d", 0, 2, Opcode.LONG_TO_DOUBLE, JavaInsnsRegister.oneRegWithResult(StackState.SVType.WIDE));
        JavaInsnsRegister.register(arr, 139, "f2i", 0, 2, Opcode.FLOAT_TO_INT, JavaInsnsRegister.oneRegWithResult(StackState.SVType.NARROW));
        JavaInsnsRegister.register(arr, 140, "f2l", 0, 2, Opcode.FLOAT_TO_LONG, JavaInsnsRegister.oneRegWithResult(StackState.SVType.WIDE));
        JavaInsnsRegister.register(arr, 141, "f2d", 0, 2, Opcode.FLOAT_TO_DOUBLE, JavaInsnsRegister.oneRegWithResult(StackState.SVType.WIDE));
        JavaInsnsRegister.register(arr, 142, "d2i", 0, 2, Opcode.DOUBLE_TO_INT, JavaInsnsRegister.oneRegWithResult(StackState.SVType.NARROW));
        JavaInsnsRegister.register(arr, 143, "d2l", 0, 2, Opcode.DOUBLE_TO_LONG, JavaInsnsRegister.oneRegWithResult(StackState.SVType.WIDE));
        JavaInsnsRegister.register(arr, 144, "d2f", 0, 2, Opcode.DOUBLE_TO_FLOAT, JavaInsnsRegister.oneRegWithResult(StackState.SVType.NARROW));
        JavaInsnsRegister.register(arr, 145, "i2b", 0, 2, Opcode.INT_TO_BYTE, JavaInsnsRegister.oneRegWithResult(StackState.SVType.NARROW));
        JavaInsnsRegister.register(arr, 146, "i2c", 0, 2, Opcode.INT_TO_CHAR, JavaInsnsRegister.oneRegWithResult(StackState.SVType.NARROW));
        JavaInsnsRegister.register(arr, 147, "i2s", 0, 2, Opcode.INT_TO_SHORT, JavaInsnsRegister.oneRegWithResult(StackState.SVType.NARROW));
        JavaInsnsRegister.register(arr, 148, "lcmp", 0, 3, Opcode.CMP_LONG, JavaInsnsRegister.twoRegsWithResult(StackState.SVType.NARROW));
        JavaInsnsRegister.register(arr, 149, "fcmpl", 0, 3, Opcode.CMPL_FLOAT, JavaInsnsRegister.twoRegsWithResult(StackState.SVType.NARROW));
        JavaInsnsRegister.register(arr, 150, "fcmpg", 0, 3, Opcode.CMPG_FLOAT, JavaInsnsRegister.twoRegsWithResult(StackState.SVType.NARROW));
        JavaInsnsRegister.register(arr, 151, "dcmpl", 0, 3, Opcode.CMPL_DOUBLE, JavaInsnsRegister.twoRegsWithResult(StackState.SVType.NARROW));
        JavaInsnsRegister.register(arr, 152, "dcmpg", 0, 3, Opcode.CMPG_DOUBLE, JavaInsnsRegister.twoRegsWithResult(StackState.SVType.NARROW));
        JavaInsnsRegister.register(arr, 153, "ifeq", 2, 1, Opcode.IF_EQZ, JavaInsnsRegister.zeroCmp());
        JavaInsnsRegister.register(arr, 154, "ifne", 2, 1, Opcode.IF_NEZ, JavaInsnsRegister.zeroCmp());
        JavaInsnsRegister.register(arr, 155, "iflt", 2, 1, Opcode.IF_LTZ, JavaInsnsRegister.zeroCmp());
        JavaInsnsRegister.register(arr, 156, "ifge", 2, 1, Opcode.IF_GEZ, JavaInsnsRegister.zeroCmp());
        JavaInsnsRegister.register(arr, 157, "ifgt", 2, 1, Opcode.IF_GTZ, JavaInsnsRegister.zeroCmp());
        JavaInsnsRegister.register(arr, 158, "ifle", 2, 1, Opcode.IF_LEZ, JavaInsnsRegister.zeroCmp());
        JavaInsnsRegister.register(arr, 159, "if_icmpeq", 2, 2, Opcode.IF_EQ, JavaInsnsRegister.cmp());
        JavaInsnsRegister.register(arr, 160, "if_icmpne", 2, 2, Opcode.IF_NE, JavaInsnsRegister.cmp());
        JavaInsnsRegister.register(arr, 161, "if_icmplt", 2, 2, Opcode.IF_LT, JavaInsnsRegister.cmp());
        JavaInsnsRegister.register(arr, 162, "if_icmpge", 2, 2, Opcode.IF_GE, JavaInsnsRegister.cmp());
        JavaInsnsRegister.register(arr, 163, "if_icmpgt", 2, 2, Opcode.IF_GT, JavaInsnsRegister.cmp());
        JavaInsnsRegister.register(arr, 164, "if_icmple", 2, 2, Opcode.IF_LE, JavaInsnsRegister.cmp());
        JavaInsnsRegister.register(arr, 165, "if_acmpeq", 2, 2, Opcode.IF_EQ, JavaInsnsRegister.cmp());
        JavaInsnsRegister.register(arr, 166, "if_acmpne", 2, 2, Opcode.IF_NE, JavaInsnsRegister.cmp());
        JavaInsnsRegister.register(arr, 167, "goto", 2, 0, Opcode.GOTO, s -> s.jump(s.s2()));
        JavaInsnsRegister.register(arr, 170, "tableswitch", -1, 1, Opcode.PACKED_SWITCH, new TableSwitchDecoder());
        JavaInsnsRegister.register(arr, 171, "lookupswitch", -1, 1, Opcode.SPARSE_SWITCH, new LookupSwitchDecoder());
        JavaInsnsRegister.register(arr, 172, "ireturn", 0, 1, Opcode.RETURN, s -> s.pop(0));
        JavaInsnsRegister.register(arr, 173, "lreturn", 0, 1, Opcode.RETURN, s -> s.pop(0));
        JavaInsnsRegister.register(arr, 174, "freturn", 0, 1, Opcode.RETURN, s -> s.pop(0));
        JavaInsnsRegister.register(arr, 175, "dreturn", 0, 1, Opcode.RETURN, s -> s.pop(0));
        JavaInsnsRegister.register(arr, 176, "areturn", 0, 1, Opcode.RETURN, s -> s.pop(0));
        JavaInsnsRegister.register(arr, 177, "return", 0, 0, Opcode.RETURN_VOID, null);
        JavaInsnsRegister.register(arr, 178, "getstatic", 2, 1, Opcode.SGET, InsnIndexType.FIELD_REF, s -> s.idx(s.u2()).push(0, s.fieldType()));
        JavaInsnsRegister.register(arr, 179, "putstatic", 2, 1, Opcode.SPUT, InsnIndexType.FIELD_REF, s -> s.idx(s.u2()).pop(0));
        JavaInsnsRegister.register(arr, 180, "getfield", 2, 2, Opcode.IGET, InsnIndexType.FIELD_REF, s -> s.idx(s.u2()).pop(1).push(0, s.fieldType()));
        JavaInsnsRegister.register(arr, 181, "putfield", 2, 2, Opcode.IPUT, InsnIndexType.FIELD_REF, s -> s.idx(s.u2()).pop(0).pop(1));
        JavaInsnsRegister.invoke(arr, 182, "invokevirtual", 2, Opcode.INVOKE_VIRTUAL);
        JavaInsnsRegister.invoke(arr, 183, "invokespecial", 2, Opcode.INVOKE_SPECIAL);
        JavaInsnsRegister.invoke(arr, 184, "invokestatic", 2, Opcode.INVOKE_STATIC);
        JavaInsnsRegister.invoke(arr, 185, "invokeinterface", 4, Opcode.INVOKE_INTERFACE);
        JavaInsnsRegister.invoke(arr, 186, "invokedynamic", 4, Opcode.INVOKE_CUSTOM);
        JavaInsnsRegister.register(arr, 187, "new", 2, 1, Opcode.NEW_INSTANCE, InsnIndexType.TYPE_REF, s -> s.idx(s.u2()).push(0));
        JavaInsnsRegister.register(arr, 188, "newarray", 1, 2, Opcode.NEW_ARRAY, InsnIndexType.TYPE_REF, s -> s.idx(s.u1()).pop(1).push(0).lit(1L));
        JavaInsnsRegister.register(arr, 189, "anewarray", 2, 2, Opcode.NEW_ARRAY, InsnIndexType.TYPE_REF, s -> s.idx(s.u2()).pop(1).push(0).lit(1L));
        JavaInsnsRegister.register(arr, 190, "arraylength", 0, 2, Opcode.ARRAY_LENGTH, JavaInsnsRegister.oneRegWithResult(StackState.SVType.NARROW));
        JavaInsnsRegister.register(arr, 191, "athrow", 0, 1, Opcode.THROW, s -> s.pop(0).clear());
        JavaInsnsRegister.register(arr, 192, "checkcast", 2, 2, Opcode.CHECK_CAST, InsnIndexType.TYPE_REF, s -> s.idx(s.u2()).pop(1).push(0));
        JavaInsnsRegister.register(arr, 193, "instanceof", 2, 2, Opcode.INSTANCE_OF, InsnIndexType.TYPE_REF, s -> s.idx(s.u2()).pop(1).push(0));
        JavaInsnsRegister.register(arr, 194, "monitorenter", 0, 1, Opcode.MONITOR_ENTER, s -> s.pop(0));
        JavaInsnsRegister.register(arr, 195, "monitorexit", 0, 1, Opcode.MONITOR_EXIT, s -> s.pop(0));
        JavaInsnsRegister.register(arr, 196, "wide", -1, -1, Opcode.NOP, new WideDecoder());
        JavaInsnsRegister.register(arr, 197, "multianewarray", 3, -1, Opcode.NEW_ARRAY, InsnIndexType.TYPE_REF, JavaInsnsRegister.newArrayMulti());
        JavaInsnsRegister.register(arr, 198, "ifnull", 2, 1, Opcode.IF_EQZ, JavaInsnsRegister.zeroCmp());
        JavaInsnsRegister.register(arr, 199, "ifnonnull", 2, 1, Opcode.IF_NEZ, JavaInsnsRegister.zeroCmp());
        JavaInsnsRegister.register(arr, 200, "goto_w", 4, 0, Opcode.GOTO, s -> s.jump(s.reader().readS4()));
    }
}

