/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.AvailabilityZoneDescription;
import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.Outputter;
import java.util.List;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class DescribeAvailabilityZones
extends BaseCmd {
    public DescribeAvailabilityZones(String[] args) {
        super("ec2daz", "ec2-describe-availability-zones");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    private Options getOptions() {
        Options o = new Options();
        OptionBuilder.withLongOpt((String)"filter");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"FILTER");
        OptionBuilder.withDescription((String)this.joinDescription("Add a filter criterion for the result-set."));
        o.addOption(OptionBuilder.create((String)"F"));
        return o;
    }

    @Override
    protected String getOptionString() {
        return "[ZONE [ZONE [...]]]";
    }

    @Override
    public void printDescription() {
        super.printDescription();
        System.out.println("     List the availability zones you have access to.");
        System.out.println("     The ZONE parameter specifies the zones(s) to be described.");
        System.out.println("     If unspecified, all your zones will be returned.");
    }

    @Override
    public void printOptions() {
        super.printOptions(true);
        this.printOption("filter");
    }

    @Override
    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        String[] zones = this.getNonOptions();
        RequestResultPair rsp = jec2.describeAvailabilityZones(zones, this.getFilters(true));
        for (AvailabilityZoneDescription d : (List)rsp.getResponse()) {
            out.output(System.out, d);
        }
        out.printRequestId(System.out, (RequestResult)rsp);
        return true;
    }

    public static void main(String[] args) {
        new DescribeAvailabilityZones(args).invoke();
    }
}

