/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.d2j.dex.writer.ev;

import com.googlecode.d2j.dex.writer.ev.EncodedAnnotation;
import com.googlecode.d2j.dex.writer.ev.EncodedArray;
import com.googlecode.d2j.dex.writer.io.DataOut;
import com.googlecode.d2j.dex.writer.item.BaseItem;
import com.googlecode.d2j.dex.writer.item.FieldIdItem;
import com.googlecode.d2j.dex.writer.item.MethodIdItem;
import com.googlecode.d2j.dex.writer.item.StringIdItem;
import com.googlecode.d2j.dex.writer.item.TypeIdItem;

public class EncodedValue {
    public static final int VALUE_ANNOTATION = 29;
    public static final int VALUE_ARRAY = 28;
    public static final int VALUE_BOOLEAN = 31;
    public static final int VALUE_BYTE = 0;
    public static final int VALUE_CHAR = 3;
    public static final int VALUE_DOUBLE = 17;
    public static final int VALUE_ENUM = 27;
    public static final int VALUE_FIELD = 25;
    public static final int VALUE_FLOAT = 16;
    public static final int VALUE_INT = 4;
    public static final int VALUE_LONG = 6;
    public static final int VALUE_METHOD = 26;
    public static final int VALUE_NULL = 30;
    public static final int VALUE_SHORT = 2;
    public static final int VALUE_STRING = 23;
    public static final int VALUE_TYPE = 24;
    public final int valueType;
    public Object value;

    public EncodedValue(int valueType, Object value) {
        this.valueType = valueType;
        this.value = value;
    }

    public static int lengthOfDouble(double value) {
        int requiredBits = 64 - Long.numberOfTrailingZeros(Double.doubleToRawLongBits(value));
        if (requiredBits == 0) {
            requiredBits = 1;
        }
        return requiredBits + 7 >> 3;
    }

    public static int lengthOfFloat(float value) {
        int requiredBits = 64 - Long.numberOfTrailingZeros((long)Float.floatToRawIntBits(value) << 32);
        if (requiredBits == 0) {
            requiredBits = 1;
        }
        return requiredBits + 7 >> 3;
    }

    public static int lengthOfSint(int value) {
        int nbBits = 33 - Integer.numberOfLeadingZeros(value ^ value >> 31);
        return nbBits + 7 >> 3;
    }

    public static int lengthOfSint(long value) {
        int nbBits = 65 - Long.numberOfLeadingZeros(value ^ value >> 63);
        return nbBits + 7 >> 3;
    }

    public static final int lengthOfUint(int val) {
        int size = 1;
        if (val != 0 && (val >>>= 8) != 0) {
            ++size;
            if ((val >>>= 8) != 0) {
                ++size;
                if ((val >>>= 8) != 0) {
                    ++size;
                }
            }
        }
        return size;
    }

    public static EncodedValue wrap(Object v) {
        if (v == null) {
            return new EncodedValue(30, null);
        }
        if (v instanceof Integer) {
            return new EncodedValue(4, v);
        }
        if (v instanceof Short) {
            return new EncodedValue(2, v);
        }
        if (v instanceof Character) {
            return new EncodedValue(3, v);
        }
        if (v instanceof Long) {
            return new EncodedValue(6, v);
        }
        if (v instanceof Float) {
            return new EncodedValue(16, v);
        }
        if (v instanceof Double) {
            return new EncodedValue(17, v);
        }
        if (v instanceof Boolean) {
            return new EncodedValue(31, v);
        }
        if (v instanceof Byte) {
            return new EncodedValue(0, v);
        }
        if (v instanceof TypeIdItem) {
            return new EncodedValue(24, v);
        }
        if (v instanceof StringIdItem) {
            return new EncodedValue(23, v);
        }
        if (v instanceof FieldIdItem) {
            return new EncodedValue(25, v);
        }
        if (v instanceof MethodIdItem) {
            return new EncodedValue(26, v);
        }
        throw new RuntimeException("not support");
    }

    public static EncodedValue defaultValueForType(String typeString) {
        switch (typeString.charAt(0)) {
            case 'L': 
            case '[': {
                return new EncodedValue(30, null);
            }
            case 'B': {
                return new EncodedValue(0, (byte)0);
            }
            case 'Z': {
                return new EncodedValue(31, false);
            }
            case 'S': {
                return new EncodedValue(2, (short)0);
            }
            case 'C': {
                return new EncodedValue(3, Character.valueOf('\u0000'));
            }
            case 'I': {
                return new EncodedValue(4, 0);
            }
            case 'F': {
                return new EncodedValue(16, Float.valueOf(0.0f));
            }
            case 'D': {
                return new EncodedValue(17, 0.0);
            }
            case 'J': {
                return new EncodedValue(6, 0L);
            }
        }
        throw new RuntimeException();
    }

    static byte[] encodeLong(int length, long value) {
        byte[] data = new byte[length];
        switch (length) {
            case 8: {
                data[7] = (byte)(value >> 56);
            }
            case 7: {
                data[6] = (byte)(value >> 48);
            }
            case 6: {
                data[5] = (byte)(value >> 40);
            }
            case 5: {
                data[4] = (byte)(value >> 32);
            }
            case 4: {
                data[3] = (byte)(value >> 24);
            }
            case 3: {
                data[2] = (byte)(value >> 16);
            }
            case 2: {
                data[1] = (byte)(value >> 8);
            }
            case 1: {
                data[0] = (byte)(value >> 0);
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        return data;
    }

    static byte[] encodeSint(int length, int value) {
        byte[] data = new byte[length];
        switch (length) {
            case 4: {
                data[3] = (byte)(value >> 24);
            }
            case 3: {
                data[2] = (byte)(value >> 16);
            }
            case 2: {
                data[1] = (byte)(value >> 8);
            }
            case 1: {
                data[0] = (byte)(value >> 0);
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        return data;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EncodedValue that = (EncodedValue)o;
        if (this.valueType != that.valueType) {
            return false;
        }
        return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
    }

    public int hashCode() {
        int result = this.valueType;
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }

    public boolean isDefaultValueForType() {
        if (this.valueType == 30) {
            return true;
        }
        switch (this.valueType) {
            case 3: {
                Character c = (Character)this.value;
                return c.charValue() == '\u0000';
            }
            case 0: 
            case 2: 
            case 4: {
                return ((Number)this.value).intValue() == 0;
            }
            case 6: {
                return ((Number)this.value).longValue() == 0L;
            }
            case 16: {
                return ((Number)this.value).floatValue() == 0.0f;
            }
            case 17: {
                return ((Number)this.value).doubleValue() == 0.0;
            }
            case 31: {
                Boolean z = (Boolean)this.value;
                return Boolean.TRUE.equals(z);
            }
        }
        return false;
    }

    protected int doPlace(int offset) {
        switch (this.valueType) {
            case 30: 
            case 31: {
                return offset;
            }
            case 28: {
                EncodedArray ea = (EncodedArray)this.value;
                return ea.place(offset);
            }
            case 29: {
                EncodedAnnotation ea = (EncodedAnnotation)this.value;
                return ea.place(offset);
            }
        }
        return offset + this.getValueArg() + 1;
    }

    protected int getValueArg() {
        switch (this.valueType) {
            case 28: 
            case 29: 
            case 30: {
                return 0;
            }
            case 31: {
                return Boolean.TRUE.equals(this.value) ? 1 : 0;
            }
            case 0: {
                return 0;
            }
            case 2: 
            case 4: {
                return EncodedValue.lengthOfSint(((Number)this.value).intValue()) - 1;
            }
            case 3: {
                return EncodedValue.lengthOfUint(((Character)this.value).charValue()) - 1;
            }
            case 6: {
                return EncodedValue.lengthOfSint(((Number)this.value).longValue()) - 1;
            }
            case 17: {
                return EncodedValue.lengthOfDouble(((Number)this.value).doubleValue()) - 1;
            }
            case 16: {
                return EncodedValue.lengthOfFloat(((Number)this.value).floatValue()) - 1;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                BaseItem bi = (BaseItem)this.value;
                return EncodedValue.lengthOfUint(bi.index) - 1;
            }
        }
        return 0;
    }

    public final int place(int offset) {
        return this.doPlace(++offset);
    }

    public void write(DataOut out) {
        int valueArg = this.getValueArg();
        out.ubyte("(value_arg << 5 | value_type", valueArg << 5 | this.valueType);
        switch (this.valueType) {
            case 30: 
            case 31: {
                break;
            }
            case 2: {
                out.bytes("value_short", EncodedValue.encodeSint(valueArg + 1, ((Short)this.value).shortValue()));
                break;
            }
            case 3: {
                out.bytes("value_char", EncodedValue.encodeSint(valueArg + 1, ((Character)this.value).charValue()));
                break;
            }
            case 4: {
                out.bytes("value_int", EncodedValue.encodeSint(valueArg + 1, (Integer)this.value));
                break;
            }
            case 6: {
                out.bytes("value_long", EncodedValue.encodeLong(valueArg + 1, (Long)this.value));
                break;
            }
            case 17: {
                out.bytes("value_double", this.writeRightZeroExtendedValue(valueArg + 1, Double.doubleToLongBits(((Number)this.value).doubleValue())));
                break;
            }
            case 16: {
                out.bytes("value_float", this.writeRightZeroExtendedValue(valueArg + 1, (long)Float.floatToIntBits(((Number)this.value).floatValue()) << 32));
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                out.bytes("value_xidx", EncodedValue.encodeLong(valueArg + 1, ((BaseItem)this.value).index));
                break;
            }
            case 28: {
                EncodedArray ea = (EncodedArray)this.value;
                ea.write(out);
                break;
            }
            case 29: {
                EncodedAnnotation ea = (EncodedAnnotation)this.value;
                ea.write(out);
                break;
            }
            case 0: {
                out.ubyte("value_byte", ((Byte)this.value).byteValue());
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
    }

    private byte[] writeRightZeroExtendedValue(int requiredBytes, long value) {
        value >>= 64 - requiredBytes * 8;
        byte[] s = new byte[requiredBytes];
        int i = 0;
        while (i < requiredBytes) {
            s[i] = (byte)value;
            value >>= 8;
            ++i;
        }
        return s;
    }
}

