/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.swingui;

import ca.sqlpower.object.HorizontalAlignment;
import ca.sqlpower.object.SPLabel;
import ca.sqlpower.object.SPVariableHelper;
import ca.sqlpower.object.VerticalAlignment;
import ca.sqlpower.swingui.AlignmentIcons;
import ca.sqlpower.swingui.ColorCellRenderer;
import ca.sqlpower.swingui.ColourScheme;
import ca.sqlpower.swingui.DataEntryPanel;
import ca.sqlpower.swingui.FontSelector;
import ca.sqlpower.swingui.object.InsertVariableAction;
import ca.sqlpower.swingui.object.VariableInserter;
import ca.sqlpower.swingui.object.VariableLabel;
import ca.sqlpower.util.WebColour;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.text.BadLocationException;
import org.apache.log4j.Logger;

public abstract class LabelEditorPanel
implements DataEntryPanel {
    private static final Logger logger = Logger.getLogger(LabelEditorPanel.class);
    private JPanel panel;
    private final SPLabel label;
    private FontSelector fontSelector;
    private JTextPane textArea;
    private JToggleButton leftAlign;
    private JToggleButton centreAlign;
    private JToggleButton rightAlign;
    private JToggleButton topAlign;
    private JToggleButton middleAlign;
    private JToggleButton bottomAlign;
    private JComboBox bgColor;
    private JComboBox fgColor;
    private JComboBox bdColor;
    private JCheckBox bgIsNull;
    private JCheckBox borderIsNull;

    public abstract FontSelector getFontSelector();

    public abstract SPVariableHelper getVariablesHelper();

    public abstract List<Color> getBackgroundColours();

    public LabelEditorPanel(SPLabel label, boolean variables, boolean override) {
        this(label, variables);
        if (override) {
            this.bgIsNull.setSelected(false);
            this.borderIsNull.setSelected(false);
            this.bdColor.setSelectedIndex(0);
            this.bgColor.setSelectedIndex(0);
            this.fgColor.setSelectedIndex(0);
        }
    }

    public LabelEditorPanel(SPLabel label, boolean variables) {
        this.label = label;
        this.panel = new JPanel();
        DefaultFormBuilder fb = new DefaultFormBuilder(new FormLayout("pref, 4dlu, pref, 4dlu, pref, 4dlu, pref, 4dlu, 100dlu:grow"), this.panel);
        fb.getLayout().setColumnGroups((int[][])new int[][]{{1, 5}, {3, 7}});
        this.textArea = new JTextPane();
        this.textArea.setText(label.getText());
        JButton variableButton = null;
        if (variables) {
            VariableLabel.insertLabels(this.getVariablesHelper(), this.textArea.getDocument(), this.textArea);
            InsertVariableAction insertVariableAction = new InsertVariableAction("Variables", this.getVariablesHelper(), null, new VariableInserter(){

                @Override
                public void insert(String variable) {
                    try {
                        VariableLabel.insertLabel(variable.replaceFirst("\\$", "").replaceFirst("\\{", "").replaceFirst("\\}", ""), LabelEditorPanel.this.getVariablesHelper(), LabelEditorPanel.this.textArea.getDocument(), LabelEditorPanel.this.textArea.getCaretPosition(), LabelEditorPanel.this.textArea);
                    }
                    catch (BadLocationException e) {
                        throw new IllegalStateException(e);
                    }
                }
            }, this.textArea);
            variableButton = new JButton("Variables");
            variableButton.setAction(insertVariableAction);
            this.textArea.getInputMap().put(KeyStroke.getKeyStroke(32, 2), "insertVariable");
            this.textArea.getActionMap().put("insertVariable", insertVariableAction);
        }
        ButtonGroup hAlignmentGroup = new ButtonGroup();
        this.leftAlign = new JToggleButton(AlignmentIcons.LEFT_ALIGN_ICON, label.getHorizontalAlignment() == HorizontalAlignment.LEFT);
        hAlignmentGroup.add(this.leftAlign);
        this.centreAlign = new JToggleButton(AlignmentIcons.CENTRE_ALIGN_ICON, label.getHorizontalAlignment() == HorizontalAlignment.CENTER);
        hAlignmentGroup.add(this.centreAlign);
        this.rightAlign = new JToggleButton(AlignmentIcons.RIGHT_ALIGN_ICON, label.getHorizontalAlignment() == HorizontalAlignment.RIGHT);
        hAlignmentGroup.add(this.rightAlign);
        ButtonGroup vAlignmentGroup = new ButtonGroup();
        this.topAlign = new JToggleButton(AlignmentIcons.TOP_ALIGN_ICON, label.getVerticalAlignment() == VerticalAlignment.TOP);
        vAlignmentGroup.add(this.topAlign);
        this.middleAlign = new JToggleButton(AlignmentIcons.MIDDLE_ALIGN_ICON, label.getVerticalAlignment() == VerticalAlignment.MIDDLE);
        vAlignmentGroup.add(this.middleAlign);
        this.bottomAlign = new JToggleButton(AlignmentIcons.BOTTOM_ALIGN_ICON, label.getVerticalAlignment() == VerticalAlignment.BOTTOM);
        vAlignmentGroup.add(this.bottomAlign);
        Box alignmentBox = Box.createHorizontalBox();
        alignmentBox.add(this.leftAlign);
        alignmentBox.add(this.centreAlign);
        alignmentBox.add(this.rightAlign);
        alignmentBox.add(Box.createHorizontalStrut(5));
        alignmentBox.add(this.topAlign);
        alignmentBox.add(this.middleAlign);
        alignmentBox.add(this.bottomAlign);
        if (variables) {
            alignmentBox.add(Box.createHorizontalGlue());
            alignmentBox.add(variableButton);
        }
        fb.append("Alignment", (Component)alignmentBox, 7);
        fb.appendRelatedComponentsGapRow();
        fb.appendRow("pref");
        fb.nextLine(2);
        this.bgColor = new JComboBox<WebColour>(ColourScheme.BACKGROUND_COLOURS);
        fb.append("Label Colour", (Component)this.bgColor);
        ColorCellRenderer renderer = new ColorCellRenderer(40, 20);
        this.bgColor.setRenderer(renderer);
        this.bgColor.setSelectedItem(label.getBackgroundColour());
        if (label.getBackgroundColour() == null) {
            this.bgColor.setSelectedIndex(0);
        }
        this.bgColor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LabelEditorPanel.this.bgIsNull.setSelected(false);
            }
        });
        this.bgIsNull = new JCheckBox("Transparent", label.getBackgroundColour() == null);
        fb.append((Component)this.bgIsNull);
        fb.appendRelatedComponentsGapRow();
        fb.appendRow("pref");
        fb.nextLine(2);
        this.fgColor = new JComboBox<WebColour>(ColourScheme.FOREGROUND_COLOURS);
        fb.append("Text Colour", (Component)this.fgColor);
        this.fgColor.setRenderer(renderer);
        this.fgColor.setSelectedItem(label.getForegroundColour());
        fb.appendRelatedComponentsGapRow();
        fb.appendRow("pref");
        fb.nextLine(2);
        this.bdColor = new JComboBox<WebColour>(ColourScheme.FOREGROUND_COLOURS);
        fb.append("Border Colour", (Component)this.bdColor);
        this.bdColor.setRenderer(renderer);
        this.bdColor.setSelectedItem(label.getBorderColour());
        if (label.getBorderColour() == null) {
            this.bdColor.setSelectedIndex(0);
        }
        this.bdColor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LabelEditorPanel.this.borderIsNull.setSelected(false);
            }
        });
        this.borderIsNull = new JCheckBox("No Border", label.getBorderColour() == null);
        fb.append((Component)this.borderIsNull);
        fb.appendRelatedComponentsGapRow();
        fb.appendRow("fill:90dlu:grow");
        fb.nextLine(2);
        this.textArea.setFont(label.getFont());
        JLabel textLabel = fb.append("Text", (Component)new JScrollPane(this.textArea), 7);
        textLabel.setVerticalTextPosition(1);
        fb.appendRow("pref");
        fb.nextLine();
        this.fontSelector = this.getFontSelector();
        if (this.fontSelector != null) {
            logger.debug((Object)("FontSelector got passed Font " + label.getFont()));
            this.fontSelector.setShowingPreview(false);
            this.fontSelector.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    logger.debug((Object)("Changing font to: " + LabelEditorPanel.this.fontSelector.getSelectedFont()));
                    LabelEditorPanel.this.textArea.setFont(LabelEditorPanel.this.fontSelector.getSelectedFont());
                }
            });
            fb.append("Font", (Component)this.fontSelector.getPanel(), 5);
        }
    }

    @Override
    public boolean applyChanges() {
        if (this.fontSelector != null) {
            this.fontSelector.applyChanges();
            this.label.setFont(this.fontSelector.getSelectedFont());
        }
        VariableLabel.removeLabels(this.textArea.getDocument());
        this.label.setText(this.textArea.getText());
        if (this.leftAlign.isSelected()) {
            this.label.setHorizontalAlignment(HorizontalAlignment.LEFT);
        } else if (this.centreAlign.isSelected()) {
            this.label.setHorizontalAlignment(HorizontalAlignment.CENTER);
        } else if (this.rightAlign.isSelected()) {
            this.label.setHorizontalAlignment(HorizontalAlignment.RIGHT);
        }
        if (this.topAlign.isSelected()) {
            this.label.setVerticalAlignment(VerticalAlignment.TOP);
        } else if (this.middleAlign.isSelected()) {
            this.label.setVerticalAlignment(VerticalAlignment.MIDDLE);
        } else if (this.bottomAlign.isSelected()) {
            this.label.setVerticalAlignment(VerticalAlignment.BOTTOM);
        }
        this.label.setBackgroundColour((Color)(this.bgIsNull.isSelected() ? null : this.bgColor.getSelectedItem()));
        this.label.setForegroundColour((Color)this.fgColor.getSelectedItem());
        this.label.setBorderColour((Color)(this.borderIsNull.isSelected() ? null : this.bdColor.getSelectedItem()));
        return true;
    }

    @Override
    public void discardChanges() {
    }

    @Override
    public JComponent getPanel() {
        return this.panel;
    }

    @Override
    public boolean hasUnsavedChanges() {
        return true;
    }

    public SPLabel getLabel() {
        return this.label;
    }
}

