/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.graph;

import ca.sqlpower.graph.GraphModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class DijkstrasAlgorithm<V, E> {
    Logger logger = Logger.getLogger(DijkstrasAlgorithm.class);
    private Map<V, Integer> d = new HashMap<V, Integer>();
    private Map<V, V> pi = new HashMap<V, V>();

    public Map<V, V> calculateShortestPaths(GraphModel<V, E> graph, V start) {
        this.initializeSingleSource(graph, start);
        ArrayList<V> S = new ArrayList<V>();
        ArrayList<V> Q = new ArrayList<V>(graph.getNodes());
        while (!Q.isEmpty()) {
            V u = this.extractMin(Q);
            S.add(u);
            for (V v : graph.getAdjacentNodes(u)) {
                this.relax(u, v);
            }
        }
        return this.pi;
    }

    private void relax(V u, V v) {
        if (this.d.get(v) > this.d.get(u) + 1) {
            this.d.put((Integer)v, this.d.get(u) + 1);
            this.pi.put(v, u);
        }
    }

    private V extractMin(List<V> q) {
        Object u = null;
        for (Object object : q) {
            if (u != null && this.d.get(u) <= this.d.get(object)) continue;
            u = object;
        }
        q.remove(u);
        return (V)u;
    }

    private void initializeSingleSource(GraphModel<V, E> graph, V start) {
        for (V v : graph.getNodes()) {
            this.d.put((Integer)v, new Integer(0x7FFFFFFE));
        }
        this.d.put((Integer)start, new Integer(0));
    }
}

