/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * dot(vec4(-1.65, 1.33, 1.93, 0.76), vec4(-1.65, 1.33, 1.93, 0.76)) => 8.7939
 * dot(vec4(-1.65, 1.33, 1.93, 0.76), vec4(0.8, -0.15, -0.51, 0.0)) => -2.5038
 * dot(vec4(0.8, -0.15, -0.51, 0.0), vec4(-1.65, 1.33, 1.93, 0.76)) => -2.5038
 * dot(vec4(0.8, -0.15, -0.51, 0.0), vec4(0.8, -0.15, -0.51, 0.0)) => 0.92260003
 */
#version 150

void main()
{
  float[distance(dot(vec4(-1.65, 1.33, 1.93, 0.76), vec4(-1.65, 1.33, 1.93, 0.76)), 8.7939) <= 8.7939e-05 ? 1 : -1] array0;
  float[distance(dot(vec4(-1.65, 1.33, 1.93, 0.76), vec4(0.8, -0.15, -0.51, 0.0)), -2.5038) <= 2.5038e-05 ? 1 : -1] array1;
  float[distance(dot(vec4(0.8, -0.15, -0.51, 0.0), vec4(-1.65, 1.33, 1.93, 0.76)), -2.5038) <= 2.5038e-05 ? 1 : -1] array2;
  float[distance(dot(vec4(0.8, -0.15, -0.51, 0.0), vec4(0.8, -0.15, -0.51, 0.0)), 0.92260003) <= 9.226e-06 ? 1 : -1] array3;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
