"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.removeKeyword = exports.handleDataFrameError = exports.getFields = exports.formatDate = exports.fetchDataFramePolling = exports.fetchDataFrame = exports.DataFramePolling = void 0;
var _rxjs = require("rxjs");
var _operators = require("rxjs/operators");
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); } /*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
const formatDate = dateString => {
  const date = new Date(dateString);
  return date.getFullYear() + '-' + ('0' + (date.getMonth() + 1)).slice(-2) + '-' + ('0' + date.getDate()).slice(-2) + ' ' + ('0' + date.getHours()).slice(-2) + ':' + ('0' + date.getMinutes()).slice(-2) + ':' + ('0' + date.getSeconds()).slice(-2);
};
exports.formatDate = formatDate;
const getFields = rawResponse => {
  var _rawResponse$data$sch;
  return (_rawResponse$data$sch = rawResponse.data.schema) === null || _rawResponse$data$sch === void 0 ? void 0 : _rawResponse$data$sch.map((field, index) => {
    var _rawResponse$data$dat;
    return {
      ...field,
      values: (_rawResponse$data$dat = rawResponse.data.datarows) === null || _rawResponse$data$dat === void 0 ? void 0 : _rawResponse$data$dat.map(row => row[index])
    };
  });
};
exports.getFields = getFields;
const removeKeyword = queryString => {
  var _queryString$replace;
  return (_queryString$replace = queryString === null || queryString === void 0 ? void 0 : queryString.replace(new RegExp('.keyword'), '')) !== null && _queryString$replace !== void 0 ? _queryString$replace : '';
};
exports.removeKeyword = removeKeyword;
class DataFramePolling {
  constructor(fetchFunction, interval = 5000, onPollingSuccess, onPollingError) {
    this.fetchFunction = fetchFunction;
    this.interval = interval;
    this.onPollingSuccess = onPollingSuccess;
    this.onPollingError = onPollingError;
    _defineProperty(this, "data", null);
    _defineProperty(this, "error", null);
    _defineProperty(this, "loading", true);
    _defineProperty(this, "shouldPoll", false);
    _defineProperty(this, "intervalRef", void 0);
    _defineProperty(this, "subscription", void 0);
  }
  fetch() {
    return (0, _rxjs.timer)(0, this.interval).pipe((0, _operators.concatMap)(() => this.fetchFunction()), (0, _operators.takeWhile)(resp => this.onPollingSuccess(resp), true), (0, _operators.tap)(resp => {
      this.data = resp;
    }), (0, _operators.last)(), (0, _operators.catchError)(error => {
      this.onPollingError(error);
      return (0, _rxjs.throwError)(error);
    }));
  }
  fetchData(params) {
    this.loading = true;
    this.subscription = this.fetchFunction(params).subscribe({
      next: result => {
        this.data = result;
        this.loading = false;
        if (this.onPollingSuccess && this.onPollingSuccess(result)) {
          this.stopPolling();
        }
      },
      error: err => {
        this.error = err;
        this.loading = false;
        if (this.onPollingError && this.onPollingError(this.error)) {
          this.stopPolling();
        }
      }
    });
  }
  startPolling(params) {
    this.shouldPoll = true;
    if (!this.intervalRef) {
      this.intervalRef = setInterval(() => {
        if (this.shouldPoll) {
          this.fetchData(params);
        }
      }, this.interval);
    }
  }
  stopPolling() {
    this.shouldPoll = false;
    if (this.intervalRef) {
      clearInterval(this.intervalRef);
      this.intervalRef = undefined;
    }
    if (this.subscription) {
      this.subscription.unsubscribe();
      this.subscription = undefined;
    }
  }
  waitForPolling() {
    return new Promise(resolve => {
      const checkLoading = () => {
        if (!this.loading) {
          resolve(this.data);
        } else {
          setTimeout(checkLoading, this.interval);
        }
      };
      checkLoading();
    });
  }
}
exports.DataFramePolling = DataFramePolling;
const handleDataFrameError = response => {
  const df = response.body;
  if (df.error) {
    const jsError = new Error(df.error.response);
    return (0, _rxjs.throwError)(jsError);
  }
};
exports.handleDataFrameError = handleDataFrameError;
const fetchDataFrame = (context, queryString, df) => {
  const {
    http,
    path,
    signal
  } = context;
  const body = JSON.stringify({
    query: {
      qs: queryString,
      format: 'jdbc'
    },
    df
  });
  return (0, _rxjs.from)(http.fetch({
    method: 'POST',
    path,
    body,
    signal
  })).pipe((0, _operators.tap)(handleDataFrameError));
};
exports.fetchDataFrame = fetchDataFrame;
const fetchDataFramePolling = (context, df) => {
  var _df$meta, _df$meta2;
  const {
    http,
    path,
    signal
  } = context;
  const queryId = (_df$meta = df.meta) === null || _df$meta === void 0 ? void 0 : _df$meta.queryId;
  const dataSourceId = (_df$meta2 = df.meta) === null || _df$meta2 === void 0 || (_df$meta2 = _df$meta2.queryConfig) === null || _df$meta2 === void 0 ? void 0 : _df$meta2.dataSourceId;
  return (0, _rxjs.from)(http.fetch({
    method: 'GET',
    path: `${path}/${queryId}${dataSourceId ? `/${dataSourceId}` : ''}`,
    signal
  }));
};
exports.fetchDataFramePolling = fetchDataFramePolling;