"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SQLService = void 0;
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

/* eslint-disable no-console */

class SQLService {
  constructor(http) {
    _defineProperty(this, "http", void 0);
    _defineProperty(this, "fetch", async (params, dataSourceMDSId, errorHandler) => {
      const query = {
        dataSourceMDSId
      };
      return this.http.post('/api/observability/query/jobs', {
        body: JSON.stringify(params),
        query
      }).catch(error => {
        console.error('fetch error: ', error.body);
        if (errorHandler) errorHandler(error);
        throw error;
      });
    });
    _defineProperty(this, "fetchWithJobId", async (params, dataSourceMDSId, errorHandler) => {
      return this.http.get(`/api/observability/query/jobs/${params.queryId}/${dataSourceMDSId !== null && dataSourceMDSId !== void 0 ? dataSourceMDSId : ''}`).catch(error => {
        console.error('fetch error: ', error.body);
        if (errorHandler) errorHandler(error);
        throw error;
      });
    });
    _defineProperty(this, "deleteWithJobId", async (params, errorHandler) => {
      return this.http.delete(`/api/observability/query/jobs/${params.queryId}`).catch(error => {
        console.error('delete error: ', error.body);
        if (errorHandler) errorHandler(error);
        throw error;
      });
    });
    this.http = http;
  }
}
exports.SQLService = SQLService;