/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.util;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.openhab.core.library.types.DecimalType;
import org.openhab.core.library.types.HSBType;
import org.openhab.core.library.types.PercentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class ColorUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ColorUtil.class);
    private static final MathContext COLOR_MATH_CONTEXT = new MathContext(5, RoundingMode.HALF_UP);
    private static final BigDecimal BIG_DECIMAL_360 = BigDecimal.valueOf(360L);
    private static final BigDecimal BIG_DECIMAL_255 = BigDecimal.valueOf(255L);
    private static final BigDecimal BIG_DECIMAL_240 = BigDecimal.valueOf(240L);
    private static final BigDecimal BIG_DECIMAL_120 = BigDecimal.valueOf(120L);
    private static final BigDecimal BIG_DECIMAL_100 = BigDecimal.valueOf(100L);
    private static final BigDecimal BIG_DECIMAL_60 = BigDecimal.valueOf(60L);
    private static final BigDecimal BIG_DECIMAL_50 = BigDecimal.valueOf(50L);
    private static final BigDecimal BIG_DECIMAL_5 = BigDecimal.valueOf(5L);
    private static final BigDecimal BIG_DECIMAL_3 = BigDecimal.valueOf(3L);
    private static final BigDecimal BIG_DECIMAL_2 = BigDecimal.valueOf(2L);
    private static final BigDecimal BIG_DECIMAL_2_POINT_55 = new BigDecimal("2.55");
    public static final Gamut DEFAULT_GAMUT = new Gamut(new double[]{0.9961, 1.0E-4}, new double[]{0.0, 0.9961}, new double[]{0.0, 1.0E-4});

    private ColorUtil() {
    }

    public static int[] hsbToRgb(HSBType hsb) {
        return ColorUtil.getIntArray(ColorUtil.hsbToRgbPercent(hsb));
    }

    public static int[] hsbToRgbw(HSBType hsb) {
        return ColorUtil.getIntArray(ColorUtil.hsbToRgbwPercent(hsb));
    }

    public static PercentType[] hsbToRgbPercent(HSBType hsb) {
        PercentType green;
        PercentType red;
        BigDecimal h = hsb.getHue().toBigDecimal().divide(BIG_DECIMAL_100, 10, RoundingMode.HALF_UP);
        BigDecimal s = hsb.getSaturation().toBigDecimal().divide(BIG_DECIMAL_100);
        int hInt = h.multiply(BIG_DECIMAL_5).divide(BIG_DECIMAL_3, 0, RoundingMode.DOWN).intValue();
        BigDecimal f = h.multiply(BIG_DECIMAL_5).divide(BIG_DECIMAL_3, 10, RoundingMode.HALF_UP).remainder(BigDecimal.ONE);
        BigDecimal value = hsb.getBrightness().toBigDecimal();
        PercentType a = new PercentType(value.multiply(BigDecimal.ONE.subtract(s)));
        PercentType b = new PercentType(value.multiply(BigDecimal.ONE.subtract(s.multiply(f))));
        PercentType c = new PercentType(value.multiply(BigDecimal.ONE.subtract(BigDecimal.ONE.subtract(f).multiply(s))));
        return new PercentType[]{red, green, switch (hInt) {
            case 0, 6 -> {
                red = hsb.getBrightness();
                green = c;
                yield a;
            }
            case 1 -> {
                red = b;
                green = hsb.getBrightness();
                yield a;
            }
            case 2 -> {
                red = a;
                green = hsb.getBrightness();
                yield c;
            }
            case 3 -> {
                red = a;
                green = b;
                yield hsb.getBrightness();
            }
            case 4 -> {
                red = c;
                green = a;
                yield hsb.getBrightness();
            }
            case 5 -> {
                red = hsb.getBrightness();
                green = a;
                yield b;
            }
            default -> throw new IllegalArgumentException("Could not convert to RGB.");
        }};
    }

    public static PercentType[] hsbToRgbwPercent(HSBType hsb) {
        PercentType[] rgbPercents = ColorUtil.hsbToRgbPercent(hsb);
        double[] rgb = new double[3];
        int i = 0;
        while (i < 3) {
            rgb[i] = rgbPercents[i].doubleValue();
            ++i;
        }
        PercentType[] rgbw = new PercentType[4];
        if (Math.max(rgb[0], Math.max(rgb[1], rgb[2])) > 0.0) {
            double whi = Math.min(rgb[0], Math.min(rgb[1], rgb[2]));
            int i2 = 0;
            while (i2 < 3) {
                rgbw[i2] = new PercentType(BigDecimal.valueOf(rgb[i2] - whi));
                ++i2;
            }
            rgbw[3] = new PercentType(BigDecimal.valueOf(whi));
        } else {
            int i3 = 0;
            while (i3 < 4) {
                rgbw[i3] = PercentType.ZERO;
                ++i3;
            }
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("{}", (Object)String.format("RGB:[%.6f,%.6f,%.6f] - RGBW:[%.6f,%.6f,%.6f,%.6f]", rgbPercents[0].doubleValue(), rgbPercents[1].doubleValue(), rgbPercents[2].doubleValue(), rgbw[0].doubleValue(), rgbw[1].doubleValue(), rgbw[2].doubleValue(), rgbw[3].doubleValue()));
        }
        return rgbw;
    }

    public static int hsbTosRgb(HSBType hsb) {
        int[] rgb = ColorUtil.getIntArray(ColorUtil.hsbToRgbPercent(hsb));
        return 0xFF000000 | (rgb[0] & 0xFF) << 16 | (rgb[1] & 0xFF) << 8 | (rgb[2] & 0xFF) << 0;
    }

    public static double[] hsbToXY(HSBType hsb) {
        return ColorUtil.hsbToXY(hsb, DEFAULT_GAMUT);
    }

    public static double[] hsbToXY(HSBType hsb, Gamut gamut) {
        double b;
        double g;
        PercentType[] rgbPercents = ColorUtil.hsbToRgbPercent(hsb);
        double r = rgbPercents[0].doubleValue() / 100.0;
        if (Math.max(r, Math.max(g = rgbPercents[1].doubleValue() / 100.0, b = rgbPercents[2].doubleValue() / 100.0)) <= 0.0) {
            r = 1.0E-6;
            g = 1.0E-6;
            b = 1.0E-6;
        }
        r = r > 0.04045 ? Math.pow((r + 0.055) / 1.055, 2.4) : r / 12.92;
        g = g > 0.04045 ? Math.pow((g + 0.055) / 1.055, 2.4) : g / 12.92;
        b = b > 0.04045 ? Math.pow((b + 0.055) / 1.055, 2.4) : b / 12.92;
        double X = r * 0.664511 + g * 0.154324 + b * 0.162028;
        double Y = r * 0.283881 + g * 0.668433 + b * 0.047685;
        double Z = r * 8.8E-5 + g * 0.07231 + b * 0.986039;
        double sum = X + Y + Z;
        double x = X / sum;
        double y = Y / sum;
        double z = Y;
        Point xy = gamut.closest(new Point(x, y));
        boolean xyForced = xy.x != x || xy.y != y;
        double[] xyY = new double[xyForced ? 4 : 3];
        xyY[0] = xy.x;
        xyY[1] = xy.y;
        xyY[2] = Y;
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("{}", (Object)String.format("HSB:[%.6f,%.6f,%.6f] - RGB:[%.6f,%.6f,%.6f] - RGB':[%.6f,%.6f,%.6f] - XYZ:[%.6f,%.6f,%.6f] - xyz:[%.6f,%.6f,%.6f] - xyY:[%.6f,%.6f,%.6f] (xyForced:%b)", hsb.getHue().doubleValue(), hsb.getSaturation().doubleValue(), hsb.getBrightness().doubleValue(), rgbPercents[0].doubleValue() / 100.0, rgbPercents[1].doubleValue() / 100.0, rgbPercents[2].doubleValue() / 100.0, r, g, b, X, Y, Z, x, y, z, xyY[0], xyY[1], xyY[2], xyForced));
        }
        return xyY;
    }

    public static HSBType rgbToHsb(int[] rgbw) throws IllegalArgumentException {
        if (rgbw.length < 3 || rgbw.length > 4) {
            throw new IllegalArgumentException("rgbToHsb() requires 3 or 4 arguments");
        }
        int i = 0;
        while (i < rgbw.length) {
            if (rgbw[i] < 0 || rgbw[i] > 255) {
                throw new IllegalArgumentException(String.format("rgbToHsb() argument %d value '%f' out of range [0..255]", i, rgbw[i]));
            }
            ++i;
        }
        PercentType[] rgbwPercents = new PercentType[rgbw.length];
        int i2 = 0;
        while (i2 < rgbw.length) {
            rgbwPercents[i2] = new PercentType(new BigDecimal(rgbw[i2]).divide(BIG_DECIMAL_2_POINT_55, COLOR_MATH_CONTEXT));
            ++i2;
        }
        return ColorUtil.rgbToHsb(rgbwPercents);
    }

    public static HSBType rgbToHsb(PercentType[] rgbw) throws IllegalArgumentException {
        BigDecimal b;
        BigDecimal g;
        BigDecimal r;
        if (rgbw.length < 3 || rgbw.length > 4) {
            throw new IllegalArgumentException("rgbToHsb() requires 3 or 4 arguments");
        }
        if (rgbw.length == 3) {
            r = rgbw[0].toBigDecimal();
            g = rgbw[1].toBigDecimal();
            b = rgbw[2].toBigDecimal();
        } else {
            double red = rgbw[0].doubleValue();
            double grn = rgbw[1].doubleValue();
            double blu = rgbw[2].doubleValue();
            double max = Math.max(red, Math.max(grn, blu));
            double whi = Math.min(100.0 - max, rgbw[3].doubleValue());
            if (max > 0.0 || whi > 0.0) {
                r = BigDecimal.valueOf(red + whi);
                g = BigDecimal.valueOf(grn + whi);
                b = BigDecimal.valueOf(blu + whi);
            } else {
                r = BigDecimal.ZERO;
                g = BigDecimal.ZERO;
                b = BigDecimal.ZERO;
            }
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("{}", (Object)String.format("RGBW:[%.6f,%.6f,%.6f,%.6f] - RGB:[%.6f,%.6f,%.6f]", red, grn, blu, whi, r.doubleValue(), g.doubleValue(), b.doubleValue()));
            }
        }
        BigDecimal max = r.max(g).max(b);
        BigDecimal min = r.min(g).min(b);
        BigDecimal span = max.subtract(min);
        if (max.compareTo(BigDecimal.ZERO) == 0) {
            return new HSBType();
        }
        if (span.compareTo(BigDecimal.ZERO) == 0) {
            return new HSBType(new DecimalType(), new PercentType(), new PercentType(max));
        }
        PercentType saturation = new PercentType(span.divide(max, COLOR_MATH_CONTEXT).multiply(BIG_DECIMAL_100));
        PercentType brightness = new PercentType(max);
        BigDecimal scale = span.divide(BIG_DECIMAL_60, COLOR_MATH_CONTEXT);
        BigDecimal redAngle = max.subtract(r).divide(scale, COLOR_MATH_CONTEXT);
        BigDecimal greenAngle = max.subtract(g).divide(scale, COLOR_MATH_CONTEXT);
        BigDecimal blueAngle = max.subtract(b).divide(scale, COLOR_MATH_CONTEXT);
        BigDecimal hue = r.compareTo(max) == 0 ? blueAngle.subtract(greenAngle) : (g.compareTo(max) == 0 ? BIG_DECIMAL_120.add(redAngle).subtract(blueAngle) : BIG_DECIMAL_240.add(greenAngle).subtract(redAngle));
        if (hue.compareTo(BigDecimal.ZERO) < 0) {
            hue = hue.add(BIG_DECIMAL_360);
        } else if (hue.compareTo(BIG_DECIMAL_360) >= 0) {
            hue = hue.subtract(BIG_DECIMAL_360);
        }
        return new HSBType(new DecimalType(hue), saturation, brightness);
    }

    public static HSBType xyToHsb(double[] xy) throws IllegalArgumentException {
        return ColorUtil.xyToHsb(xy, DEFAULT_GAMUT);
    }

    public static HSBType xyToHsb(double[] xyY, Gamut gamut) throws IllegalArgumentException {
        int i;
        double max;
        if (xyY.length < 2 || xyY.length > 4) {
            throw new IllegalArgumentException("xyToHsb() requires 2, 3 or 4 arguments");
        }
        int i2 = 0;
        while (i2 < xyY.length) {
            if (xyY[i2] < 0.0 || xyY[i2] > 1.0) {
                throw new IllegalArgumentException(String.format("xyToHsb() argument %d value '%f' out of range [0..1.0]", i2, xyY[i2]));
            }
            ++i2;
        }
        Point xy = gamut.closest(new Point(xyY[0], xyY[1]));
        double x = xy.x;
        double y = xy.y == 0.0 ? 1.0E-6 : xy.y;
        double z = 1.0 - x - y;
        double Y = xyY.length == 3 && xyY[2] > 0.0 ? xyY[2] : 1.0;
        double X = Y / y * x;
        double Z = Y / y * z;
        double[] rgb = new double[]{X * 1.656492 + Y * -0.354851 + Z * -0.255038, X * -0.707196 + Y * 1.655397 + Z * 0.036152, X * 0.051713 + Y * -0.121364 + Z * 1.01153};
        double[] rgbPrime = (double[])rgb.clone();
        double min = Math.min(rgb[0], Math.min(rgb[1], rgb[2]));
        if (min < 0.0) {
            int i3 = 0;
            while (i3 < rgb.length) {
                int n = i3++;
                rgb[n] = rgb[n] - min;
            }
        }
        if ((max = Math.max(rgb[0], Math.max(rgb[1], rgb[2]))) > 1.0) {
            i = 0;
            while (i < rgb.length) {
                int n = i++;
                rgb[n] = rgb[n] / max;
            }
        }
        i = 0;
        while (i < rgb.length) {
            rgb[i] = rgb[i] <= 0.0031308 ? 12.92 * rgb[i] : 1.055 * Math.pow(rgb[i], 0.4166666666666667) - 0.055;
            ++i;
        }
        max = Math.max(rgb[0], Math.max(rgb[1], rgb[2]));
        if (max > 1.0) {
            i = 0;
            while (i < rgb.length) {
                int n = i++;
                rgb[n] = rgb[n] / max;
            }
        }
        PercentType[] rgbPercents = new PercentType[rgb.length];
        int i4 = 0;
        while (i4 < rgb.length) {
            rgbPercents[i4] = new PercentType(new BigDecimal(rgb[i4]).multiply(BIG_DECIMAL_100, COLOR_MATH_CONTEXT));
            ++i4;
        }
        HSBType hsb = ColorUtil.rgbToHsb(rgbPercents);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("{}", (Object)String.format("xyY:[%.6f,%.6f,%.6f] - xyz:[%.6f,%.6f,%.6f] - XYZ:[%.6f,%.6f,%.6f] - RGB':[%.6f,%.6f,%.6f] - RGB:[%.6f,%.6f,%.6f] - HSB:[%.6f,%.6f,%.6f] (xyForced:%b)", xyY[0], xyY[1], Y, x, y, z, X, Y, Z, rgbPrime[0], rgbPrime[1], rgbPrime[2], rgb[0], rgb[1], rgb[2], hsb.getHue().doubleValue(), hsb.getSaturation().doubleValue(), hsb.getBrightness().doubleValue(), xy.x != xyY[0] || xy.y != xyY[1]));
        }
        return hsb;
    }

    private static int[] getIntArray(PercentType[] percents) {
        int[] ints = new int[percents.length];
        int i = 0;
        while (i < percents.length) {
            ints[i] = percents[i].toBigDecimal().multiply(BIG_DECIMAL_255).divide(BIG_DECIMAL_100, 0, RoundingMode.HALF_UP).intValue();
            ++i;
        }
        return ints;
    }

    public record Gamut(double[] r, double[] g, double[] b) {
        public Point closest(Point p) {
            Point r = new Point(this.r[0], this.r[1]);
            Point g = new Point(this.g[0], this.g[1]);
            Point b = new Point(this.b[0], this.b[1]);
            Point v1 = new Point(g.x - r.x, g.y - r.y);
            Point v2 = new Point(b.x - r.x, b.y - r.y);
            Point q = new Point(p.x - r.x, p.y - r.y);
            double v = v1.crossProduct(v2);
            double s = q.crossProduct(v2) / v;
            double t = v1.crossProduct(q) / v;
            if (s >= 0.0 && t >= 0.0 && s + t <= 1.0) {
                return p;
            }
            Point pRG = p.closest(r, g);
            Point pGB = p.closest(g, b);
            Point pBR = p.closest(b, r);
            double dRG = p.distance(pRG);
            double dGB = p.distance(pGB);
            double dBR = p.distance(pBR);
            double min = dRG;
            Point retVal = pRG;
            if (dGB < min) {
                min = dGB;
                retVal = pGB;
            }
            if (dBR < min) {
                retVal = pBR;
            }
            return retVal;
        }
    }

    public static class Point {
        public final double x;
        public final double y;

        public Point() {
            this(0.0, 0.0);
        }

        public Point(double x, double y) {
            this.x = x;
            this.y = y;
        }

        public double distance(Point other) {
            double dx = this.x - other.x;
            double dy = this.y - other.y;
            return Math.sqrt(dx * dx + dy * dy);
        }

        public double crossProduct(Point other) {
            return this.x * other.y - this.y * other.x;
        }

        public Point closest(Point a, Point b) {
            Point ap = new Point(this.x - a.x, this.y - a.y);
            Point ab = new Point(b.x - a.x, b.y - a.y);
            double t = Math.min(1.0, Math.max(0.0, (ap.x * ab.x + ap.y * ab.y) / (ab.x * ab.x + ab.y * ab.y)));
            return new Point(a.x + t * ab.x, a.y + t * ab.y);
        }
    }
}

