/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.config.discovery;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.common.ThreadPoolManager;
import org.openhab.core.config.core.ConfigParser;
import org.openhab.core.config.discovery.DiscoveryListener;
import org.openhab.core.config.discovery.DiscoveryResult;
import org.openhab.core.config.discovery.DiscoveryResultBuilder;
import org.openhab.core.config.discovery.DiscoveryService;
import org.openhab.core.config.discovery.ScanListener;
import org.openhab.core.i18n.I18nUtil;
import org.openhab.core.i18n.LocaleProvider;
import org.openhab.core.i18n.TranslationProvider;
import org.openhab.core.thing.ThingTypeUID;
import org.openhab.core.thing.ThingUID;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public abstract class AbstractDiscoveryService
implements DiscoveryService {
    private static final String DISCOVERY_THREADPOOL_NAME = "discovery";
    private final Logger logger = LoggerFactory.getLogger(AbstractDiscoveryService.class);
    protected final ScheduledExecutorService scheduler = ThreadPoolManager.getScheduledPool((String)"discovery");
    private final Set<DiscoveryListener> discoveryListeners = new CopyOnWriteArraySet<DiscoveryListener>();
    protected @Nullable ScanListener scanListener = null;
    private boolean backgroundDiscoveryEnabled;
    private final Map<ThingUID, DiscoveryResult> cachedResults = new HashMap<ThingUID, DiscoveryResult>();
    private final Set<ThingTypeUID> supportedThingTypes;
    private final int timeout;
    private Instant timestampOfLastScan = Instant.MIN;
    private @Nullable ScheduledFuture<?> scheduledStop;
    @NonNullByDefault(value={})
    protected TranslationProvider i18nProvider;
    @NonNullByDefault(value={})
    protected LocaleProvider localeProvider;

    protected AbstractDiscoveryService(@Nullable Set<ThingTypeUID> supportedThingTypes, int timeout, boolean backgroundDiscoveryEnabledByDefault) throws IllegalArgumentException {
        if (timeout < 0) {
            throw new IllegalArgumentException("The timeout must be >= 0!");
        }
        this.supportedThingTypes = supportedThingTypes == null ? Set.of() : Set.copyOf(supportedThingTypes);
        this.timeout = timeout;
        this.backgroundDiscoveryEnabled = backgroundDiscoveryEnabledByDefault;
    }

    protected AbstractDiscoveryService(@Nullable Set<ThingTypeUID> supportedThingTypes, int timeout) throws IllegalArgumentException {
        this(supportedThingTypes, timeout, true);
    }

    protected AbstractDiscoveryService(int timeout) throws IllegalArgumentException {
        this(null, timeout);
    }

    public Set<ThingTypeUID> getSupportedThingTypes() {
        return this.supportedThingTypes;
    }

    @Override
    public int getScanTimeout() {
        return this.timeout;
    }

    @Override
    public boolean isBackgroundDiscoveryEnabled() {
        return this.backgroundDiscoveryEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDiscoveryListener(@Nullable DiscoveryListener listener) {
        if (listener == null) {
            return;
        }
        Map<ThingUID, DiscoveryResult> map = this.cachedResults;
        synchronized (map) {
            for (DiscoveryResult cachedResult : this.cachedResults.values()) {
                listener.thingDiscovered(this, cachedResult);
            }
        }
        this.discoveryListeners.add(listener);
    }

    @Override
    public void removeDiscoveryListener(@Nullable DiscoveryListener listener) {
        this.discoveryListeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void startScan(@Nullable ScanListener listener) {
        AbstractDiscoveryService abstractDiscoveryService = this;
        synchronized (abstractDiscoveryService) {
            this.stopScan();
            ScheduledFuture<?> scheduledStop = this.scheduledStop;
            if (scheduledStop != null) {
                scheduledStop.cancel(false);
                this.scheduledStop = null;
            }
            this.scanListener = listener;
            if (this.getScanTimeout() > 0) {
                scheduledStop = this.scheduler.schedule(() -> {
                    try {
                        this.stopScan();
                    }
                    catch (Exception e) {
                        this.logger.debug("Exception occurred during execution: {}", (Object)e.getMessage(), (Object)e);
                    }
                }, (long)this.getScanTimeout(), TimeUnit.SECONDS);
            }
            this.timestampOfLastScan = Instant.now();
            try {
                this.startScan();
            }
            catch (Exception ex) {
                scheduledStop = this.scheduledStop;
                if (scheduledStop != null) {
                    scheduledStop.cancel(false);
                    this.scheduledStop = null;
                }
                this.scanListener = null;
                throw ex;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void abortScan() {
        AbstractDiscoveryService abstractDiscoveryService = this;
        synchronized (abstractDiscoveryService) {
            ScanListener scanListener;
            ScheduledFuture<?> scheduledStop = this.scheduledStop;
            if (scheduledStop != null) {
                scheduledStop.cancel(false);
                this.scheduledStop = null;
            }
            if ((scanListener = this.scanListener) != null) {
                CancellationException e = new CancellationException("Scan has been aborted.");
                scanListener.onErrorOccurred(e);
                this.scanListener = null;
            }
        }
    }

    protected abstract void startScan();

    protected synchronized void stopScan() {
        ScanListener scanListener = this.scanListener;
        if (scanListener != null) {
            scanListener.onFinished();
            this.scanListener = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void thingDiscovered(DiscoveryResult discoveryResult) {
        DiscoveryResult discoveryResultNew = this.getLocalizedDiscoveryResult(discoveryResult, FrameworkUtil.getBundle(this.getClass()));
        for (DiscoveryListener discoveryListener : this.discoveryListeners) {
            try {
                discoveryListener.thingDiscovered(this, discoveryResultNew);
            }
            catch (Exception e) {
                this.logger.error("An error occurred while calling the discovery listener {}.", (Object)discoveryListener.getClass().getName(), (Object)e);
            }
        }
        Map<ThingUID, DiscoveryResult> map = this.cachedResults;
        synchronized (map) {
            this.cachedResults.put(discoveryResultNew.getThingUID(), discoveryResultNew);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void thingRemoved(ThingUID thingUID) {
        for (DiscoveryListener discoveryListener : this.discoveryListeners) {
            try {
                discoveryListener.thingRemoved(this, thingUID);
            }
            catch (Exception e) {
                this.logger.error("An error occurred while calling the discovery listener {}.", (Object)discoveryListener.getClass().getName(), (Object)e);
            }
        }
        Map<ThingUID, DiscoveryResult> map = this.cachedResults;
        synchronized (map) {
            this.cachedResults.remove(thingUID);
        }
    }

    protected void removeOlderResults(long timestamp) {
        this.removeOlderResults(timestamp, null, null);
    }

    protected void removeOlderResults(long timestamp, @Nullable ThingUID bridgeUID) {
        this.removeOlderResults(timestamp, null, bridgeUID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeOlderResults(long timestamp, @Nullable Collection<ThingTypeUID> thingTypeUIDs, @Nullable ThingUID bridgeUID) {
        Collection<ThingUID> removedThings = null;
        Collection toBeRemoved = thingTypeUIDs != null ? thingTypeUIDs : this.getSupportedThingTypes();
        for (DiscoveryListener discoveryListener : this.discoveryListeners) {
            try {
                removedThings = discoveryListener.removeOlderResults(this, timestamp, toBeRemoved, bridgeUID);
            }
            catch (Exception e) {
                this.logger.error("An error occurred while calling the discovery listener {}.", (Object)discoveryListener.getClass().getName(), (Object)e);
            }
        }
        if (removedThings != null) {
            Map<ThingUID, DiscoveryResult> map = this.cachedResults;
            synchronized (map) {
                for (ThingUID uid : removedThings) {
                    this.cachedResults.remove(uid);
                }
            }
        }
    }

    protected void activate(@Nullable Map<String, Object> configProperties) {
        if (configProperties != null) {
            this.backgroundDiscoveryEnabled = (Boolean)ConfigParser.valueAsOrElse((Object)configProperties.get("background"), Boolean.class, (Object)this.backgroundDiscoveryEnabled);
        }
        if (this.backgroundDiscoveryEnabled) {
            this.startBackgroundDiscovery();
            this.logger.debug("Background discovery for discovery service '{}' enabled.", (Object)this.getClass().getName());
        }
    }

    protected void modified(@Nullable Map<String, Object> configProperties) {
        if (configProperties != null) {
            boolean enabled = (Boolean)ConfigParser.valueAsOrElse((Object)configProperties.get("background"), Boolean.class, (Object)this.backgroundDiscoveryEnabled);
            if (this.backgroundDiscoveryEnabled && !enabled) {
                this.stopBackgroundDiscovery();
                this.logger.debug("Background discovery for discovery service '{}' disabled.", (Object)this.getClass().getName());
            } else if (!this.backgroundDiscoveryEnabled && enabled) {
                this.startBackgroundDiscovery();
                this.logger.debug("Background discovery for discovery service '{}' enabled.", (Object)this.getClass().getName());
            }
            this.backgroundDiscoveryEnabled = enabled;
        }
    }

    protected void deactivate() {
        if (this.backgroundDiscoveryEnabled) {
            this.stopBackgroundDiscovery();
        }
    }

    protected void startBackgroundDiscovery() {
    }

    protected void stopBackgroundDiscovery() {
    }

    protected long getTimestampOfLastScan() {
        return Instant.MIN.equals(this.timestampOfLastScan) ? 0L : this.timestampOfLastScan.toEpochMilli();
    }

    private String inferKey(DiscoveryResult discoveryResult, String lastSegment) {
        return "discovery." + discoveryResult.getThingUID().getAsString().replace(":", ".") + "." + lastSegment;
    }

    protected DiscoveryResult getLocalizedDiscoveryResult(DiscoveryResult discoveryResult, @Nullable Bundle bundle) {
        if (this.i18nProvider != null && this.localeProvider != null) {
            String currentLabel = discoveryResult.getLabel();
            String key = I18nUtil.stripConstantOr((String)currentLabel, () -> this.inferKey(discoveryResult, "label"));
            ParsedKey parsedKey = new ParsedKey(key);
            String label = this.i18nProvider.getText(bundle, parsedKey.key, currentLabel, this.localeProvider.getLocale(), parsedKey.args);
            if (currentLabel.equals(label)) {
                return discoveryResult;
            }
            return DiscoveryResultBuilder.create(discoveryResult.getThingUID()).withThingType(discoveryResult.getThingTypeUID()).withBridge(discoveryResult.getBridgeUID()).withProperties(discoveryResult.getProperties()).withRepresentationProperty(discoveryResult.getRepresentationProperty()).withLabel(label).withTTL(discoveryResult.getTimeToLive()).build();
        }
        return discoveryResult;
    }

    private static final class ParsedKey {
        private static final int LIMIT = 2;
        private final String key;
        private final Object @Nullable [] args;

        private ParsedKey(String label) {
            String[] parts = label.split("\\s+", 2);
            this.key = parts[0];
            this.args = parts.length == 1 ? null : Arrays.stream(parts[1].replaceAll("\\[|\\]|\"", "").split(",")).filter(s -> !s.isBlank()).map(String::trim).toArray(Object[]::new);
        }
    }
}

