/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2semodule;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.java.api.common.ant.UpdateHelper;
import org.netbeans.modules.java.api.common.project.ProjectPlatformProvider;
import org.netbeans.modules.java.api.common.util.CommonProjectUtils;
import org.netbeans.modules.java.j2semodule.J2SEModularProject;
import org.netbeans.spi.java.project.support.ProjectPlatform;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.util.MutexException;
import org.openide.util.Parameters;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

final class ProjectPlatformProviderImpl
implements ProjectPlatformProvider,
PropertyChangeListener {
    private final J2SEModularProject project;
    private final PropertyChangeSupport support;
    private final PropertyEvaluator eval;

    ProjectPlatformProviderImpl(@NonNull J2SEModularProject project) {
        assert (project != null);
        this.support = new PropertyChangeSupport(this);
        this.project = project;
        this.eval = project.evaluator();
        this.eval.addPropertyChangeListener((PropertyChangeListener)this);
    }

    @CheckForNull
    public JavaPlatform getProjectPlatform() {
        return (JavaPlatform)ProjectManager.mutex().readAccess(() -> {
            JavaPlatform jp = CommonProjectUtils.getActivePlatform((String)this.eval.getProperty("platform.active"));
            if (jp == null) {
                jp = ProjectPlatform.forProject((Project)this.project, (PropertyEvaluator)this.eval, (String)"j2se");
            }
            return jp;
        });
    }

    public void setProjectPlatform(@NonNull JavaPlatform platform) throws IOException {
        Parameters.notNull((CharSequence)"platform", (Object)platform);
        if (!"j2se".equals(platform.getSpecification().getName())) {
            throw new IllegalArgumentException(String.format("Not J2SE Platform: %s (%s)", platform.getDisplayName(), platform.getSpecification().getName()));
        }
        if (platform.getInstallFolders().isEmpty()) {
            throw new IllegalArgumentException(String.format("Broken Platform %s", platform.getDisplayName()));
        }
        try {
            ProjectManager.mutex().writeAccess(() -> {
                String platformId = (String)platform.getProperties().get("platform.ant.name");
                UpdateHelper uh = this.project.getUpdateHelper();
                EditableProperties props = uh.getProperties("nbproject/project.properties");
                props.setProperty("platform.active", platformId);
                uh.putProperties("nbproject/project.properties", props);
                ProjectPlatformProviderImpl.updateProjectXml(platform, uh);
                ProjectManager.getDefault().saveProject((Project)this.project);
                return null;
            });
        }
        catch (MutexException e) {
            throw (IOException)e.getCause();
        }
    }

    public void addPropertyChangeListener(@NonNull PropertyChangeListener listener) {
        Parameters.notNull((CharSequence)"listener", (Object)listener);
        this.support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(@NonNull PropertyChangeListener listener) {
        Parameters.notNull((CharSequence)"listener", (Object)listener);
        this.support.removePropertyChangeListener(listener);
    }

    @Override
    public void propertyChange(@NonNull PropertyChangeEvent event) {
        String propName = event.getPropertyName();
        if (propName == null || "platform.active".equals(propName)) {
            this.support.firePropertyChange("projectPlatform", null, null);
        }
    }

    static boolean updateProjectXml(@NonNull JavaPlatform platform, @NonNull UpdateHelper helper) {
        assert (ProjectManager.mutex().isWriteAccess());
        boolean remove = platform.equals(JavaPlatformManager.getDefault().getDefaultPlatform());
        Element root = helper.getPrimaryConfigurationData(true);
        boolean changed = false;
        if (remove) {
            Element platformElement = XMLUtil.findElement((Element)root, (String)"explicit-platform", (String)"http://www.netbeans.org/ns/j2se-modular-project/1");
            if (platformElement != null) {
                root.removeChild(platformElement);
                changed = true;
            }
        } else {
            Node insertBefore = null;
            for (Element e : XMLUtil.findSubElements((Element)root)) {
                String name = e.getNodeName();
                if ("name".equals(name) || "minimum-ant-version".equals(name)) continue;
                insertBefore = e;
                break;
            }
            Element platformNode = insertBefore.getOwnerDocument().createElementNS("http://www.netbeans.org/ns/j2se-modular-project/1", "explicit-platform");
            platformNode.setAttribute("explicit-source-supported", "true");
            root.insertBefore(platformNode, insertBefore);
            if ("explicit-platform".equals(insertBefore.getNodeName())) {
                root.removeChild(insertBefore);
            }
            changed = true;
        }
        if (changed) {
            helper.putPrimaryConfigurationData(root, true);
        }
        return changed;
    }
}

