/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.breakpoints;

import com.sun.jdi.ReferenceType;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.ExceptionEvent;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.ExceptionRequest;
import java.util.List;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.ExceptionBreakpoint;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.breakpoints.ClassBasedBreakpoint;
import org.netbeans.modules.debugger.jpda.breakpoints.RequestNotSupportedException;
import org.netbeans.modules.debugger.jpda.breakpoints.SourceRootsCache;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InvalidRequestStateExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.LocatableWrapper;
import org.netbeans.modules.debugger.jpda.jdi.LocationWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.event.ExceptionEventWrapper;
import org.netbeans.modules.debugger.jpda.jdi.event.LocatableEventWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.EventRequestManagerWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.ExceptionRequestWrapper;
import org.netbeans.spi.debugger.jpda.BreakpointsClassFilter;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class ExceptionBreakpointImpl
extends ClassBasedBreakpoint {
    private ExceptionBreakpoint breakpoint;

    ExceptionBreakpointImpl(ExceptionBreakpoint breakpoint, JPDADebuggerImpl debugger, Session session, SourceRootsCache sourceRootsCache) {
        super((JPDABreakpoint)breakpoint, debugger, session, sourceRootsCache);
        this.breakpoint = breakpoint;
        this.set();
    }

    @Override
    protected void setRequests() {
        String[] excludedNames;
        BreakpointsClassFilter.ClassNames classNames = this.getClassFilter().filterClassNames(new BreakpointsClassFilter.ClassNames(new String[]{this.breakpoint.getExceptionClassName()}, new String[0]), (JPDABreakpoint)this.breakpoint);
        String[] names = classNames.getClassNames();
        boolean wasSet = this.setClassRequests(names, excludedNames = classNames.getExcludedClassNames(), 1);
        if (wasSet) {
            for (String cn : names) {
                this.checkLoadedClasses(cn, excludedNames);
            }
        }
    }

    @Override
    protected void classLoaded(List<ReferenceType> referenceTypes) {
        for (ReferenceType referenceType : referenceTypes) {
            try {
                ExceptionRequest er = EventRequestManagerWrapper.createExceptionRequest(this.getEventRequestManager(), referenceType, (this.breakpoint.getCatchType() & 1) != 0, (this.breakpoint.getCatchType() & 2) != 0);
                this.addFilters(er, this.breakpoint.getClassFilters(), this.breakpoint.getClassExclusionFilters());
                this.addEventRequest(er);
            }
            catch (VMDisconnectedExceptionWrapper e) {
                return;
            }
            catch (InternalExceptionWrapper e) {
            }
            catch (ObjectCollectedExceptionWrapper e) {
            }
            catch (InvalidRequestStateExceptionWrapper irse) {
                Exceptions.printStackTrace((Throwable)irse);
            }
            catch (RequestNotSupportedException rnsex) {
                this.setValidity(Breakpoint.VALIDITY.INVALID, NbBundle.getMessage(ClassBasedBreakpoint.class, (String)"MSG_RequestNotSupported"));
            }
        }
    }

    @Override
    protected ExceptionRequest createEventRequest(EventRequest oldRequest) throws VMDisconnectedExceptionWrapper, InternalExceptionWrapper {
        ExceptionRequest excRequest = (ExceptionRequest)oldRequest;
        ExceptionRequest er = EventRequestManagerWrapper.createExceptionRequest(this.getEventRequestManager(), ExceptionRequestWrapper.exception(excRequest), ExceptionRequestWrapper.notifyCaught(excRequest), ExceptionRequestWrapper.notifyUncaught(excRequest));
        this.addFilters(er, this.breakpoint.getClassFilters(), this.breakpoint.getClassExclusionFilters());
        return er;
    }

    private void addFilters(ExceptionRequest er, String[] classFilters, String[] classExclusionFilters) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper {
        int i;
        int k = classFilters.length;
        for (i = 0; i < k; ++i) {
            ExceptionRequestWrapper.addClassFilter(er, classFilters[i]);
        }
        k = classExclusionFilters.length;
        for (i = 0; i < k; ++i) {
            ExceptionRequestWrapper.addClassExclusionFilter(er, classExclusionFilters[i]);
        }
    }

    @Override
    public boolean processCondition(Event event) {
        if (event instanceof ExceptionEvent) {
            try {
                return this.processCondition(event, this.breakpoint.getCondition(), LocatableEventWrapper.thread((ExceptionEvent)event), null);
            }
            catch (InternalExceptionWrapper ex) {
                return true;
            }
            catch (VMDisconnectedExceptionWrapper ex) {
                return true;
            }
        }
        return true;
    }

    @Override
    public boolean exec(Event event) {
        if (event instanceof ExceptionEvent) {
            ExceptionEvent ee = (ExceptionEvent)event;
            try {
                return this.perform(event, LocatableEventWrapper.thread(ee), LocationWrapper.declaringType(LocatableWrapper.location(ee)), ExceptionEventWrapper.exception(ee));
            }
            catch (InternalExceptionWrapper ex) {
                return false;
            }
            catch (VMDisconnectedExceptionWrapper ex) {
                return false;
            }
        }
        return super.exec(event);
    }
}

