/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.twig.editor.typinghooks;

import javax.swing.text.BadLocationException;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.EditorOptions;

public final class TypingHooksUtils {
    private TypingHooksUtils() {
    }

    public static boolean isInsertMatchingEnabled() {
        EditorOptions options = EditorOptions.get((String)"text/x-twig");
        if (options != null) {
            return options.getMatchBrackets();
        }
        return true;
    }

    public static boolean sameAsExistingChar(BaseDocument doc, char c, int dotPos) throws BadLocationException {
        if (dotPos <= 0 || doc.getLength() <= dotPos) {
            return false;
        }
        char[] nextChars = doc.getChars(dotPos, 1);
        return nextChars.length > 0 && nextChars[0] == c;
    }

    public static boolean isEscapeSequence(BaseDocument doc, int dotPos) throws BadLocationException {
        if (dotPos <= 0) {
            return false;
        }
        char[] previousChars = doc.getChars(dotPos - 1, 1);
        return previousChars.length > 0 && previousChars[0] == '\\';
    }

    public static boolean isOpeningDelimiterChar(char c) {
        return c == '{' || c == '%';
    }
}

