/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.spi;

import java.io.File;
import java.io.FileFilter;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.modules.versioning.Accessor;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.core.spi.VCSContext;
import org.netbeans.modules.versioning.spi.AccessorImpl;
import org.openide.nodes.Node;
import org.openide.util.Lookup;

public final class VCSContext {
    private org.netbeans.modules.versioning.core.spi.VCSContext delegate;
    public static final VCSContext EMPTY = new VCSContext(org.netbeans.modules.versioning.core.spi.VCSContext.EMPTY);
    private Set<File> unfilteredRootFiles;
    private Set<File> exclusions;
    private Set<File> rootFiles;
    private Set<File> computedFilesCached;
    private FileFilter fileFilterCached;

    VCSContext(org.netbeans.modules.versioning.core.spi.VCSContext delegate) {
        assert (VCSContext.accept(delegate));
        this.delegate = delegate;
    }

    public static synchronized VCSContext forNodes(Node[] nodes) {
        org.netbeans.modules.versioning.core.spi.VCSContext delegate = org.netbeans.modules.versioning.core.spi.VCSContext.forNodes((Node[])nodes);
        return VCSContext.accept(delegate) ? new VCSContext(delegate) : EMPTY;
    }

    public synchronized Set<File> computeFiles(FileFilter filter) {
        if (this.computedFilesCached == null || filter != this.fileFilterCached) {
            Set files = this.delegate.computeFiles((VCSContext.FileFilter)new ProxyFileFilter(filter));
            this.computedFilesCached = VCSContext.toFileSet(files);
            this.fileFilterCached = filter;
        }
        return this.computedFilesCached;
    }

    public Lookup getElements() {
        return this.delegate.getElements();
    }

    public Set<File> getFiles() {
        if (this.unfilteredRootFiles == null) {
            this.unfilteredRootFiles = VCSContext.toFileSet(this.delegate.getFiles());
        }
        return this.unfilteredRootFiles;
    }

    public Set<File> getRootFiles() {
        if (this.rootFiles == null) {
            this.rootFiles = VCSContext.toFileSet(this.delegate.getRootFiles());
        }
        return this.rootFiles;
    }

    public Set<File> getExclusions() {
        if (this.exclusions == null) {
            this.exclusions = VCSContext.toFileSet(this.delegate.getExclusions());
        }
        return this.exclusions;
    }

    public boolean contains(File file) {
        return this.delegate.contains(VCSFileProxy.createFileProxy((File)file));
    }

    private static Set<File> toFileSet(Set<VCSFileProxy> files) {
        HashSet<File> s = new HashSet<File>(files.size());
        for (VCSFileProxy fileProxy : files) {
            s.add(fileProxy.toFile());
        }
        return s;
    }

    private static boolean accept(org.netbeans.modules.versioning.core.spi.VCSContext delegate) {
        Set roots = delegate.getRootFiles();
        for (VCSFileProxy root : roots) {
            if (root.toFile() != null) continue;
            return false;
        }
        return true;
    }

    static {
        Accessor.IMPL = new AccessorImpl();
    }

    private class ProxyFileFilter
    implements VCSContext.FileFilter {
        private final FileFilter filter;

        public ProxyFileFilter(FileFilter filter) {
            this.filter = filter;
        }

        public boolean accept(VCSFileProxy file) {
            return this.filter.accept(file.toFile());
        }
    }
}

