/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.code;

import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.main.Option;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Options;
import com.sun.tools.javac.util.Pair;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Lint {
    protected static final Context.Key<Lint> lintKey = new Context.Key();
    private final AugmentVisitor augmentor;
    private final EnumSet<LintCategory> values;
    private final EnumSet<LintCategory> suppressedValues;
    private static final Map<String, LintCategory> map = new ConcurrentHashMap<String, LintCategory>(20);

    public static Lint instance(Context context) {
        Lint instance = context.get(lintKey);
        if (instance == null) {
            instance = new Lint(context);
        }
        return instance;
    }

    public Lint augment(Attribute.Compound attr) {
        return this.augmentor.augment(this, attr);
    }

    public Lint augment(Symbol sym) {
        Lint l = this.augmentor.augment(this, sym.getDeclarationAttributes());
        if (sym.isDeprecated() && sym.isDeprecatableViaAnnotation()) {
            if (l == this) {
                l = new Lint(this);
            }
            l.values.remove((Object)LintCategory.DEPRECATION);
            l.suppressedValues.add(LintCategory.DEPRECATION);
        }
        return l;
    }

    public Lint suppress(LintCategory ... lc) {
        Lint l = new Lint(this);
        l.values.removeAll(Arrays.asList(lc));
        l.suppressedValues.addAll(Arrays.asList(lc));
        return l;
    }

    protected Lint(Context context) {
        Options options = Options.instance(context);
        if (options.isSet(Option.XLINT) || options.isSet(Option.XLINT_CUSTOM, "all")) {
            this.values = EnumSet.allOf(LintCategory.class);
        } else if (options.isSet(Option.XLINT_CUSTOM, "none")) {
            this.values = EnumSet.noneOf(LintCategory.class);
        } else {
            this.values = EnumSet.noneOf(LintCategory.class);
            Source source = Source.instance(context);
            if (source.compareTo(Source.JDK9) >= 0) {
                this.values.add(LintCategory.DEP_ANN);
            }
            if (Source.Feature.REDUNDANT_STRICTFP.allowedInSource(source)) {
                this.values.add(LintCategory.STRICTFP);
            }
            this.values.add(LintCategory.REQUIRES_TRANSITIVE_AUTOMATIC);
            this.values.add(LintCategory.OPENS);
            this.values.add(LintCategory.MODULE);
            this.values.add(LintCategory.REMOVAL);
            if (!options.isSet(Option.PREVIEW)) {
                this.values.add(LintCategory.PREVIEW);
            }
            this.values.add(LintCategory.SYNCHRONIZATION);
            this.values.add(LintCategory.INCUBATING);
        }
        for (LintCategory lc : LintCategory.values()) {
            if (options.isSet(Option.XLINT_CUSTOM, lc.option)) {
                this.values.add(lc);
                continue;
            }
            if (!options.isSet(Option.XLINT_CUSTOM, "-" + lc.option)) continue;
            this.values.remove((Object)lc);
        }
        this.suppressedValues = EnumSet.noneOf(LintCategory.class);
        context.put(lintKey, this);
        this.augmentor = new AugmentVisitor(context);
    }

    protected Lint(Lint other) {
        this.augmentor = other.augmentor;
        this.values = other.values.clone();
        this.suppressedValues = other.suppressedValues.clone();
    }

    public String toString() {
        return "Lint:[values" + this.values + " suppressedValues" + this.suppressedValues + "]";
    }

    public boolean isEnabled(LintCategory lc) {
        return this.values.contains((Object)lc);
    }

    public boolean isSuppressed(LintCategory lc) {
        return this.suppressedValues.contains((Object)lc);
    }

    protected static class AugmentVisitor
    implements Attribute.Visitor {
        private final Context context;
        private Symtab syms;
        private Lint parent;
        private Lint lint;

        AugmentVisitor(Context context) {
            this.context = context;
        }

        Lint augment(Lint parent, Attribute.Compound attr) {
            this.initSyms();
            this.parent = parent;
            this.lint = null;
            attr.accept(this);
            return this.lint == null ? parent : this.lint;
        }

        Lint augment(Lint parent, List<Attribute.Compound> attrs) {
            this.initSyms();
            this.parent = parent;
            this.lint = null;
            for (Attribute.Compound a : attrs) {
                a.accept(this);
            }
            return this.lint == null ? parent : this.lint;
        }

        private void initSyms() {
            if (this.syms == null) {
                this.syms = Symtab.instance(this.context);
            }
        }

        private void suppress(LintCategory lc) {
            if (this.lint == null) {
                this.lint = new Lint(this.parent);
            }
            this.lint.suppressedValues.add(lc);
            this.lint.values.remove((Object)lc);
        }

        @Override
        public void visitConstant(Attribute.Constant value) {
            LintCategory lc;
            if (value.type.tsym == this.syms.stringType.tsym && (lc = LintCategory.get((String)value.value)) != null) {
                this.suppress(lc);
            }
        }

        @Override
        public void visitClass(Attribute.Class clazz) {
        }

        @Override
        public void visitCompound(Attribute.Compound compound) {
            if (compound.type.tsym == this.syms.suppressWarningsType.tsym) {
                List<Pair<Symbol.MethodSymbol, Attribute>> v = compound.values;
                while (v.nonEmpty()) {
                    Pair value = (Pair)v.head;
                    if (((Symbol.MethodSymbol)value.fst).name.toString().equals("value")) {
                        ((Attribute)value.snd).accept(this);
                    }
                    v = v.tail;
                }
            }
        }

        @Override
        public void visitArray(Attribute.Array array) {
            for (Attribute value : array.values) {
                value.accept(this);
            }
        }

        @Override
        public void visitEnum(Attribute.Enum e) {
        }

        @Override
        public void visitError(Attribute.Error e) {
        }
    }

    public static enum LintCategory {
        AUXILIARYCLASS("auxiliaryclass"),
        CAST("cast"),
        CLASSFILE("classfile"),
        DEPRECATION("deprecation"),
        DEP_ANN("dep-ann"),
        DIVZERO("divzero"),
        EMPTY("empty"),
        EXPORTS("exports"),
        FALLTHROUGH("fallthrough"),
        FINALLY("finally"),
        INCUBATING("incubating"),
        LOSSY_CONVERSIONS("lossy-conversions"),
        MISSING_EXPLICIT_CTOR("missing-explicit-ctor"),
        MODULE("module"),
        OPENS("opens"),
        OPTIONS("options"),
        OUTPUT_FILE_CLASH("output-file-clash"),
        OVERLOADS("overloads"),
        OVERRIDES("overrides"),
        PATH("path"),
        PROCESSING("processing"),
        RAW("rawtypes"),
        REMOVAL("removal"),
        REQUIRES_AUTOMATIC("requires-automatic"),
        REQUIRES_TRANSITIVE_AUTOMATIC("requires-transitive-automatic"),
        SERIAL("serial"),
        STATIC("static"),
        STRICTFP("strictfp"),
        SYNCHRONIZATION("synchronization"),
        TEXT_BLOCKS("text-blocks"),
        THIS_ESCAPE("this-escape"),
        TRY("try"),
        UNCHECKED("unchecked"),
        VARARGS("varargs"),
        PREVIEW("preview"),
        RESTRICTED("restricted");

        public final String option;

        private LintCategory(String option) {
            this.option = option;
            map.put(option, this);
        }

        static LintCategory get(String option) {
            return (LintCategory)((Object)map.get(option));
        }
    }
}

