/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.devops.model.DeliveredArtifact;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="artifactType")
@JsonFilter(value="explicitlySetFilter")
public final class GenericDeliveredArtifact
extends DeliveredArtifact {
    @JsonProperty(value="artifactRepositoryId")
    private final String artifactRepositoryId;
    @JsonProperty(value="deliveredArtifactId")
    private final String deliveredArtifactId;
    @JsonProperty(value="path")
    private final String path;
    @JsonProperty(value="version")
    private final String version;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public GenericDeliveredArtifact(String deployArtifactId, String outputArtifactName, String artifactRepositoryId, String deliveredArtifactId, String path, String version) {
        super(deployArtifactId, outputArtifactName);
        this.artifactRepositoryId = artifactRepositoryId;
        this.deliveredArtifactId = deliveredArtifactId;
        this.path = path;
        this.version = version;
    }

    public String getArtifactRepositoryId() {
        return this.artifactRepositoryId;
    }

    public String getDeliveredArtifactId() {
        return this.deliveredArtifactId;
    }

    public String getPath() {
        return this.path;
    }

    public String getVersion() {
        return this.version;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("GenericDeliveredArtifact(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", artifactRepositoryId=").append(String.valueOf(this.artifactRepositoryId));
        sb.append(", deliveredArtifactId=").append(String.valueOf(this.deliveredArtifactId));
        sb.append(", path=").append(String.valueOf(this.path));
        sb.append(", version=").append(String.valueOf(this.version));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GenericDeliveredArtifact)) {
            return false;
        }
        GenericDeliveredArtifact other = (GenericDeliveredArtifact)((Object)o);
        return Objects.equals(this.artifactRepositoryId, other.artifactRepositoryId) && Objects.equals(this.deliveredArtifactId, other.deliveredArtifactId) && Objects.equals(this.path, other.path) && Objects.equals(this.version, other.version) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.artifactRepositoryId == null ? 43 : this.artifactRepositoryId.hashCode());
        result = result * 59 + (this.deliveredArtifactId == null ? 43 : this.deliveredArtifactId.hashCode());
        result = result * 59 + (this.path == null ? 43 : this.path.hashCode());
        result = result * 59 + (this.version == null ? 43 : this.version.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="deployArtifactId")
        private String deployArtifactId;
        @JsonProperty(value="outputArtifactName")
        private String outputArtifactName;
        @JsonProperty(value="artifactRepositoryId")
        private String artifactRepositoryId;
        @JsonProperty(value="deliveredArtifactId")
        private String deliveredArtifactId;
        @JsonProperty(value="path")
        private String path;
        @JsonProperty(value="version")
        private String version;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder deployArtifactId(String deployArtifactId) {
            this.deployArtifactId = deployArtifactId;
            this.__explicitlySet__.add("deployArtifactId");
            return this;
        }

        public Builder outputArtifactName(String outputArtifactName) {
            this.outputArtifactName = outputArtifactName;
            this.__explicitlySet__.add("outputArtifactName");
            return this;
        }

        public Builder artifactRepositoryId(String artifactRepositoryId) {
            this.artifactRepositoryId = artifactRepositoryId;
            this.__explicitlySet__.add("artifactRepositoryId");
            return this;
        }

        public Builder deliveredArtifactId(String deliveredArtifactId) {
            this.deliveredArtifactId = deliveredArtifactId;
            this.__explicitlySet__.add("deliveredArtifactId");
            return this;
        }

        public Builder path(String path) {
            this.path = path;
            this.__explicitlySet__.add("path");
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            this.__explicitlySet__.add("version");
            return this;
        }

        public GenericDeliveredArtifact build() {
            GenericDeliveredArtifact model = new GenericDeliveredArtifact(this.deployArtifactId, this.outputArtifactName, this.artifactRepositoryId, this.deliveredArtifactId, this.path, this.version);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(GenericDeliveredArtifact model) {
            if (model.wasPropertyExplicitlySet("deployArtifactId")) {
                this.deployArtifactId(model.getDeployArtifactId());
            }
            if (model.wasPropertyExplicitlySet("outputArtifactName")) {
                this.outputArtifactName(model.getOutputArtifactName());
            }
            if (model.wasPropertyExplicitlySet("artifactRepositoryId")) {
                this.artifactRepositoryId(model.getArtifactRepositoryId());
            }
            if (model.wasPropertyExplicitlySet("deliveredArtifactId")) {
                this.deliveredArtifactId(model.getDeliveredArtifactId());
            }
            if (model.wasPropertyExplicitlySet("path")) {
                this.path(model.getPath());
            }
            if (model.wasPropertyExplicitlySet("version")) {
                this.version(model.getVersion());
            }
            return this;
        }
    }
}

