/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jakarta.web.beans.navigation;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.util.prefs.Preferences;
import org.openide.util.NbPreferences;

final class WebBeansNavigationOptions {
    private static final String PROP_caseSensitive = "caseSensitive";
    private static final String PROP_showFQN = "showFQN";
    private static final String PROP_lastBoundsX = "lastBoundsX";
    private static final String PROP_lastBoundsY = "lastBoundsY";
    private static final String PROP_lastBoundsWidth = "lastBoundsWidth";
    private static final String PROP_lastBoundsHeight = "lastBoundsHeight";
    private static final String PROP_hierarchyDividerLocation = "hierarchyDividerLocation";
    private static boolean myCaseSensitive = false;
    private static int myHierarchyDividerLocation = 350;
    private static boolean myShowFQN = false;
    private static Rectangle myLastBounds;

    WebBeansNavigationOptions() {
    }

    private static final Preferences getPreferences() {
        return NbPreferences.forModule(WebBeansNavigationOptions.class);
    }

    static boolean isCaseSensitive() {
        return WebBeansNavigationOptions.getPreferences().getBoolean(PROP_caseSensitive, myCaseSensitive);
    }

    static boolean isShowFQN() {
        return WebBeansNavigationOptions.getPreferences().getBoolean(PROP_showFQN, myShowFQN);
    }

    static void setCaseSensitive(boolean selected) {
        WebBeansNavigationOptions.getPreferences().putBoolean(PROP_caseSensitive, myCaseSensitive);
    }

    static void setShowFQN(boolean selected) {
        WebBeansNavigationOptions.getPreferences().putBoolean(PROP_showFQN, selected);
    }

    static void setLastBounds(Rectangle bounds) {
        if (bounds != null) {
            WebBeansNavigationOptions.getPreferences().putInt(PROP_lastBoundsX, bounds.x);
            WebBeansNavigationOptions.getPreferences().putInt(PROP_lastBoundsY, bounds.y);
            WebBeansNavigationOptions.getPreferences().putInt(PROP_lastBoundsWidth, bounds.width);
            WebBeansNavigationOptions.getPreferences().putInt(PROP_lastBoundsHeight, bounds.height);
        }
    }

    static int getHierarchyDividerLocation() {
        return WebBeansNavigationOptions.getPreferences().getInt(PROP_hierarchyDividerLocation, myHierarchyDividerLocation);
    }

    static void setHierarchyDividerLocation(int hierarchyDividerLocation) {
        WebBeansNavigationOptions.getPreferences().putInt(PROP_hierarchyDividerLocation, hierarchyDividerLocation);
    }

    static Rectangle getLastBounds() {
        int x = WebBeansNavigationOptions.getPreferences().getInt(PROP_lastBoundsX, WebBeansNavigationOptions.myLastBounds.x);
        int y = WebBeansNavigationOptions.getPreferences().getInt(PROP_lastBoundsY, WebBeansNavigationOptions.myLastBounds.y);
        int width = WebBeansNavigationOptions.getPreferences().getInt(PROP_lastBoundsWidth, WebBeansNavigationOptions.myLastBounds.width);
        int height = WebBeansNavigationOptions.getPreferences().getInt(PROP_lastBoundsHeight, WebBeansNavigationOptions.myLastBounds.height);
        return new Rectangle(x, y, width, height);
    }

    static {
        Dimension dimensions = Toolkit.getDefaultToolkit().getScreenSize();
        myLastBounds = new Rectangle(dimensions.width / 2 - 410, dimensions.height / 2 - 300, 820, 600);
    }
}

