/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jakarta.web.beans.analysis.analyzer.type;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.jakarta.web.beans.analysis.CdiAnalysisResult;
import org.netbeans.modules.jakarta.web.beans.analysis.analyzer.AnnotationUtil;
import org.netbeans.modules.jakarta.web.beans.analysis.analyzer.ClassElementAnalyzer;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.util.NbBundle;

public class AnnotationsAnalyzer
implements ClassElementAnalyzer.ClassAnalyzer {
    @Override
    public void analyze(TypeElement element, TypeElement parent, AtomicBoolean cancel, CdiAnalysisResult result) {
        this.checkDecoratorInterceptor(element, cancel, result);
    }

    private void checkDecoratorInterceptor(TypeElement element, AtomicBoolean cancel, CdiAnalysisResult result) {
        CompilationInfo compInfo = result.getInfo();
        boolean isDecorator = AnnotationUtil.hasAnnotation(element, "jakarta.decorator.Decorator", compInfo);
        boolean isInterceptor = AnnotationUtil.hasAnnotation(element, "jakarta.interceptor.Interceptor", compInfo);
        if (isDecorator && isInterceptor) {
            result.addError(element, NbBundle.getMessage(AnnotationsAnalyzer.class, (String)"ERR_DecoratorInterceptor"));
        }
        if (isDecorator || isInterceptor) {
            result.requireCdiEnabled(element);
            if (cancel.get()) {
                return;
            }
            this.checkProducerFields(element, isDecorator, result);
            if (cancel.get()) {
                return;
            }
            this.checkMethods(element, isDecorator, result);
            if (cancel.get()) {
                return;
            }
            this.checkSession(element, result);
            if (cancel.get()) {
                return;
            }
            this.checkNamed(element, result);
            if (cancel.get()) {
                return;
            }
            this.checkAlternatives(element, result);
            if (cancel.get()) {
                return;
            }
            this.checkSpecializes(element, result);
        }
        if (isDecorator) {
            if (cancel.get()) {
                return;
            }
            this.checkDelegateInjectionPoint(element, result);
        }
    }

    private void checkSpecializes(TypeElement element, CdiAnalysisResult result) {
        if (AnnotationUtil.hasAnnotation(element, "jakarta.enterprise.inject.Specializes", result.getInfo())) {
            result.addNotification(Severity.WARNING, element, NbBundle.getMessage(AnnotationsAnalyzer.class, (String)"WARN_SpecializesInterceptorDecorator"));
        }
    }

    private void checkAlternatives(TypeElement element, CdiAnalysisResult result) {
        if (AnnotationUtil.hasAnnotation(element, "jakarta.enterprise.inject.Alternative", result.getInfo())) {
            result.addNotification(Severity.WARNING, element, NbBundle.getMessage(AnnotationsAnalyzer.class, (String)"WARN_AlternativeInterceptorDecorator"));
        }
    }

    private void checkNamed(TypeElement element, CdiAnalysisResult result) {
        if (AnnotationUtil.hasAnnotation(element, "jakarta.inject.Named", result.getInfo())) {
            result.addNotification(Severity.WARNING, element, NbBundle.getMessage(AnnotationsAnalyzer.class, (String)"WARN_NamedInterceptorDecorator"));
        }
    }

    private void checkDelegateInjectionPoint(TypeElement element, CdiAnalysisResult result) {
        CompilationInfo compInfo = result.getInfo();
        List<? extends Element> enclosedElements = element.getEnclosedElements();
        int count = 0;
        for (Element element2 : enclosedElements) {
            if (element2.getKind() == ElementKind.CONSTRUCTOR) {
                count += this.delegateInjectionPointCount(element2, compInfo);
            } else if (!AnnotationUtil.hasAnnotation(element2, "jakarta.inject.Inject", compInfo)) continue;
            if (element2.getKind() == ElementKind.FIELD && AnnotationUtil.hasAnnotation(element2, "jakarta.decorator.Delegate", compInfo)) {
                ++count;
                continue;
            }
            if (element2.getKind() != ElementKind.METHOD) continue;
            count += this.delegateInjectionPointCount(element2, compInfo);
        }
        if (count != 1) {
            result.addError(element, NbBundle.getMessage(AnnotationsAnalyzer.class, (String)"ERR_IncorrectDelegateCount"));
        }
    }

    private int delegateInjectionPointCount(Element element, CompilationInfo compInfo) {
        int result = 0;
        ExecutableElement method = (ExecutableElement)element;
        List<? extends VariableElement> parameters = method.getParameters();
        for (VariableElement variableElement : parameters) {
            if (!AnnotationUtil.hasAnnotation(variableElement, "jakarta.decorator.Delegate", compInfo)) continue;
            ++result;
        }
        return result;
    }

    private void checkSession(TypeElement element, CdiAnalysisResult result) {
        if (AnnotationUtil.isSessionBean(element, result.getInfo())) {
            result.addError(element, NbBundle.getMessage(AnnotationsAnalyzer.class, (String)"ERR_SesssionBeanID"));
        }
    }

    private void checkMethods(TypeElement element, boolean isDecorator, CdiAnalysisResult result) {
        CompilationInfo compInfo = result.getInfo();
        List<ExecutableElement> methods = ElementFilter.methodsIn(element.getEnclosedElements());
        for (ExecutableElement method : methods) {
            boolean isProducer = AnnotationUtil.hasAnnotation(method, "jakarta.enterprise.inject.Produces", compInfo);
            boolean isDisposer = false;
            boolean isObserver = false;
            List<? extends VariableElement> parameters = method.getParameters();
            for (VariableElement variableElement : parameters) {
                if (AnnotationUtil.hasAnnotation(variableElement, "jakarta.enterprise.inject.Disposes", compInfo)) {
                    isDisposer = true;
                    break;
                }
                if (!AnnotationUtil.hasAnnotation(variableElement, "jakarta.enterprise.event.Observes", compInfo)) continue;
                isObserver = true;
                break;
            }
            if (!isProducer && !isDisposer && !isObserver) continue;
            result.addError(element, NbBundle.getMessage(AnnotationsAnalyzer.class, (String)this.getMethodErrorKey(isDecorator, isProducer, isDisposer), (Object)method.getSimpleName().toString()));
            break;
        }
    }

    private String getMethodErrorKey(boolean isDecorator, boolean isProducer, boolean isDisposer) {
        String key = null;
        key = isDecorator ? (isProducer ? "ERR_DecoratorHasProducerMethod" : (isDisposer ? "ERR_DecoratorHasDisposerMethod" : "ERR_DecoratorHasObserverMethod")) : (isProducer ? "ERR_InterceptorHasProducerMethod" : (isDisposer ? "ERR_InterceptorHasDisposerMethod" : "ERR_InterceptorHasObserverMethod"));
        return key;
    }

    private void checkProducerFields(TypeElement element, boolean isDecorator, CdiAnalysisResult result) {
        List<VariableElement> fields = ElementFilter.fieldsIn(element.getEnclosedElements());
        for (VariableElement field : fields) {
            if (!AnnotationUtil.hasAnnotation(field, "jakarta.enterprise.inject.Produces", result.getInfo())) continue;
            String key = isDecorator ? "ERR_DecoratorHasProducerField" : "ERR_IntrerceptorHasProducerField";
            result.addError(element, NbBundle.getMessage(AnnotationsAnalyzer.class, (String)key, (Object)field.getSimpleName().toString()));
            break;
        }
    }
}

