/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.git.jgit.commands;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.CheckoutConflictException;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheCheckout;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.merge.MergeMessageFormatter;
import org.eclipse.jgit.merge.MergeStrategy;
import org.eclipse.jgit.merge.ResolveMerger;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.WorkingTreeIterator;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitObjectType;
import org.netbeans.libs.git.GitRevertResult;
import org.netbeans.libs.git.jgit.GitClassFactory;
import org.netbeans.libs.git.jgit.Utils;
import org.netbeans.libs.git.jgit.commands.GitCommand;
import org.netbeans.libs.git.progress.ProgressMonitor;

public class RevertCommand
extends GitCommand {
    private final ProgressMonitor monitor;
    private final String revisionStr;
    private GitRevertResult result;
    private final String message;
    private final boolean commit;

    public RevertCommand(Repository repository, GitClassFactory gitFactory, String revision, String message, boolean commit, ProgressMonitor monitor) {
        super(repository, gitFactory, monitor);
        this.monitor = monitor;
        this.revisionStr = revision;
        this.message = message;
        this.commit = commit;
    }

    @Override
    protected String getCommandDescription() {
        StringBuilder sb = new StringBuilder("git revert ");
        if (!this.commit) {
            sb.append("-n ");
        }
        sb.append(this.revisionStr);
        return sb.toString();
    }

    @Override
    protected void run() throws GitException {
        Repository repository = this.getRepository();
        RevCommit revertedCommit = Utils.findCommit(repository, this.revisionStr);
        DirCache dc = null;
        GitRevertResult NO_CHANGE_INSTANCE = this.getClassFactory().createRevertResult(GitRevertResult.Status.NO_CHANGE, null, null, null);
        try (RevWalk revWalk = new RevWalk(repository);){
            Object commitMessage;
            Ref headRef = repository.findRef("HEAD");
            if (headRef == null) {
                throw new GitException.MissingObjectException("HEAD", GitObjectType.COMMIT);
            }
            RevCommit headCommit = revWalk.parseCommit((AnyObjectId)headRef.getObjectId());
            if (revertedCommit.getParentCount() != 1) {
                throw new GitException("Cannot revert a merge commit");
            }
            RevCommit srcParent = revertedCommit.getParent(0);
            revWalk.parseHeaders((RevObject)srcParent);
            ResolveMerger merger = (ResolveMerger)MergeStrategy.RECURSIVE.newMerger(repository);
            merger.setWorkingTreeIterator((WorkingTreeIterator)new FileTreeIterator(repository));
            merger.setBase((AnyObjectId)revertedCommit.getTree());
            Object object = commitMessage = this.message == null || this.message.isEmpty() ? "Revert \"" + revertedCommit.getShortMessage() + "\"\n\nThis reverts commit " + revertedCommit.getId().getName() + "." : this.message;
            if (merger.merge(new AnyObjectId[]{headCommit, srcParent})) {
                if (AnyObjectId.isEqual((AnyObjectId)headCommit.getTree().getId(), (AnyObjectId)merger.getResultTreeId())) {
                    this.result = NO_CHANGE_INSTANCE;
                } else {
                    dc = repository.lockDirCache();
                    DirCacheCheckout dco = new DirCacheCheckout(repository, (ObjectId)headCommit.getTree(), dc, merger.getResultTreeId());
                    dco.setFailOnConflict(true);
                    dco.checkout();
                    if (this.commit) {
                        RevCommit newHead = new Git(this.getRepository()).commit().setMessage((String)commitMessage).call();
                        this.result = this.getClassFactory().createRevertResult(GitRevertResult.Status.REVERTED, this.getClassFactory().createRevisionInfo(newHead, repository), null, null);
                    } else {
                        this.result = this.getClassFactory().createRevertResult(GitRevertResult.Status.REVERTED_IN_INDEX, null, null, null);
                    }
                }
            } else if (merger.getFailingPaths() != null) {
                this.result = this.getClassFactory().createRevertResult(GitRevertResult.Status.FAILED, null, merger.getMergeResults() == null ? null : this.getFiles(repository.getWorkTree(), merger.getMergeResults().keySet()), this.getFiles(repository.getWorkTree(), merger.getFailingPaths().keySet()));
            } else {
                String mergeMessageWithConflicts = new MergeMessageFormatter().formatWithConflicts((String)commitMessage, (Iterable)merger.getUnmergedPaths(), '#');
                repository.writeMergeCommitMsg(mergeMessageWithConflicts);
                this.result = this.getClassFactory().createRevertResult(GitRevertResult.Status.CONFLICTING, null, merger.getMergeResults() == null ? null : this.getFiles(repository.getWorkTree(), merger.getMergeResults().keySet()), null);
            }
        }
        catch (JGitInternalException ex) {
            String[] lines;
            if (ex.getCause() instanceof CheckoutConflictException && (lines = ex.getCause().getMessage().split("\n")).length > 1) {
                throw new GitException.CheckoutConflictException(Arrays.copyOfRange(lines, 1, lines.length), ex.getCause());
            }
            throw new GitException(ex);
        }
        catch (IOException | GitAPIException ex) {
            throw new GitException(ex);
        }
        finally {
            if (dc != null) {
                dc.unlock();
            }
        }
    }

    private List<File> getFiles(File workDir, Set<String> paths) {
        LinkedList<File> files = new LinkedList<File>();
        for (String path : paths) {
            files.add(new File(workDir, path));
        }
        return Collections.unmodifiableList(files);
    }

    public GitRevertResult getResult() {
        return this.result;
    }
}

