/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.auth;

import com.oracle.bmc.ConfigFileReader;
import com.oracle.bmc.Region;
import com.oracle.bmc.auth.AuthenticationDetailsProvider;
import com.oracle.bmc.auth.ConfigFileAuthenticationDetailsProvider;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.auth.SimplePrivateKeySupplier;
import com.oracle.bmc.util.internal.FileUtils;
import com.oracle.bmc.util.internal.Validate;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionTokenAuthenticationDetailsProvider
implements AuthenticationDetailsProvider,
RegionProvider,
RefreshableOnNotAuthenticatedProvider<String> {
    private static final Logger LOG = LoggerFactory.getLogger(SessionTokenAuthenticationDetailsProvider.class);
    private static final String CONFIG_FILE_DEBUG_INFORMATION_LOG = "\nFor more information about OCI configuration file and how to get required information, see https://docs.oracle.com/en-us/iaas/Content/API/Concepts/sdkconfig.htm";
    private final SimplePrivateKeySupplier privateKeySupplier;
    private final Region region;
    private final char[] passphraseCharacters;
    private final String tenantId;
    private final String fingerprint;
    private final String userId;
    private final String sessionTokenFilePath;
    private String sessionToken;

    public SessionTokenAuthenticationDetailsProvider() throws IOException {
        this(ConfigFileReader.parseDefault());
    }

    public SessionTokenAuthenticationDetailsProvider(String profile) throws IOException {
        this(ConfigFileReader.parseDefault(profile));
    }

    public SessionTokenAuthenticationDetailsProvider(String configurationFilePath, String profile) throws IOException {
        this(ConfigFileReader.parse(configurationFilePath, profile));
    }

    public SessionTokenAuthenticationDetailsProvider(ConfigFileReader.ConfigFile configFile) throws IOException {
        this.sessionTokenFilePath = Validate.notNull(configFile.get("security_token_file"), "Missing security_token_file in config.\nFor more information about OCI configuration file and how to get required information, see https://docs.oracle.com/en-us/iaas/Content/API/Concepts/sdkconfig.htm", new Object[0]);
        this.tenantId = Validate.notNull(configFile.get("tenancy"), "Missing tenancy in config.\nFor more information about OCI configuration file and how to get required information, see https://docs.oracle.com/en-us/iaas/Content/API/Concepts/sdkconfig.htm", new Object[0]);
        String pemFilePath = Validate.notNull(configFile.get("key_file"), "Missing key_file in config.\nFor more information about OCI configuration file and how to get required information, see https://docs.oracle.com/en-us/iaas/Content/API/Concepts/sdkconfig.htm", new Object[0]);
        this.privateKeySupplier = new SimplePrivateKeySupplier(pemFilePath);
        this.region = ConfigFileAuthenticationDetailsProvider.getRegionFromConfigFile(configFile);
        this.setSessionTokenFromFilePath(this.sessionTokenFilePath);
        this.fingerprint = configFile.get("fingerprint");
        this.userId = configFile.get("user");
        String passPhrase = configFile.get("pass_phrase");
        this.passphraseCharacters = passPhrase != null ? passPhrase.toCharArray() : null;
    }

    public void setSessionTokenFromFilePath(String sessionTokenFilePath) throws IOException {
        File sessionTokenFile = new File(FileUtils.expandUserHome(sessionTokenFilePath));
        StringBuilder token = new StringBuilder();
        LOG.info("Loading session token from: {}", (Object)sessionTokenFile.getAbsolutePath());
        Scanner reader = new Scanner(sessionTokenFile);
        while (reader.hasNextLine()) {
            token.append(reader.nextLine());
        }
        reader.close();
        this.setSessionToken(token.toString());
    }

    public void setSessionToken(String sessionToken) {
        this.sessionToken = sessionToken;
    }

    @Override
    public String refresh() {
        LOG.debug("Refreshing session token");
        String oldSessionToken = this.sessionToken;
        try {
            this.setSessionTokenFromFilePath(this.sessionTokenFilePath);
            if (this.sessionToken.equals(oldSessionToken)) {
                LOG.warn("A session token refresh was attempted but it did not change. The token file has not been updated!");
            }
        }
        catch (IOException e) {
            LOG.warn("Unable to refresh session token.", (Throwable)e);
            e.printStackTrace();
        }
        return this.sessionToken;
    }

    @Override
    public String getKeyId() {
        return "ST$" + this.sessionToken;
    }

    @Override
    public InputStream getPrivateKey() {
        return this.privateKeySupplier.get();
    }

    @Override
    @Deprecated
    public String getPassPhrase() {
        return this.passphraseCharacters != null ? new String(this.passphraseCharacters) : null;
    }

    @Override
    public char[] getPassphraseCharacters() {
        return this.passphraseCharacters;
    }

    @Override
    public String getFingerprint() {
        return this.fingerprint;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public String getUserId() {
        return this.userId;
    }

    @Override
    public Region getRegion() {
        return this.region;
    }
}

