# Monica Documentation
Welcome to Monica - a great, simple yet complete, open-source personal relationship manager platform.

This doc is the main source of documentation for developers working with (or contributing to) the Monica project, and advanced users who want to install Monica on their servers. If this is your first time hearing about Monica, we recommend starting with [Monica website](https://monicahq.com).

## Table of content

* [Use Monica](/docs/user/readme.md)
* Install Monica on your server
    * [Install a new instance](/docs/installation/readme.md)
    * [Maintain your server](/docs/installation/update.md)
* Contribute to Monica
    * [Contribute as a developer](/docs/contribute/readme.md)
    * [Help translate the application](/docs/contribute/translate.md)

**Specific to Monica's core contributors**
* [Add content](/docs/administrators/tips.md)
* [Deployment instructions](/docs/administrators/deployment.md)

## Thanks to companies and open source projects

The Monica project is extremely grateful for the help provided by the following companies and open source projects.

### Companies

Those companies have graciously offered a paid plan for free.

| **Supported by**                 | **Description**                                                                               |
|----------------------------------|-----------------------------------------------------------------------------------------------|
| Sentry | [Sentry](https://sentry.io) is a cross-platform crash reporting and aggregation platform. We use it to analyze what's going on in production. |
| Crowdin | [Crowdin](https://crowdin.com/project/monicahq) is a translation platform. |
| Cypress | [Cypress](https://dashboard.cypress.io/projects/q8h6k9/runs) is an end-to-end test platform. |

### Open source projects

Monica is built upon the shoulders of incredible open source projects. We simply wouldn't exist without them.

* [Laravel](http://laravel.com/)
* [Git](http://git-scm.com/)
* [Linux](http://linux.org/)
