/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.organization.validator;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.keycloak.Config;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.common.Profile;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.OrganizationDomainModel;
import org.keycloak.models.OrganizationModel;
import org.keycloak.models.UserModel;
import org.keycloak.organization.OrganizationProvider;
import org.keycloak.organization.utils.Organizations;
import org.keycloak.provider.EnvironmentDependentProviderFactory;
import org.keycloak.userprofile.AttributeContext;
import org.keycloak.userprofile.UserProfileAttributeValidationContext;
import org.keycloak.userprofile.UserProfileContext;
import org.keycloak.utils.StringUtil;
import org.keycloak.validate.AbstractSimpleValidator;
import org.keycloak.validate.BuiltinValidators;
import org.keycloak.validate.ValidationContext;
import org.keycloak.validate.ValidationError;
import org.keycloak.validate.ValidatorConfig;

public class OrganizationMemberValidator
extends AbstractSimpleValidator
implements EnvironmentDependentProviderFactory {
    public static final String ID = "organization-member-validator";

    public String getId() {
        return ID;
    }

    protected void doValidate(Object value, String inputHint, ValidationContext context, ValidatorConfig config) {
        KeycloakSession session = context.getSession();
        OrganizationModel organization = this.resolveOrganization(context, session);
        if (organization == null) {
            return;
        }
        this.validateEmailDomain((String)value, inputHint, context, organization);
    }

    protected boolean skipValidation(Object value, ValidatorConfig config) {
        return false;
    }

    public boolean isSupported(Config.Scope config) {
        return Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.ORGANIZATION);
    }

    private void validateEmailDomain(String email, String inputHint, ValidationContext context, OrganizationModel organization) {
        if (!"email".equals(inputHint)) {
            return;
        }
        if (StringUtil.isBlank((String)email)) {
            context.addError(new ValidationError(ID, inputHint, "Email not set"));
            return;
        }
        if (!BuiltinValidators.emailValidator().validate((Object)email, inputHint, context).isValid()) {
            return;
        }
        UserProfileAttributeValidationContext upContext = (UserProfileAttributeValidationContext)context;
        AttributeContext attributeContext = upContext.getAttributeContext();
        UserModel user = attributeContext.getUser();
        String emailDomain = email.substring(email.indexOf(64) + 1);
        Set<Object> expectedDomains = organization.getDomains().map(OrganizationDomainModel::getName).collect(Collectors.toSet());
        if (expectedDomains.isEmpty()) {
            return;
        }
        if (UserProfileContext.IDP_REVIEW.equals((Object)attributeContext.getContext())) {
            expectedDomains = OrganizationMemberValidator.resolveExpectedDomainsWhenReviewingFederatedUserProfile(organization, attributeContext);
        } else if (organization.isManaged(user)) {
            expectedDomains = OrganizationMemberValidator.resolveExpectedDomainsForManagedUser(context, user);
        } else {
            return;
        }
        if (expectedDomains.isEmpty() || expectedDomains.contains(emailDomain)) {
            return;
        }
        context.addError(new ValidationError(ID, inputHint, "Email domain does not match any domain from the organization"));
    }

    private static Set<String> resolveExpectedDomainsForManagedUser(ValidationContext context, UserModel user) {
        List<IdentityProviderModel> brokers = Organizations.resolveBroker(context.getSession(), user);
        if (brokers.isEmpty()) {
            return Set.of();
        }
        HashSet<String> domains = new HashSet<String>();
        for (IdentityProviderModel broker : brokers) {
            String domain = (String)broker.getConfig().get("kc.org.domain");
            if (domain == null) continue;
            domains.add(domain);
        }
        return Collections.unmodifiableSet(domains);
    }

    private static Set<String> resolveExpectedDomainsWhenReviewingFederatedUserProfile(OrganizationModel organization, AttributeContext attributeContext) {
        KeycloakSession session = attributeContext.getSession();
        BrokeredIdentityContext brokerContext = (BrokeredIdentityContext)session.getAttribute(BrokeredIdentityContext.class.getName());
        if (brokerContext == null) {
            return Set.of();
        }
        String alias = brokerContext.getIdpConfig().getAlias();
        IdentityProviderModel broker = organization.getIdentityProviders().filter(p -> p.getAlias().equals(alias)).findAny().orElse(null);
        if (broker == null) {
            return Set.of();
        }
        String brokerDomain = (String)broker.getConfig().get("kc.org.domain");
        return Optional.ofNullable(brokerDomain).map(Set::of).orElse(Set.of());
    }

    private OrganizationModel resolveOrganization(ValidationContext context, KeycloakSession session) {
        OrganizationModel organization = (OrganizationModel)session.getAttribute(OrganizationModel.class.getName());
        if (organization != null) {
            return organization;
        }
        UserProfileAttributeValidationContext upContext = (UserProfileAttributeValidationContext)context;
        AttributeContext attributeContext = upContext.getAttributeContext();
        UserModel user = attributeContext.getUser();
        if (user != null) {
            OrganizationProvider provider = (OrganizationProvider)session.getProvider(OrganizationProvider.class);
            return provider.getByMember(user);
        }
        return null;
    }
}

