/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.security.policyeditor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.DefaultListModel;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sourceforge.jnlp.OptionsDefinitions;
import net.sourceforge.jnlp.about.AboutDialog;
import net.sourceforge.jnlp.config.PathsAndFiles;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.security.policyeditor.CustomPermission;
import net.sourceforge.jnlp.security.policyeditor.CustomPolicyViewer;
import net.sourceforge.jnlp.security.policyeditor.IndeterminateProgressDialog;
import net.sourceforge.jnlp.security.policyeditor.InvalidPolicyException;
import net.sourceforge.jnlp.security.policyeditor.PolicyEditorAboutDialog;
import net.sourceforge.jnlp.security.policyeditor.PolicyEditorController;
import net.sourceforge.jnlp.security.policyeditor.PolicyEditorPermissions;
import net.sourceforge.jnlp.util.FileUtils;
import net.sourceforge.jnlp.util.docprovider.PolicyEditorTextsProvider;
import net.sourceforge.jnlp.util.docprovider.formatters.formatters.PlainTextFormatter;
import net.sourceforge.jnlp.util.logging.OutputController;
import net.sourceforge.jnlp.util.optionparser.OptionParser;

public class PolicyEditor
extends JPanel {
    public static final String HELP_FLAG = OptionsDefinitions.OPTIONS.HELP1.option;
    public static final String FILE_FLAG = OptionsDefinitions.OPTIONS.FILE.option;
    public static final String CODEBASE_FLAG = OptionsDefinitions.OPTIONS.CODEBASE.option;
    private boolean closed = false;
    private final Map<PolicyEditorPermissions, JCheckBox> checkboxMap = new TreeMap<PolicyEditorPermissions, JCheckBox>();
    private final List<JCheckBoxWithGroup> groupBoxList = new ArrayList<JCheckBoxWithGroup>(PolicyEditorPermissions.Group.values().length);
    private final JScrollPane scrollPane = new JScrollPane();
    private final DefaultListModel<String> listModel = new DefaultListModel();
    private final JList<String> list = new JList<String>(this.listModel);
    private final JButton okButton = new JButton();
    private final JButton closeButton = new JButton();
    private final JButton addCodebaseButton = new JButton();
    private final JButton removeCodebaseButton = new JButton();
    private final JFileChooser fileChooser;
    private CustomPolicyViewer cpViewer = null;
    private final WeakReference<PolicyEditor> parentPolicyEditor = new WeakReference<PolicyEditor>(this);
    public final PolicyEditorController policyEditorController = new PolicyEditorController();
    private final ActionListener okButtonAction;
    private final ActionListener addCodebaseButtonAction;
    private final ActionListener removeCodebaseButtonAction;
    private final ActionListener newButtonAction;
    private final ActionListener openButtonAction;
    private final ActionListener openDefaultButtonAction;
    private final ActionListener saveAsButtonAction;
    private final ActionListener viewCustomButtonAction;
    private final ActionListener renameCodebaseButtonAction;
    private final ActionListener copyCodebaseButtonAction;
    private final ActionListener pasteCodebaseButtonAction;
    private final ActionListener policyEditorHelpButtonAction;
    private final ActionListener aboutPolicyEditorButtonAction;
    private final ActionListener aboutItwButtonAction;
    private final ActionListener closeButtonAction;

    public PolicyEditor(String filepath) {
        this.setLayout(new GridBagLayout());
        for (PolicyEditorPermissions perm : PolicyEditorPermissions.values()) {
            JCheckBox box = new JCheckBox();
            box.setText(perm.getName());
            box.setToolTipText(perm.getDescription());
            this.checkboxMap.put(perm, box);
        }
        this.setFile(filepath);
        if (filepath != null) {
            try {
                this.policyEditorController.openAndParsePolicyFile();
            }
            catch (FileNotFoundException fnfe) {
                OutputController.getLogger().log(fnfe);
                FileUtils.showCouldNotOpenDialog(this, Translator.R("PECouldNotOpen"));
            }
            catch (IOException | InvalidPolicyException e) {
                OutputController.getLogger().log(e);
                OutputController.getLogger().log(OutputController.Level.ERROR_ALL, Translator.R("RCantOpenFile", this.policyEditorController.getFile().getPath()));
                FileUtils.showCouldNotOpenDialog(this, Translator.R("PECouldNotOpen"));
            }
            try {
                this.invokeRunnableOrEnqueueAndWait(new Runnable(){

                    @Override
                    public void run() {
                        for (String codebase : PolicyEditor.this.policyEditorController.getCodebases()) {
                            String model = codebase.isEmpty() ? Translator.R("PEGlobalSettings") : codebase;
                            if (PolicyEditor.this.listModel.contains(model)) continue;
                            PolicyEditor.this.listModel.addElement(model);
                        }
                        PolicyEditor.this.addNewCodebase("");
                    }
                });
            }
            catch (InterruptedException | InvocationTargetException e) {
                OutputController.getLogger().log(e);
            }
        }
        this.setChangesMade(false);
        this.fileChooser = new JFileChooser(this.policyEditorController.getFile());
        this.fileChooser.setFileHidingEnabled(false);
        this.okButtonAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                int choice;
                if (PolicyEditor.this.policyEditorController.getFile() == null && (choice = PolicyEditor.this.fileChooser.showOpenDialog(PolicyEditor.this)) == 0) {
                    PolicyEditor.this.setFile(PolicyEditor.this.fileChooser.getSelectedFile().getAbsolutePath());
                }
                if (PolicyEditor.this.policyEditorController.getFile() != null) {
                    PolicyEditor.this.savePolicyFile();
                }
            }
        };
        this.okButton.setText(Translator.R("ButApply"));
        this.okButton.addActionListener(this.okButtonAction);
        this.addCodebaseButtonAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PolicyEditor.this.addNewCodebaseInteractive();
            }
        };
        this.addCodebaseButton.setText(Translator.R("PEAddCodebase"));
        this.addCodebaseButton.addActionListener(this.addCodebaseButtonAction);
        this.removeCodebaseButtonAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PolicyEditor.this.removeCodebase(PolicyEditor.this.getSelectedCodebase());
            }
        };
        this.removeCodebaseButton.setText(Translator.R("PERemoveCodebase"));
        this.removeCodebaseButton.addActionListener(this.removeCodebaseButtonAction);
        this.newButtonAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!PolicyEditor.this.promptOnSaveChangesMade(false)) {
                    return;
                }
                PolicyEditor.this.setFile(null);
                PolicyEditor.this.setChangesMade(false);
            }
        };
        this.openButtonAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!PolicyEditor.this.promptOnSaveChangesMade(true)) {
                    return;
                }
                int choice = PolicyEditor.this.fileChooser.showOpenDialog(PolicyEditor.this);
                if (choice == 0) {
                    PolicyEditor.this.setFile(PolicyEditor.this.fileChooser.getSelectedFile().getAbsolutePath());
                    PolicyEditor.this.openAndParsePolicyFile();
                }
            }
        };
        this.openDefaultButtonAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!PolicyEditor.this.promptOnSaveChangesMade(true)) {
                    return;
                }
                try {
                    PolicyEditor.this.setFile(PolicyEditor.getDefaultPolicyFilePath());
                    PolicyEditor.this.getFile().createNewFile();
                }
                catch (IOException ex) {
                    OutputController.getLogger().log(ex);
                }
                catch (URISyntaxException ex) {
                    OutputController.getLogger().log(ex);
                }
                PolicyEditor.this.openAndParsePolicyFile();
            }
        };
        this.saveAsButtonAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int choice = PolicyEditor.this.fileChooser.showSaveDialog(PolicyEditor.this);
                if (choice == 0) {
                    PolicyEditor.this.setFile(PolicyEditor.this.fileChooser.getSelectedFile().getAbsolutePath());
                    PolicyEditor.this.setChangesMade(true);
                    PolicyEditor.this.savePolicyFile();
                }
            }
        };
        this.renameCodebaseButtonAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String oldCodebase = PolicyEditor.this.getSelectedCodebase();
                if (oldCodebase.isEmpty()) {
                    return;
                }
                String newCodebase = "";
                while (!PolicyEditor.validateCodebase(newCodebase) || PolicyEditor.this.policyEditorController.getCopyOfPermissions().containsKey(newCodebase)) {
                    newCodebase = JOptionPane.showInputDialog(PolicyEditor.this, Translator.R("PERenameCodebase"), oldCodebase);
                    if (newCodebase != null) continue;
                    return;
                }
                PolicyEditor.this.renameCodebase(oldCodebase, newCodebase);
            }
        };
        this.copyCodebaseButtonAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PolicyEditor.this.copyCodebase(PolicyEditor.this.getSelectedCodebase());
            }
        };
        this.pasteCodebaseButtonAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String clipboardCodebase = null;
                try {
                    String newCodebase;
                    clipboardCodebase = PolicyEditor.this.policyEditorController.getCodebaseFromClipboard();
                    if (PolicyEditor.this.getCodebases().contains(clipboardCodebase)) {
                        String cb = "";
                        while (!PolicyEditor.validateCodebase(cb) || PolicyEditor.this.policyEditorController.getCopyOfPermissions().containsKey(cb)) {
                            cb = JOptionPane.showInputDialog(PolicyEditor.this, Translator.R("PEPasteCodebase"), "http://");
                            if (cb != null) continue;
                            return;
                        }
                        newCodebase = cb;
                    } else {
                        newCodebase = clipboardCodebase;
                    }
                    if (PolicyEditor.validateCodebase(newCodebase)) {
                        PolicyEditor.this.pasteCodebase(newCodebase);
                    }
                }
                catch (UnsupportedFlavorException ufe) {
                    OutputController.getLogger().log(ufe);
                    PolicyEditor.this.showClipboardErrorDialog();
                }
                catch (InvalidPolicyException ipe) {
                    OutputController.getLogger().log(ipe);
                    PolicyEditor.this.showInvalidPolicyExceptionDialog(clipboardCodebase);
                }
                catch (IOException ioe) {
                    OutputController.getLogger().log(ioe);
                    PolicyEditor.this.showCouldNotAccessClipboardDialog();
                }
            }
        };
        this.viewCustomButtonAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PolicyEditor.this.invokeRunnableOrEnqueueLater(new Runnable(){

                    @Override
                    public void run() {
                        String codebase = PolicyEditor.this.getSelectedCodebase();
                        if (codebase == null) {
                            return;
                        }
                        if (PolicyEditor.this.cpViewer == null) {
                            PolicyEditor.this.cpViewer = new CustomPolicyViewer(PolicyEditor.this, codebase);
                            PolicyEditor.this.cpViewer.setVisible(true);
                        } else {
                            PolicyEditor.this.cpViewer.toFront();
                            PolicyEditor.this.cpViewer.repaint();
                        }
                    }
                });
            }
        };
        this.policyEditorHelpButtonAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new PolicyEditorAboutDialog(Translator.R("PEHelpDialogTitle"), Translator.R("PEHelpDialogContent")).setVisible(true);
            }
        };
        this.aboutPolicyEditorButtonAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean modal = PolicyEditor.this.getModality();
                AboutDialog.display(modal, "policyeditor", AboutDialog.ShowPage.HELP);
            }
        };
        this.aboutItwButtonAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean modal = PolicyEditor.this.getModality();
                AboutDialog.display(modal, "policyeditor");
            }
        };
        this.closeButtonAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Window parentWindow = SwingUtilities.getWindowAncestor(PolicyEditor.this);
                if (parentWindow instanceof PolicyEditorWindow) {
                    ((PolicyEditorWindow)((Object)parentWindow)).quit();
                }
            }
        };
        this.closeButton.setText(Translator.R("ButClose"));
        this.closeButton.addActionListener(this.closeButtonAction);
        this.setupLayout();
    }

    private static String getDefaultPolicyFilePath() throws URISyntaxException {
        return new File(new URI(PathsAndFiles.JAVA_POLICY.getFullPath())).getAbsolutePath();
    }

    private boolean getModality() {
        boolean modal = false;
        for (Container parent = this; parent != null; parent = parent.getParent()) {
            if (!(parent instanceof JDialog)) continue;
            modal = ((JDialog)parent).isModal();
            break;
        }
        return modal;
    }

    private boolean promptOnSaveChangesMade(boolean async) {
        if (this.policyEditorController.changesMade()) {
            int save = JOptionPane.showConfirmDialog(this, Translator.R("PESaveChanges"));
            if (save == 0) {
                if (this.policyEditorController.getFile() == null) {
                    int choice = this.fileChooser.showSaveDialog(this);
                    if (choice == 0) {
                        this.setFile(this.fileChooser.getSelectedFile().getAbsolutePath());
                    } else if (choice == 1) {
                        return false;
                    }
                }
                if (async) {
                    this.savePolicyFile();
                } else {
                    try {
                        this.policyEditorController.savePolicyFile();
                    }
                    catch (IOException e) {
                        this.showCouldNotSaveDialog();
                    }
                }
            } else if (save == 2) {
                return false;
            }
        }
        return true;
    }

    public void setFile(String filepath) {
        if (filepath != null) {
            this.policyEditorController.setFile(new File(filepath));
        } else {
            this.policyEditorController.setFile(null);
            this.resetCodebases();
            this.addNewCodebase("");
        }
        this.setParentWindowTitle(this.getWindowTitleForStatus());
    }

    private void setParentWindowTitle(final String title) {
        this.invokeRunnableOrEnqueueLater(new Runnable(){

            @Override
            public void run() {
                Window parent = SwingUtilities.getWindowAncestor(PolicyEditor.this);
                if (!(parent instanceof PolicyEditorWindow)) {
                    return;
                }
                PolicyEditorWindow window = (PolicyEditorWindow)((Object)parent);
                window.setTitle(title);
            }
        });
    }

    private String getWindowTitleForStatus() {
        File file = this.getFile();
        String filepath = file != null ? file.getPath() : null;
        String titleAndPath = filepath != null ? Translator.R("PETitleWithPath", filepath) : Translator.R("PETitle");
        String result = this.policyEditorController.changesMade() ? Translator.R("PETitleWithChangesMade", titleAndPath) : titleAndPath;
        return result;
    }

    private String getSelectedCodebase() {
        String codebase = this.list.getSelectedValue();
        if (codebase == null || codebase.isEmpty()) {
            return null;
        }
        if (codebase.equals(Translator.R("PEGlobalSettings"))) {
            return "";
        }
        return codebase;
    }

    private static void preparePolicyEditorWindow(PolicyEditorWindow w, PolicyEditor e) {
        w.setModalityType(Dialog.ModalityType.MODELESS);
        w.setPolicyEditor(e);
        w.setTitle(Translator.R("PETitle"));
        w.setDefaultCloseOperation(0);
        w.setJMenuBar(PolicyEditor.createMenuBar(w.getPolicyEditor()));
        PolicyEditor.setupPolicyEditorWindow(w.asWindow(), w.getPolicyEditor());
    }

    private static void setupPolicyEditorWindow(final Window window, PolicyEditor editor) {
        window.add(editor);
        window.pack();
        editor.setVisible(true);
        window.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ((PolicyEditorWindow)((Object)window)).quit();
            }
        });
    }

    private static void policyEditorWindowQuit(Window window) {
        PolicyEditor editor = ((PolicyEditorWindow)((Object)window)).getPolicyEditor();
        editor.parentPolicyEditor.clear();
        if (editor.policyEditorController.changesMade()) {
            int save = JOptionPane.showConfirmDialog(window, Translator.R("PESaveChanges"));
            if (save == 0) {
                if (editor.policyEditorController.getFile() == null) {
                    int choice = editor.fileChooser.showSaveDialog(window);
                    if (choice == 0) {
                        editor.setFile(editor.fileChooser.getSelectedFile().getAbsolutePath());
                    } else if (choice == 1) {
                        return;
                    }
                }
                try {
                    editor.policyEditorController.savePolicyFile();
                }
                catch (IOException e) {
                    OutputController.getLogger().log(e);
                    editor.showCouldNotSaveDialog();
                    return;
                }
            } else if (save == 2) {
                return;
            }
        }
        editor.setClosed();
        window.dispose();
    }

    public static PolicyEditorWindow getPolicyEditorFrame(String filepath) {
        return new PolicyEditorFrame(new PolicyEditor(filepath));
    }

    public static PolicyEditorWindow getPolicyEditorDialog(String filepath) {
        return new PolicyEditorDialog(new PolicyEditor(filepath));
    }

    private void setClosed() {
        this.closed = true;
    }

    public boolean isClosed() {
        return this.closed;
    }

    void customPolicyViewerClosing() {
        this.cpViewer = null;
    }

    public void addNewCodebase(final String codebase) {
        if (!codebase.isEmpty() && !PolicyEditor.validateCodebase(codebase)) {
            OutputController.getLogger().log("Could not add codebase " + codebase);
            return;
        }
        final String model = codebase.isEmpty() ? Translator.R("PEGlobalSettings") : codebase;
        this.policyEditorController.addCodebase(codebase);
        this.invokeRunnableOrEnqueueLater(new Runnable(){

            @Override
            public void run() {
                if (!PolicyEditor.this.listModel.contains(model)) {
                    PolicyEditor.this.listModel.addElement(model);
                    PolicyEditor.this.setChangesMade(true);
                }
                PolicyEditor.this.list.setSelectedValue(model, true);
                PolicyEditor.this.updateCheckboxes(codebase);
            }
        });
    }

    private static boolean validateCodebase(String codebase) {
        try {
            new URL(codebase);
        }
        catch (MalformedURLException mue) {
            return false;
        }
        return true;
    }

    public File getFile() {
        return this.policyEditorController.getFile();
    }

    public void addNewCodebaseInteractive() {
        this.invokeRunnableOrEnqueueLater(new Runnable(){

            @Override
            public void run() {
                String codebase = "";
                while (!PolicyEditor.validateCodebase(codebase)) {
                    codebase = JOptionPane.showInputDialog(PolicyEditor.this, Translator.R("PECodebasePrompt"), "http://");
                    if (codebase != null) continue;
                    return;
                }
                PolicyEditor.this.addNewCodebase(codebase);
            }
        });
    }

    public void removeCodebase(final String codebase) {
        if (codebase.equals(Translator.R("PEGlobalSettings")) || codebase.isEmpty()) {
            return;
        }
        int previousIndex = this.list.getSelectedIndex() - 1;
        if (previousIndex < 0) {
            previousIndex = 0;
        }
        this.policyEditorController.removeCodebase(codebase);
        final int fIndex = previousIndex;
        this.invokeRunnableOrEnqueueLater(new Runnable(){

            @Override
            public void run() {
                PolicyEditor.this.listModel.removeElement(codebase);
                PolicyEditor.this.list.setSelectedIndex(fIndex);
            }
        });
        this.setChangesMade(true);
    }

    public void renameCodebase(String oldCodebase, String newCodebase) {
        Map<PolicyEditorPermissions, Boolean> permissions = this.getPermissions(oldCodebase);
        Collection<CustomPermission> customPermissions = this.getCustomPermissions(oldCodebase);
        this.removeCodebase(oldCodebase);
        this.addNewCodebase(newCodebase);
        for (Map.Entry<PolicyEditorPermissions, Boolean> entry : permissions.entrySet()) {
            this.setPermission(newCodebase, entry.getKey(), entry.getValue());
        }
        for (CustomPermission permission : customPermissions) {
            this.addCustomPermission(newCodebase, permission);
        }
        this.updateCheckboxes(newCodebase);
    }

    public void copyCodebase(String codebase) {
        if (!this.getCodebases().contains(codebase)) {
            return;
        }
        this.policyEditorController.copyCodebaseToClipboard(codebase);
    }

    public void pasteCodebase(String newCodebase) throws UnsupportedFlavorException, InvalidPolicyException, IOException {
        Map<PolicyEditorPermissions, Boolean> permissions = this.policyEditorController.getPermissionsFromClipboard();
        Set<CustomPermission> customPermissions = this.policyEditorController.getCustomPermissionsFromClipboard();
        this.addNewCodebase(newCodebase);
        for (Map.Entry<PolicyEditorPermissions, Boolean> entry : permissions.entrySet()) {
            this.policyEditorController.setPermission(newCodebase, entry.getKey(), entry.getValue());
        }
        this.policyEditorController.addCustomPermissions(newCodebase, customPermissions);
        this.setChangesMade(true);
        this.updateCheckboxes(newCodebase);
    }

    public Set<String> getCodebases() {
        return this.policyEditorController.getCodebases();
    }

    public void setPermission(String codebase, PolicyEditorPermissions permission, boolean state) {
        this.policyEditorController.setPermission(codebase, permission, state);
    }

    public Map<PolicyEditorPermissions, Boolean> getPermissions(String codebase) {
        return this.policyEditorController.getPermissions(codebase);
    }

    public void addCustomPermission(String codebase, CustomPermission permission) {
        this.policyEditorController.addCustomPermission(codebase, permission);
    }

    public Collection<CustomPermission> getCustomPermissions(String codebase) {
        return this.policyEditorController.getCustomPermissions(codebase);
    }

    public void clearCustomPermissions(String codebase) {
        this.policyEditorController.clearCustomCodebase(codebase);
    }

    private void invokeRunnableOrEnqueueLater(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    private void invokeRunnableOrEnqueueAndWait(Runnable runnable) throws InvocationTargetException, InterruptedException {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeAndWait(runnable);
        }
    }

    private void updateCheckboxes(final String codebase) {
        try {
            this.invokeRunnableOrEnqueueAndWait(new Runnable(){

                @Override
                public void run() {
                    PolicyEditor.this.updateCheckboxesImpl(codebase);
                }
            });
        }
        catch (InterruptedException ex) {
            OutputController.getLogger().log(ex);
        }
        catch (InvocationTargetException ex) {
            OutputController.getLogger().log(ex);
        }
    }

    private void updateCheckboxesImpl(final String codebase) {
        if (!this.getCodebases().contains(codebase)) {
            return;
        }
        final Map<PolicyEditorPermissions, Boolean> map = this.policyEditorController.getCopyOfPermissions().get(codebase);
        for (final PolicyEditorPermissions perm : PolicyEditorPermissions.values()) {
            final JCheckBox box = this.checkboxMap.get((Object)perm);
            for (ActionListener l : box.getActionListeners()) {
                box.removeActionListener(l);
            }
            boolean state = this.policyEditorController.getPermission(codebase, perm);
            for (JCheckBoxWithGroup jg : this.groupBoxList) {
                jg.setState(map);
            }
            box.setSelected(state);
            box.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PolicyEditor.this.setChangesMade(true);
                    PolicyEditor.this.policyEditorController.setPermission(codebase, perm, box.isSelected());
                    for (JCheckBoxWithGroup jg : PolicyEditor.this.groupBoxList) {
                        jg.setState(map);
                    }
                }
            });
        }
    }

    private static void setButtonMnemonic(AbstractButton button, String mnemonic) {
        if (mnemonic.length() != 1) {
            OutputController.getLogger().log(OutputController.Level.WARNING_DEBUG, "Could not set mnemonic \"" + mnemonic + "\" for " + button);
            return;
        }
        char ch = mnemonic.charAt(0);
        button.setMnemonic(ch);
    }

    private static void setMenuItemAccelerator(JMenuItem menuItem, String accelerator) {
        KeyStroke ks = KeyStroke.getKeyStroke(accelerator);
        menuItem.setAccelerator(ks);
    }

    private static JMenuBar createMenuBar(final PolicyEditor editor) {
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu(Translator.R("PEFileMenu"));
        PolicyEditor.setButtonMnemonic(fileMenu, Translator.R("PEFileMenuMnemonic"));
        JMenuItem newItem = new JMenuItem(Translator.R("PENewMenuItem"));
        PolicyEditor.setButtonMnemonic(newItem, Translator.R("PENewMenuItemMnemonic"));
        PolicyEditor.setMenuItemAccelerator(newItem, Translator.R("PENewMenuItemAccelerator"));
        newItem.addActionListener(editor.newButtonAction);
        fileMenu.add(newItem);
        JMenuItem openItem = new JMenuItem(Translator.R("PEOpenMenuItem"));
        PolicyEditor.setButtonMnemonic(openItem, Translator.R("PEOpenMenuItemMnemonic"));
        PolicyEditor.setMenuItemAccelerator(openItem, Translator.R("PEOpenMenuItemAccelerator"));
        openItem.addActionListener(editor.openButtonAction);
        fileMenu.add(openItem);
        JMenuItem openDefaultItem = new JMenuItem(Translator.R("PEOpenDefaultMenuItem"));
        PolicyEditor.setButtonMnemonic(openDefaultItem, Translator.R("PEOpenDefaultMenuItemMnemonic"));
        PolicyEditor.setMenuItemAccelerator(openDefaultItem, Translator.R("PEOpenDefaultMenuItemAccelerator"));
        openDefaultItem.addActionListener(editor.openDefaultButtonAction);
        fileMenu.add(openDefaultItem);
        JMenuItem saveItem = new JMenuItem(Translator.R("PESaveMenuItem"));
        PolicyEditor.setButtonMnemonic(saveItem, Translator.R("PESaveMenuItemMnemonic"));
        PolicyEditor.setMenuItemAccelerator(saveItem, Translator.R("PESaveMenuItemAccelerator"));
        saveItem.addActionListener(editor.okButtonAction);
        fileMenu.add(saveItem);
        JMenuItem saveAsItem = new JMenuItem(Translator.R("PESaveAsMenuItem"));
        PolicyEditor.setButtonMnemonic(saveAsItem, Translator.R("PESaveAsMenuItemMnemonic"));
        PolicyEditor.setMenuItemAccelerator(saveAsItem, Translator.R("PESaveAsMenuItemAccelerator"));
        saveAsItem.addActionListener(editor.saveAsButtonAction);
        fileMenu.add(saveAsItem);
        JMenuItem exitItem = new JMenuItem(Translator.R("PEExitMenuItem"));
        PolicyEditor.setButtonMnemonic(exitItem, Translator.R("PEExitMenuItemMnemonic"));
        PolicyEditor.setMenuItemAccelerator(exitItem, Translator.R("PEExitMenuItemAccelerator"));
        exitItem.addActionListener(editor.closeButtonAction);
        fileMenu.add(exitItem);
        menuBar.add(fileMenu);
        JMenu codebaseMenu = new JMenu(Translator.R("PECodebaseMenu"));
        PolicyEditor.setButtonMnemonic(codebaseMenu, Translator.R("PECodebaseMenuMnemonic"));
        JMenuItem addNewCodebaseItem = new JMenuItem(Translator.R("PEAddCodebaseItem"));
        PolicyEditor.setButtonMnemonic(addNewCodebaseItem, Translator.R("PEAddCodebaseItemMnemonic"));
        PolicyEditor.setMenuItemAccelerator(addNewCodebaseItem, Translator.R("PEAddCodebaseItemAccelerator"));
        addNewCodebaseItem.addActionListener(editor.addCodebaseButtonAction);
        codebaseMenu.add(addNewCodebaseItem);
        JMenuItem removeCodebaseItem = new JMenuItem(Translator.R("PERemoveCodebaseItem"));
        PolicyEditor.setButtonMnemonic(removeCodebaseItem, Translator.R("PERemoveCodebaseItemMnemonic"));
        PolicyEditor.setMenuItemAccelerator(removeCodebaseItem, Translator.R("PERemoveCodebaseItemAccelerator"));
        removeCodebaseItem.addActionListener(editor.removeCodebaseButtonAction);
        codebaseMenu.add(removeCodebaseItem);
        codebaseMenu.addSeparator();
        JMenuItem renameCodebaseItem = new JMenuItem(Translator.R("PERenameCodebaseItem"));
        PolicyEditor.setButtonMnemonic(renameCodebaseItem, Translator.R("PERenameCodebaseItemMnemonic"));
        PolicyEditor.setMenuItemAccelerator(renameCodebaseItem, Translator.R("PERenameCodebaseItemAccelerator"));
        renameCodebaseItem.addActionListener(editor.renameCodebaseButtonAction);
        codebaseMenu.add(renameCodebaseItem);
        JMenuItem copyCodebaseItem = new JMenuItem(Translator.R("PECopyCodebaseItem"));
        PolicyEditor.setButtonMnemonic(copyCodebaseItem, Translator.R("PECopyCodebaseItemMnemonic"));
        PolicyEditor.setMenuItemAccelerator(copyCodebaseItem, Translator.R("PECopyCodebaseItemAccelerator"));
        copyCodebaseItem.addActionListener(editor.copyCodebaseButtonAction);
        codebaseMenu.add(copyCodebaseItem);
        menuBar.add(codebaseMenu);
        JMenuItem pasteCodebaseItem = new JMenuItem(Translator.R("PEPasteCodebaseItem"));
        PolicyEditor.setButtonMnemonic(pasteCodebaseItem, Translator.R("PEPasteCodebaseItemMnemonic"));
        PolicyEditor.setMenuItemAccelerator(pasteCodebaseItem, Translator.R("PEPasteCodebaseItemAccelerator"));
        pasteCodebaseItem.addActionListener(editor.pasteCodebaseButtonAction);
        codebaseMenu.add(pasteCodebaseItem);
        JMenu viewMenu = new JMenu(Translator.R("PEViewMenu"));
        PolicyEditor.setButtonMnemonic(viewMenu, Translator.R("PEViewMenuMnemonic"));
        JMenuItem customPermissionsItem = new JMenuItem(Translator.R("PECustomPermissionsItem"));
        PolicyEditor.setButtonMnemonic(customPermissionsItem, Translator.R("PECustomPermissionsItemMnemonic"));
        PolicyEditor.setMenuItemAccelerator(customPermissionsItem, Translator.R("PECustomPermissionsItemAccelerator"));
        customPermissionsItem.addActionListener(editor.viewCustomButtonAction);
        viewMenu.add(customPermissionsItem);
        menuBar.add(viewMenu);
        JMenu helpMenu = new JMenu(Translator.R("PEHelpMenu"));
        PolicyEditor.setButtonMnemonic(helpMenu, Translator.R("PEHelpMenuMnemonic"));
        JMenuItem aboutPolicyEditorItem = new JMenuItem(Translator.R("PEAboutPolicyEditorItem"));
        PolicyEditor.setButtonMnemonic(aboutPolicyEditorItem, Translator.R("PEAboutPolicyEditorItemMnemonic"));
        aboutPolicyEditorItem.addActionListener(editor.aboutPolicyEditorButtonAction);
        helpMenu.add(aboutPolicyEditorItem);
        JMenuItem aboutITW = new JMenuItem(Translator.R("CPTabAbout"));
        aboutITW.addActionListener(editor.aboutItwButtonAction);
        helpMenu.add(aboutITW);
        JMenuItem policyEditorHelpItem = new JMenuItem(Translator.R("PEPolicyEditorHelpItem"));
        PolicyEditor.setButtonMnemonic(policyEditorHelpItem, Translator.R("PEPolicyEditorHelpItemMnemonic"));
        policyEditorHelpItem.addActionListener(editor.policyEditorHelpButtonAction);
        helpMenu.addSeparator();
        helpMenu.add(policyEditorHelpItem);
        menuBar.add(helpMenu);
        InputMap listInputMap = editor.list.getInputMap();
        ActionMap listActionMap = editor.list.getActionMap();
        AbstractAction listCopyOverrideAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                editor.copyCodebaseButtonAction.actionPerformed(e);
            }
        };
        AbstractAction listPasteOverrideAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                editor.pasteCodebaseButtonAction.actionPerformed(e);
            }
        };
        listInputMap.put(copyCodebaseItem.getAccelerator(), "CopyCodebaseOverride");
        listActionMap.put("CopyCodebaseOverride", listCopyOverrideAction);
        listInputMap.put(pasteCodebaseItem.getAccelerator(), "PasteCodebaseOverride");
        listActionMap.put("PasteCodebaseOverride", listPasteOverrideAction);
        return menuBar;
    }

    private void setupLayout() {
        JLabel checkboxLabel = new JLabel();
        checkboxLabel.setText(Translator.R("PECheckboxLabel"));
        checkboxLabel.setBorder(new EmptyBorder(2, 2, 2, 2));
        GridBagConstraints checkboxLabelConstraints = new GridBagConstraints();
        checkboxLabelConstraints.gridx = 2;
        checkboxLabelConstraints.gridy = 0;
        checkboxLabelConstraints.fill = 2;
        this.add((Component)checkboxLabel, checkboxLabelConstraints);
        GridBagConstraints checkboxConstraints = new GridBagConstraints();
        checkboxConstraints.anchor = 21;
        checkboxConstraints.fill = 2;
        checkboxConstraints.weightx = 0.0;
        checkboxConstraints.weighty = 0.0;
        checkboxConstraints.gridx = 2;
        checkboxConstraints.gridy = 1;
        for (JCheckBox box : this.checkboxMap.values()) {
            if (PolicyEditorPermissions.Group.anyContains(box, this.checkboxMap)) continue;
            this.add((Component)box, checkboxConstraints);
            ++checkboxConstraints.gridx;
            if (checkboxConstraints.gridx <= 3) continue;
            checkboxConstraints.gridx = 2;
            ++checkboxConstraints.gridy;
        }
        for (PolicyEditorPermissions.Group g : PolicyEditorPermissions.Group.values()) {
            ++checkboxConstraints.gridy;
            checkboxConstraints.gridx = 2;
            final JCheckBoxWithGroup groupCh = new JCheckBoxWithGroup(g);
            this.groupBoxList.add(groupCh);
            final JPanel groupPanel = new JPanel(new GridBagLayout());
            groupPanel.setBorder(new LineBorder(Color.black));
            groupCh.setToolTipText(Translator.R("PEGrightClick"));
            groupCh.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getButton() == 3) {
                        PolicyEditor.this.toggleExpandedCheckboxGroupPanel(groupPanel);
                    }
                }
            });
            groupCh.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 10 || e.getKeyCode() == 525) {
                        PolicyEditor.this.toggleExpandedCheckboxGroupPanel(groupPanel);
                    }
                }
            });
            groupCh.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String codebase = PolicyEditor.this.getSelectedCodebase();
                    if (codebase == null) {
                        return;
                    }
                    LinkedList<ActionListener> backup = new LinkedList<ActionListener>();
                    for (ActionListener actionListener : groupCh.getActionListeners()) {
                        backup.add(actionListener);
                        groupCh.removeActionListener(actionListener);
                    }
                    for (ActionListener actionListener : groupCh.getGroup().getPermissions()) {
                        PolicyEditor.this.policyEditorController.setPermission(codebase, (PolicyEditorPermissions)((Object)actionListener), groupCh.isSelected());
                    }
                    PolicyEditor.this.setChangesMade(true);
                    PolicyEditor.this.updateCheckboxes(codebase);
                    for (ActionListener al : backup) {
                        groupCh.addActionListener(al);
                    }
                }
            });
            this.add((Component)groupCh, checkboxConstraints);
            ++checkboxConstraints.gridy;
            checkboxConstraints.gridx = 2;
            checkboxConstraints.gridwidth = 2;
            checkboxConstraints.fill = 1;
            this.add((Component)groupPanel, checkboxConstraints);
            GridBagConstraints groupCheckboxLabelConstraints = new GridBagConstraints();
            groupCheckboxLabelConstraints.anchor = 21;
            groupCheckboxLabelConstraints.weightx = 0.0;
            groupCheckboxLabelConstraints.weighty = 0.0;
            groupCheckboxLabelConstraints.gridx = 1;
            groupCheckboxLabelConstraints.gridy = 1;
            for (PolicyEditorPermissions p : g.getPermissions()) {
                groupPanel.add((Component)this.checkboxMap.get((Object)p), groupCheckboxLabelConstraints);
                ++groupCheckboxLabelConstraints.gridx;
                if (groupCheckboxLabelConstraints.gridx <= 2) continue;
                groupCheckboxLabelConstraints.gridx = 1;
                ++groupCheckboxLabelConstraints.gridy;
            }
            groupPanel.setVisible(false);
            checkboxConstraints.gridwidth = 1;
        }
        JLabel codebaseListLabel = new JLabel(Translator.R("PECodebaseLabel"));
        codebaseListLabel.setBorder(new EmptyBorder(2, 2, 2, 2));
        GridBagConstraints listLabelConstraints = new GridBagConstraints();
        listLabelConstraints.fill = 2;
        listLabelConstraints.gridx = 0;
        listLabelConstraints.gridy = 0;
        this.add((Component)codebaseListLabel, listLabelConstraints);
        this.list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                String codebase = PolicyEditor.this.getSelectedCodebase();
                if (codebase == null) {
                    return;
                }
                PolicyEditor.this.updateCheckboxes(codebase);
            }
        });
        this.list.setSelectionMode(0);
        this.scrollPane.setHorizontalScrollBarPolicy(30);
        this.scrollPane.setVerticalScrollBarPolicy(22);
        this.scrollPane.setViewportView(this.list);
        GridBagConstraints listConstraints = new GridBagConstraints();
        listConstraints.fill = 1;
        listConstraints.weightx = 1.0;
        listConstraints.weighty = 1.0;
        listConstraints.gridheight = checkboxConstraints.gridy + 1;
        listConstraints.gridwidth = 2;
        listConstraints.gridx = 0;
        listConstraints.gridy = 1;
        this.add((Component)this.scrollPane, listConstraints);
        GridBagConstraints addCodebaseButtonConstraints = new GridBagConstraints();
        addCodebaseButtonConstraints.fill = 2;
        addCodebaseButtonConstraints.gridx = 0;
        addCodebaseButtonConstraints.gridy = listConstraints.gridy + listConstraints.gridheight + 1;
        PolicyEditor.setButtonMnemonic(this.addCodebaseButton, Translator.R("PEAddCodebaseMnemonic"));
        this.add((Component)this.addCodebaseButton, addCodebaseButtonConstraints);
        GridBagConstraints removeCodebaseButtonConstraints = new GridBagConstraints();
        removeCodebaseButtonConstraints.fill = 2;
        removeCodebaseButtonConstraints.gridx = addCodebaseButtonConstraints.gridx + 1;
        removeCodebaseButtonConstraints.gridy = addCodebaseButtonConstraints.gridy;
        PolicyEditor.setButtonMnemonic(this.removeCodebaseButton, Translator.R("PERemoveCodebaseMnemonic"));
        this.removeCodebaseButton.setPreferredSize(this.addCodebaseButton.getPreferredSize());
        this.add((Component)this.removeCodebaseButton, removeCodebaseButtonConstraints);
        GridBagConstraints okButtonConstraints = new GridBagConstraints();
        okButtonConstraints.fill = 2;
        okButtonConstraints.gridx = removeCodebaseButtonConstraints.gridx + 2;
        okButtonConstraints.gridy = removeCodebaseButtonConstraints.gridy;
        this.add((Component)this.okButton, okButtonConstraints);
        GridBagConstraints cancelButtonConstraints = new GridBagConstraints();
        cancelButtonConstraints.fill = 2;
        cancelButtonConstraints.gridx = okButtonConstraints.gridx + 1;
        cancelButtonConstraints.gridy = okButtonConstraints.gridy;
        this.add((Component)this.closeButton, cancelButtonConstraints);
        this.setMinimumSize(this.getPreferredSize());
    }

    void setChangesMade(boolean b) {
        this.policyEditorController.setChangesMade(b);
        this.invokeRunnableOrEnqueueLater(new Runnable(){

            @Override
            public void run() {
                PolicyEditor.this.setParentWindowTitle(PolicyEditor.this.getWindowTitleForStatus());
            }
        });
    }

    private void resetCodebases() {
        this.listModel.clear();
        this.policyEditorController.clearPermissions();
        this.policyEditorController.clearCustomPermissions();
    }

    public boolean isPerformingIO() {
        return this.policyEditorController.performingIO();
    }

    private void openAndParsePolicyFile() {
        this.resetCodebases();
        try {
            this.policyEditorController.getFile().createNewFile();
        }
        catch (IOException e) {
            OutputController.getLogger().log(e);
        }
        FileUtils.OpenFileResult ofr = FileUtils.testFilePermissions(this.policyEditorController.getFile());
        if (ofr == FileUtils.OpenFileResult.FAILURE || ofr == FileUtils.OpenFileResult.NOT_FILE) {
            FileUtils.showCouldNotOpenFilepathDialog(this, this.policyEditorController.getFile().getPath());
            return;
        }
        if (ofr == FileUtils.OpenFileResult.CANT_WRITE) {
            FileUtils.showReadOnlyDialog(this);
        }
        final Window parentWindow = SwingUtilities.getWindowAncestor(this);
        final IndeterminateProgressDialog progressIndicator = new IndeterminateProgressDialog(parentWindow, "Loading...");
        SwingWorker<Void, Void> openPolicyFileWorker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                try {
                    if (parentWindow != null) {
                        PolicyEditor.this.invokeRunnableOrEnqueueLater(new Runnable(){

                            @Override
                            public void run() {
                                progressIndicator.setLocationRelativeTo(parentWindow);
                                progressIndicator.setVisible(true);
                            }
                        });
                    }
                    PolicyEditor.this.policyEditorController.openAndParsePolicyFile();
                }
                catch (FileNotFoundException fnfe) {
                    OutputController.getLogger().log(fnfe);
                    FileUtils.showCouldNotOpenDialog(PolicyEditor.this, Translator.R("PECouldNotOpen"));
                }
                catch (IOException | InvalidPolicyException e) {
                    OutputController.getLogger().log(e);
                    OutputController.getLogger().log(OutputController.Level.ERROR_ALL, Translator.R("RCantOpenFile", PolicyEditor.this.policyEditorController.getFile().getPath()));
                    FileUtils.showCouldNotOpenDialog(PolicyEditor.this, Translator.R("PECouldNotOpen"));
                }
                return null;
            }

            @Override
            public void done() {
                for (String codebase : PolicyEditor.this.policyEditorController.getCodebases()) {
                    String model = codebase.isEmpty() ? Translator.R("PEGlobalSettings") : codebase;
                    if (PolicyEditor.this.listModel.contains(model)) continue;
                    PolicyEditor.this.listModel.addElement(model);
                }
                PolicyEditor.this.addNewCodebase("");
                progressIndicator.setVisible(false);
                progressIndicator.dispose();
                PolicyEditor.this.setChangesMade(false);
            }
        };
        openPolicyFileWorker.execute();
    }

    private void savePolicyFile() {
        int overwriteChanges = this.checkPolicyChangesWithDialog();
        switch (overwriteChanges) {
            case 0: {
                this.openAndParsePolicyFile();
                return;
            }
            case 1: {
                break;
            }
            case 2: {
                return;
            }
        }
        final Window parentWindow = SwingUtilities.getWindowAncestor(this);
        final IndeterminateProgressDialog progressIndicator = new IndeterminateProgressDialog(parentWindow, "Saving...");
        SwingWorker<Void, Void> savePolicyFileWorker = new SwingWorker<Void, Void>(){

            @Override
            public Void doInBackground() throws Exception {
                try {
                    if (parentWindow != null) {
                        PolicyEditor.this.invokeRunnableOrEnqueueLater(new Runnable(){

                            @Override
                            public void run() {
                                progressIndicator.setLocationRelativeTo(parentWindow);
                                progressIndicator.setVisible(true);
                            }
                        });
                    }
                    PolicyEditor.this.policyEditorController.savePolicyFile();
                }
                catch (IOException e) {
                    OutputController.getLogger().log(e);
                    PolicyEditor.this.showCouldNotSaveDialog();
                }
                return null;
            }

            @Override
            public void done() {
                PolicyEditor.this.showChangesSavedDialog();
                progressIndicator.setVisible(false);
                progressIndicator.dispose();
                PolicyEditor.this.setChangesMade(false);
            }
        };
        savePolicyFileWorker.execute();
    }

    private void showChangesSavedDialog() {
        this.invokeRunnableOrEnqueueLater(new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog((Component)PolicyEditor.this.parentPolicyEditor.get(), Translator.R("PEChangesSaved"));
            }
        });
    }

    private void showCouldNotSaveDialog() {
        this.invokeRunnableOrEnqueueLater(new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog((Component)PolicyEditor.this.parentPolicyEditor.get(), Translator.R("PECouldNotSave"), Translator.R("Error"), 0);
            }
        });
    }

    private void showClipboardErrorDialog() {
        this.invokeRunnableOrEnqueueLater(new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog((Component)PolicyEditor.this.parentPolicyEditor.get(), Translator.R("PEClipboardError"), Translator.R("Error"), 0);
            }
        });
    }

    private void showInvalidPolicyExceptionDialog(final String codebase) {
        this.invokeRunnableOrEnqueueLater(new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog((Component)PolicyEditor.this.parentPolicyEditor.get(), Translator.R("PEInvalidPolicy", codebase), Translator.R("Error"), 0);
            }
        });
    }

    private void showCouldNotAccessClipboardDialog() {
        this.invokeRunnableOrEnqueueLater(new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog((Component)PolicyEditor.this.parentPolicyEditor.get(), Translator.R("PEClipboardAccessError"), Translator.R("Error"), 0);
            }
        });
    }

    private int checkPolicyChangesWithDialog() {
        boolean changed;
        try {
            changed = this.policyEditorController.fileHasChanged();
        }
        catch (FileNotFoundException e) {
            OutputController.getLogger().log(e);
            JOptionPane.showMessageDialog(this, Translator.R("PEFileMissing"), Translator.R("PEFileModified"), 2);
            return 1;
        }
        catch (IOException e) {
            OutputController.getLogger().log(e);
            changed = true;
        }
        if (changed) {
            String policyFilePath;
            try {
                policyFilePath = this.policyEditorController.getFile().getCanonicalPath();
            }
            catch (IOException e) {
                OutputController.getLogger().log(e);
                policyFilePath = this.policyEditorController.getFile().getPath();
            }
            return JOptionPane.showConfirmDialog(this, Translator.R("PEFileModifiedDetail", policyFilePath, Translator.R("PEFileModified"), 1));
        }
        if (!this.policyEditorController.changesMade()) {
            return 2;
        }
        return 1;
    }

    private void toggleExpandedCheckboxGroupPanel(JPanel groupPanel) {
        groupPanel.setVisible(!groupPanel.isVisible());
        this.validate();
        Window w = SwingUtilities.getWindowAncestor(this);
        if (w != null) {
            w.pack();
        }
    }

    public static void main(String[] args) {
        final OptionParser optionParser = new OptionParser(args, OptionsDefinitions.getPolicyEditorOptions());
        if (optionParser.hasOption(OptionsDefinitions.OPTIONS.VERBOSE)) {
            JNLPRuntime.setDebug(true);
        }
        if (optionParser.hasOption(OptionsDefinitions.OPTIONS.HELP1)) {
            PolicyEditorTextsProvider helpMessagesProvider = new PolicyEditorTextsProvider("utf-8", new PlainTextFormatter(), true, true);
            String HELP_MESSAGE = "\n";
            HELP_MESSAGE = JNLPRuntime.isDebug() ? HELP_MESSAGE + helpMessagesProvider.writeToString() : HELP_MESSAGE + helpMessagesProvider.prepare().getSynopsis() + helpMessagesProvider.getFormatter().getNewLine() + helpMessagesProvider.prepare().getOptions() + helpMessagesProvider.getFormatter().getNewLine();
            OutputController.getLogger().printOut(HELP_MESSAGE);
            return;
        }
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String filepath = PolicyEditor.getFilePathArgument(optionParser);
                PolicyEditorWindow frame = PolicyEditor.getPolicyEditorFrame(filepath);
                frame.asWindow().setVisible(true);
                List<String> codebases = optionParser.getParams(OptionsDefinitions.OPTIONS.CODEBASE);
                for (String url : codebases) {
                    frame.getPolicyEditor().addNewCodebase(url);
                }
            }
        });
    }

    private static String getFilePathArgument(OptionParser optionParser) {
        boolean openDefaultFile = optionParser.hasOption(OptionsDefinitions.OPTIONS.DEFAULTFILE);
        boolean hasFileArgument = optionParser.hasOption(OptionsDefinitions.OPTIONS.FILE);
        boolean hasMainArgument = optionParser.mainArgExists();
        if (hasFileArgument && openDefaultFile || hasMainArgument && openDefaultFile) {
            throw new IllegalArgumentException(Translator.R("PEDefaultFileFilePathSpecifiedError"));
        }
        if (hasFileArgument && hasMainArgument) {
            throw new IllegalArgumentException(Translator.R("PEMainArgAndFileSwitchSpecifiedError"));
        }
        String filepath = null;
        if (hasFileArgument) {
            filepath = PolicyEditor.cleanFilePathArgument(optionParser.getParam(OptionsDefinitions.OPTIONS.FILE));
        } else if (hasMainArgument) {
            filepath = PolicyEditor.cleanFilePathArgument(optionParser.getMainArg());
        } else if (openDefaultFile) {
            try {
                filepath = PolicyEditor.getDefaultPolicyFilePath();
            }
            catch (URISyntaxException e) {
                OutputController.getLogger().log(e);
                throw new RuntimeException(e);
            }
        }
        return filepath;
    }

    private static String cleanFilePathArgument(String filepath) {
        if (filepath == null) {
            return null;
        }
        if (filepath.isEmpty() || filepath.trim().isEmpty()) {
            return null;
        }
        return filepath;
    }

    public static PolicyEditor createInstance(String filepath) {
        return new PolicyEditor(filepath);
    }

    private static class PolicyEditorDialog
    extends JDialog
    implements PolicyEditorWindow {
        private PolicyEditor editor;

        private PolicyEditorDialog(PolicyEditor editor) {
            PolicyEditor.preparePolicyEditorWindow(this, editor);
        }

        @Override
        public final void setTitle(String title) {
            super.setTitle(title);
        }

        @Override
        public final PolicyEditor getPolicyEditor() {
            return this.editor;
        }

        @Override
        public final void setPolicyEditor(PolicyEditor e) {
            this.editor = e;
        }

        @Override
        public final void setDefaultCloseOperation(int operation) {
            super.setDefaultCloseOperation(operation);
        }

        @Override
        public final void setJMenuBar(JMenuBar menu) {
            super.setJMenuBar(menu);
        }

        @Override
        public final Window asWindow() {
            return this;
        }

        @Override
        public void setModalityType(Dialog.ModalityType type) {
            super.setModalityType(type);
        }

        @Override
        public void quit() {
            PolicyEditor.policyEditorWindowQuit(this);
        }
    }

    private static class PolicyEditorFrame
    extends JFrame
    implements PolicyEditorWindow {
        private PolicyEditor editor;

        private PolicyEditorFrame(PolicyEditor editor) {
            PolicyEditor.preparePolicyEditorWindow(this, editor);
        }

        @Override
        public final void setTitle(String title) {
            super.setTitle(title);
        }

        @Override
        public final PolicyEditor getPolicyEditor() {
            return this.editor;
        }

        @Override
        public final void setPolicyEditor(PolicyEditor e) {
            this.editor = e;
        }

        @Override
        public final void setDefaultCloseOperation(int operation) {
            super.setDefaultCloseOperation(operation);
        }

        @Override
        public final void setJMenuBar(JMenuBar menu) {
            super.setJMenuBar(menu);
        }

        @Override
        public final Window asWindow() {
            return this;
        }

        @Override
        public void setModalityType(Dialog.ModalityType type) {
        }

        @Override
        public void quit() {
            PolicyEditor.policyEditorWindowQuit(this);
        }
    }

    public static interface PolicyEditorWindow {
        public void setTitle(String var1);

        public void setDefaultCloseOperation(int var1);

        public PolicyEditor getPolicyEditor();

        public void setPolicyEditor(PolicyEditor var1);

        public void setJMenuBar(JMenuBar var1);

        public Window asWindow();

        public void setModalityType(Dialog.ModalityType var1);

        public void quit();
    }

    private static class JCheckBoxWithGroup
    extends JCheckBox {
        private final PolicyEditorPermissions.Group group;

        private JCheckBoxWithGroup(PolicyEditorPermissions.Group group) {
            super(group.getTitle());
            this.group = group;
        }

        public PolicyEditorPermissions.Group getGroup() {
            return this.group;
        }

        private void setState(Map<PolicyEditorPermissions, Boolean> map) {
            LinkedList<ActionListener> backup = new LinkedList<ActionListener>();
            for (ActionListener l : this.getActionListeners()) {
                backup.add(l);
                this.removeActionListener(l);
            }
            int i = this.group.getState(map);
            this.setBackground(this.getParent().getBackground());
            if (i > 0) {
                this.setSelected(true);
            }
            if (i < 0) {
                this.setSelected(false);
            }
            if (i == 0) {
                this.setBackground(Color.yellow);
                this.setSelected(false);
            }
            for (ActionListener al : backup) {
                this.addActionListener(al);
            }
        }
    }
}

