/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.rules;

import com.google.common.collect.Lists;
import groovy.lang.Closure;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.gradle.internal.rules.RuleAction;
import org.gradle.internal.rules.RuleActionValidationException;

public class ClosureBackedRuleAction<T>
implements RuleAction<T> {
    private final Closure<?> closure;
    private final Class<? super T> subjectType;
    private final List<Class<?>> inputTypes;

    public ClosureBackedRuleAction(Class<T> subjectType, Closure<?> closure) {
        this.subjectType = subjectType;
        this.closure = closure;
        this.inputTypes = this.parseInputTypes(closure);
    }

    @Override
    public List<Class<?>> getInputTypes() {
        return this.inputTypes;
    }

    @Override
    public void execute(T subject, List<?> inputs) {
        Closure copy = (Closure)this.closure.clone();
        copy.setResolveStrategy(1);
        copy.setDelegate(subject);
        if (this.closure.getMaximumNumberOfParameters() == 0) {
            copy.call();
        } else {
            Object[] argList = new Object[inputs.size() + 1];
            argList[0] = subject;
            int i = 1;
            for (Object arg : inputs) {
                argList[i++] = arg;
            }
            copy.call(argList);
        }
    }

    private List<Class<?>> parseInputTypes(Closure<?> closure) {
        Class[] parameterTypes = closure.getParameterTypes();
        ArrayList inputTypes = Lists.newArrayList();
        if (parameterTypes.length != 0) {
            if (parameterTypes[0].isAssignableFrom(this.subjectType)) {
                inputTypes.addAll(Arrays.asList(parameterTypes).subList(1, parameterTypes.length));
            } else {
                throw new RuleActionValidationException(String.format("First parameter of rule action closure must be of type '%s'.", this.subjectType.getSimpleName()));
            }
        }
        return inputTypes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClosureBackedRuleAction that = (ClosureBackedRuleAction)o;
        return this.closure.equals(that.closure) && this.subjectType.equals(that.subjectType);
    }

    public int hashCode() {
        int result = this.closure.hashCode();
        result = 31 * result + this.subjectType.hashCode();
        return result;
    }
}

