/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.bc;

import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import org.bouncycastle.util.encoders.Hex;

class RFC6637KDFCalculator {
    private static final byte[] ANONYMOUS_SENDER = Hex.decode((String)"416E6F6E796D6F75732053656E64657220202020");
    private final PGPDigestCalculator digCalc;
    private final int keyAlgorithm;

    public RFC6637KDFCalculator(PGPDigestCalculator pGPDigestCalculator, int n) {
        this.digCalc = pGPDigestCalculator;
        this.keyAlgorithm = n;
    }

    public byte[] createKey(ECPoint eCPoint, byte[] byArray) throws PGPException {
        return this.createKey(eCPoint.getAffineXCoord().getEncoded(), byArray);
    }

    public byte[] createKey(byte[] byArray, byte[] byArray2) throws PGPException {
        try {
            return RFC6637KDFCalculator.KDF(this.digCalc, byArray, RFC6637KDFCalculator.getKeyLen(this.keyAlgorithm), byArray2);
        }
        catch (IOException iOException) {
            throw new PGPException("Exception performing KDF: " + iOException.getMessage(), iOException);
        }
    }

    private static byte[] KDF(PGPDigestCalculator pGPDigestCalculator, byte[] byArray, int n, byte[] byArray2) throws IOException {
        OutputStream outputStream = pGPDigestCalculator.getOutputStream();
        outputStream.write(0);
        outputStream.write(0);
        outputStream.write(0);
        outputStream.write(1);
        outputStream.write(byArray);
        outputStream.write(byArray2);
        byte[] byArray3 = pGPDigestCalculator.getDigest();
        byte[] byArray4 = new byte[n];
        System.arraycopy(byArray3, 0, byArray4, 0, byArray4.length);
        return byArray4;
    }

    private static int getKeyLen(int n) throws PGPException {
        switch (n) {
            case 7: {
                return 16;
            }
            case 8: {
                return 24;
            }
            case 9: {
                return 32;
            }
        }
        throw new PGPException("unknown symmetric algorithm ID: " + n);
    }
}

