/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.cache;

import java.util.function.Supplier;
import org.gradle.api.provider.Provider;
import org.gradle.cache.CacheCleanupStrategy;
import org.gradle.cache.CleanupAction;
import org.gradle.cache.CleanupFrequency;

public class DefaultCacheCleanupStrategy
implements CacheCleanupStrategy {
    private final CleanupAction cleanupAction;
    private final Supplier<CleanupFrequency> cleanupFrequency;

    private DefaultCacheCleanupStrategy(CleanupAction cleanupAction, Supplier<CleanupFrequency> cleanupFrequency) {
        this.cleanupAction = cleanupAction;
        this.cleanupFrequency = cleanupFrequency;
    }

    public static DefaultCacheCleanupStrategy from(CleanupAction cleanupAction, Provider<CleanupFrequency> cleanupFrequency) {
        return new DefaultCacheCleanupStrategy(cleanupAction, cleanupFrequency::get);
    }

    public static DefaultCacheCleanupStrategy from(CleanupAction cleanupAction) {
        return new DefaultCacheCleanupStrategy(cleanupAction, () -> CleanupFrequency.DAILY);
    }

    public CleanupAction getCleanupAction() {
        return this.cleanupAction;
    }

    public CleanupFrequency getCleanupFrequency() {
        return this.cleanupFrequency.get();
    }
}

