/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.ir2wasm;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.wasm.WasmBackendContext;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.ClassInfoKt;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.ClassMetadata;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.ConstantDataElement;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.InterfaceMetadata;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.WasmCompiledModuleFragment;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.WasmTypeTransformer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFieldSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.wasm.ir.WasmExport;
import org.jetbrains.kotlin.wasm.ir.WasmFunction;
import org.jetbrains.kotlin.wasm.ir.WasmFunctionType;
import org.jetbrains.kotlin.wasm.ir.WasmGlobal;
import org.jetbrains.kotlin.wasm.ir.WasmSymbol;
import org.jetbrains.kotlin.wasm.ir.WasmType;
import org.jetbrains.kotlin.wasm.ir.WasmTypeDeclaration;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00c2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u0018\u001a\u00020\u00192\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u001bJ\u0016\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001eJ\u000e\u0010 \u001a\u00020\u00192\u0006\u0010!\u001a\u00020\u001eJ\u0016\u0010\"\u001a\u00020\u00192\u0006\u0010#\u001a\u00020\u000b2\u0006\u0010$\u001a\u00020%J\u0016\u0010&\u001a\u00020\u00192\u0006\u0010#\u001a\u00020\u000b2\u0006\u0010'\u001a\u00020\u0011J\u0016\u0010(\u001a\u00020\u00192\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,J\u0016\u0010-\u001a\u00020\u00192\u0006\u0010)\u001a\u00020*2\u0006\u0010.\u001a\u00020/J\u0016\u00100\u001a\u00020\u00192\u0006\u0010#\u001a\u00020\u000b2\u0006\u0010$\u001a\u00020%J\u0016\u00101\u001a\u00020\u00192\u0006\u0010#\u001a\u00020\u000b2\u0006\u00102\u001a\u000203J\u0016\u00104\u001a\u00020\u00192\u0006\u00105\u001a\u0002062\u0006\u00102\u001a\u000203J\u0016\u00107\u001a\u00020\u00192\u0006\u0010#\u001a\u00020\u000b2\u0006\u00102\u001a\u000203J\u0016\u00108\u001a\u00020\u00192\u0006\u0010#\u001a\u00020\u000b2\u0006\u0010$\u001a\u00020%J\u0016\u00109\u001a\u00020\u00192\u0006\u0010#\u001a\u00020\u000b2\u0006\u0010:\u001a\u00020;J\u000e\u0010<\u001a\u00020\f2\u0006\u0010#\u001a\u00020\u000bJ\u000e\u0010=\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020\u000bJ\u0014\u0010>\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010?\u001a\u00020@J\u000e\u0010A\u001a\u00020B2\u0006\u0010#\u001a\u00020\u000bJ\u0014\u0010C\u001a\b\u0012\u0004\u0012\u00020%0\u00102\u0006\u0010#\u001a\u00020\u000bJ\u0014\u0010D\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010#\u001a\u00020\u000bJ&\u0010E\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0018\u0010F\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020I0H\u0012\u0004\u0012\u00020J0GJ\u0014\u0010K\u001a\b\u0012\u0004\u0012\u00020,0\u00102\u0006\u0010)\u001a\u00020*J\u0014\u0010L\u001a\b\u0012\u0004\u0012\u00020/0\u00102\u0006\u0010)\u001a\u00020*J\u0014\u0010M\u001a\b\u0012\u0004\u0012\u00020%0\u00102\u0006\u0010#\u001a\u00020\u000bJ\u0014\u0010N\u001a\b\u0012\u0004\u0012\u0002030\u00102\u0006\u0010#\u001a\u00020\u000bJ\u0014\u0010O\u001a\b\u0012\u0004\u0012\u0002030\u00102\u0006\u00105\u001a\u000206J\u0014\u0010P\u001a\b\u0012\u0004\u0012\u0002030\u00102\u0006\u0010#\u001a\u00020\u000bJ*\u0010Q\u001a\b\u0012\u0004\u0012\u00020%0\u00102\u0006\u0010#\u001a\u00020\u000b2\u0012\u0010R\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020%0SH\u0002J&\u0010T\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100G2\u0006\u0010U\u001a\u00020\u001eJ\u0014\u0010V\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010#\u001a\u00020\u000bJ\u0014\u0010W\u001a\b\u0012\u0004\u0012\u00020%0\u00102\u0006\u0010#\u001a\u00020\u000bJ\u0016\u0010X\u001a\u00020\u00192\u0006\u0010+\u001a\u00020,2\u0006\u0010Y\u001a\u00020\u001eJ\u0010\u0010Z\u001a\u0004\u0018\u00010J2\u0006\u0010[\u001a\u00020\\J\u000e\u0010]\u001a\u00020J2\u0006\u0010[\u001a\u00020\\J\u000e\u0010^\u001a\u00020J2\u0006\u0010[\u001a\u00020\\J\u0010\u0010_\u001a\u0004\u0018\u00010J2\u0006\u0010[\u001a\u00020\\J\u000e\u0010`\u001a\u00020J2\u0006\u0010[\u001a\u00020\\J\u000e\u0010a\u001a\u00020J2\u0006\u0010b\u001a\u00020cR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000e0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00110\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0013R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006d"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmModuleCodegenContext;", "", "backendContext", "Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "wasmFragment", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmCompiledModuleFragment;", "(Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmCompiledModuleFragment;)V", "getBackendContext", "()Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "classMetadataCache", "", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/ClassMetadata;", "interfaceMetadataCache", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/InterfaceMetadata;", "scratchMemAddr", "Lorg/jetbrains/kotlin/wasm/ir/WasmSymbol;", "", "getScratchMemAddr", "()Lorg/jetbrains/kotlin/wasm/ir/WasmSymbol;", "stringPoolSize", "getStringPoolSize", "typeTransformer", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmTypeTransformer;", "addExport", "", "wasmExport", "Lorg/jetbrains/kotlin/wasm/ir/WasmExport;", "addJsFun", "importName", "", "jsCode", "addJsModuleImport", "module", "defineClassITableGcType", "irClass", "wasmType", "Lorg/jetbrains/kotlin/wasm/ir/WasmTypeDeclaration;", "defineClassITableInterfaceSlot", "slot", "defineFunction", "irFunction", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "wasmFunction", "Lorg/jetbrains/kotlin/wasm/ir/WasmFunction;", "defineFunctionType", "wasmFunctionType", "Lorg/jetbrains/kotlin/wasm/ir/WasmFunctionType;", "defineGcType", "defineGlobalClassITable", "wasmGlobal", "Lorg/jetbrains/kotlin/wasm/ir/WasmGlobal;", "defineGlobalField", "irField", "Lorg/jetbrains/kotlin/ir/symbols/IrFieldSymbol;", "defineGlobalVTable", "defineVTableGcType", "generateTypeInfo", "typeInfo", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/ConstantDataElement;", "getClassMetadata", "getInterfaceMetadata", "getStructFieldRef", "field", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "isAlreadyDefinedClassITableGcType", "", "referenceClassITableGcType", "referenceClassITableInterfaceSlot", "referenceConstantArray", "resource", "Lkotlin/Pair;", "", "", "Lorg/jetbrains/kotlin/wasm/ir/WasmType;", "referenceFunction", "referenceFunctionType", "referenceGcType", "referenceGlobalClassITable", "referenceGlobalField", "referenceGlobalVTable", "referenceNonNothingType", "from", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmCompiledModuleFragment$ReferencableAndDefinable;", "referenceStringLiteralAddressAndId", "string", "referenceTypeId", "referenceVTableGcType", "registerInitFunction", "priority", "transformBlockResultType", "irType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "transformBoxedType", "transformFieldType", "transformResultType", "transformType", "transformValueParameterType", "irValueParameter", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "backend.wasm"})
@SourceDebugExtension(value={"SMAP\nWasmModuleCodegenContext.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WasmModuleCodegenContext.kt\norg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmModuleCodegenContext\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,200:1\n1#2:201\n372#3,7:202\n372#3,7:209\n*S KotlinDebug\n*F\n+ 1 WasmModuleCodegenContext.kt\norg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmModuleCodegenContext\n*L\n112#1:202,7\n124#1:209,7\n*E\n"})
public final class WasmModuleCodegenContext {
    @NotNull
    private final WasmBackendContext backendContext;
    @NotNull
    private final WasmCompiledModuleFragment wasmFragment;
    @NotNull
    private final WasmTypeTransformer typeTransformer;
    @NotNull
    private final Map<IrClassSymbol, ClassMetadata> classMetadataCache;
    @NotNull
    private final Map<IrClassSymbol, InterfaceMetadata> interfaceMetadataCache;

    public WasmModuleCodegenContext(@NotNull WasmBackendContext backendContext, @NotNull WasmCompiledModuleFragment wasmFragment) {
        Intrinsics.checkNotNullParameter((Object)backendContext, (String)"backendContext");
        Intrinsics.checkNotNullParameter((Object)wasmFragment, (String)"wasmFragment");
        this.backendContext = backendContext;
        this.wasmFragment = wasmFragment;
        this.typeTransformer = new WasmTypeTransformer(this, this.backendContext.getIrBuiltIns());
        this.classMetadataCache = new LinkedHashMap();
        this.interfaceMetadataCache = new LinkedHashMap();
    }

    @NotNull
    public final WasmBackendContext getBackendContext() {
        return this.backendContext;
    }

    @NotNull
    public final WasmSymbol<Integer> getScratchMemAddr() {
        return this.wasmFragment.getScratchMemAddr();
    }

    @NotNull
    public final WasmSymbol<Integer> getStringPoolSize() {
        return this.wasmFragment.getStringPoolSize();
    }

    @NotNull
    public final WasmType transformType(@NotNull IrType irType) {
        Intrinsics.checkNotNullParameter((Object)irType, (String)"irType");
        WasmTypeTransformer $this$transformType_u24lambda_u240 = this.typeTransformer;
        boolean bl = false;
        return $this$transformType_u24lambda_u240.toWasmValueType(irType);
    }

    @NotNull
    public final WasmType transformFieldType(@NotNull IrType irType) {
        Intrinsics.checkNotNullParameter((Object)irType, (String)"irType");
        WasmTypeTransformer $this$transformFieldType_u24lambda_u241 = this.typeTransformer;
        boolean bl = false;
        return $this$transformFieldType_u24lambda_u241.toWasmFieldType(irType);
    }

    @NotNull
    public final WasmType transformBoxedType(@NotNull IrType irType) {
        Intrinsics.checkNotNullParameter((Object)irType, (String)"irType");
        WasmTypeTransformer $this$transformBoxedType_u24lambda_u242 = this.typeTransformer;
        boolean bl = false;
        return $this$transformBoxedType_u24lambda_u242.toBoxedInlineClassType(irType);
    }

    @NotNull
    public final WasmType transformValueParameterType(@NotNull IrValueParameter irValueParameter) {
        Intrinsics.checkNotNullParameter((Object)irValueParameter, (String)"irValueParameter");
        WasmTypeTransformer $this$transformValueParameterType_u24lambda_u243 = this.typeTransformer;
        boolean bl = false;
        return $this$transformValueParameterType_u24lambda_u243.getContext().backendContext.getInlineClassesUtils().shouldValueParameterBeBoxed(irValueParameter) ? $this$transformValueParameterType_u24lambda_u243.toBoxedInlineClassType(irValueParameter.getType()) : $this$transformValueParameterType_u24lambda_u243.toWasmValueType(irValueParameter.getType());
    }

    @Nullable
    public final WasmType transformResultType(@NotNull IrType irType) {
        Intrinsics.checkNotNullParameter((Object)irType, (String)"irType");
        WasmTypeTransformer $this$transformResultType_u24lambda_u244 = this.typeTransformer;
        boolean bl = false;
        return $this$transformResultType_u24lambda_u244.toWasmResultType(irType);
    }

    @Nullable
    public final WasmType transformBlockResultType(@NotNull IrType irType) {
        Intrinsics.checkNotNullParameter((Object)irType, (String)"irType");
        WasmTypeTransformer $this$transformBlockResultType_u24lambda_u245 = this.typeTransformer;
        boolean bl = false;
        return $this$transformBlockResultType_u24lambda_u245.toWasmBlockResultType(irType);
    }

    @NotNull
    public final Pair<WasmSymbol<Integer>, WasmSymbol<Integer>> referenceStringLiteralAddressAndId(@NotNull String string2) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"string");
        WasmSymbol<Integer> address = this.wasmFragment.getStringLiteralAddress().reference(string2);
        WasmSymbol<Integer> id = this.wasmFragment.getStringLiteralPoolId().reference(string2);
        return TuplesKt.to(address, id);
    }

    @NotNull
    public final WasmSymbol<Integer> referenceConstantArray(@NotNull Pair<? extends List<Long>, ? extends WasmType> resource) {
        Intrinsics.checkNotNullParameter(resource, (String)"resource");
        return this.wasmFragment.getConstantArrayDataSegmentId().reference(resource);
    }

    public final void generateTypeInfo(@NotNull IrClassSymbol irClass2, @NotNull ConstantDataElement typeInfo) {
        Intrinsics.checkNotNullParameter((Object)irClass2, (String)"irClass");
        Intrinsics.checkNotNullParameter((Object)typeInfo, (String)"typeInfo");
        this.wasmFragment.getTypeInfo().define(irClass2, typeInfo);
    }

    public final void registerInitFunction(@NotNull WasmFunction wasmFunction, @NotNull String priority) {
        Intrinsics.checkNotNullParameter((Object)wasmFunction, (String)"wasmFunction");
        Intrinsics.checkNotNullParameter((Object)priority, (String)"priority");
        ((Collection)this.wasmFragment.getInitFunctions()).add(new WasmCompiledModuleFragment.FunWithPriority(wasmFunction, priority));
    }

    public final void addExport(@NotNull WasmExport<?> wasmExport) {
        Intrinsics.checkNotNullParameter(wasmExport, (String)"wasmExport");
        ((Collection)this.wasmFragment.getExports()).add(wasmExport);
    }

    public final void defineFunction(@NotNull IrFunctionSymbol irFunction2, @NotNull WasmFunction wasmFunction) {
        Intrinsics.checkNotNullParameter((Object)irFunction2, (String)"irFunction");
        Intrinsics.checkNotNullParameter((Object)wasmFunction, (String)"wasmFunction");
        this.wasmFragment.getFunctions().define(irFunction2, wasmFunction);
    }

    public final void defineGlobalField(@NotNull IrFieldSymbol irField, @NotNull WasmGlobal wasmGlobal) {
        Intrinsics.checkNotNullParameter((Object)irField, (String)"irField");
        Intrinsics.checkNotNullParameter((Object)wasmGlobal, (String)"wasmGlobal");
        this.wasmFragment.getGlobalFields().define(irField, wasmGlobal);
    }

    public final void defineGlobalVTable(@NotNull IrClassSymbol irClass2, @NotNull WasmGlobal wasmGlobal) {
        Intrinsics.checkNotNullParameter((Object)irClass2, (String)"irClass");
        Intrinsics.checkNotNullParameter((Object)wasmGlobal, (String)"wasmGlobal");
        this.wasmFragment.getGlobalVTables().define(irClass2, wasmGlobal);
    }

    public final void defineGlobalClassITable(@NotNull IrClassSymbol irClass2, @NotNull WasmGlobal wasmGlobal) {
        Intrinsics.checkNotNullParameter((Object)irClass2, (String)"irClass");
        Intrinsics.checkNotNullParameter((Object)wasmGlobal, (String)"wasmGlobal");
        this.wasmFragment.getGlobalClassITables().define(irClass2, wasmGlobal);
    }

    public final void defineGcType(@NotNull IrClassSymbol irClass2, @NotNull WasmTypeDeclaration wasmType) {
        Intrinsics.checkNotNullParameter((Object)irClass2, (String)"irClass");
        Intrinsics.checkNotNullParameter((Object)wasmType, (String)"wasmType");
        this.wasmFragment.getGcTypes().define(irClass2, wasmType);
    }

    public final void defineVTableGcType(@NotNull IrClassSymbol irClass2, @NotNull WasmTypeDeclaration wasmType) {
        Intrinsics.checkNotNullParameter((Object)irClass2, (String)"irClass");
        Intrinsics.checkNotNullParameter((Object)wasmType, (String)"wasmType");
        this.wasmFragment.getVTableGcTypes().define(irClass2, wasmType);
    }

    public final void defineFunctionType(@NotNull IrFunctionSymbol irFunction2, @NotNull WasmFunctionType wasmFunctionType) {
        Intrinsics.checkNotNullParameter((Object)irFunction2, (String)"irFunction");
        Intrinsics.checkNotNullParameter((Object)wasmFunctionType, (String)"wasmFunctionType");
        this.wasmFragment.getFunctionTypes().define(irFunction2, wasmFunctionType);
    }

    @NotNull
    public final ClassMetadata getClassMetadata(@NotNull IrClassSymbol irClass2) {
        ClassMetadata classMetadata;
        Intrinsics.checkNotNullParameter((Object)irClass2, (String)"irClass");
        Map<IrClassSymbol, ClassMetadata> $this$getOrPut$iv = this.classMetadataCache;
        boolean $i$f$getOrPut = false;
        ClassMetadata value$iv = $this$getOrPut$iv.get(irClass2);
        if (value$iv == null) {
            ClassMetadata classMetadata2;
            IrClass superClass;
            boolean bl = false;
            IrClass irClass3 = superClass = ClassInfoKt.getSuperClass((IrClass)irClass2.getOwner(), this.backendContext.getIrBuiltIns());
            if (irClass3 != null) {
                IrClass it = irClass3;
                boolean bl2 = false;
                classMetadata2 = this.getClassMetadata(it.getSymbol());
            } else {
                classMetadata2 = null;
            }
            ClassMetadata superClassMetadata = classMetadata2;
            ClassMetadata answer$iv = new ClassMetadata((IrClass)irClass2.getOwner(), superClassMetadata, this.backendContext.getIrBuiltIns());
            $this$getOrPut$iv.put(irClass2, answer$iv);
            classMetadata = answer$iv;
        } else {
            classMetadata = value$iv;
        }
        return classMetadata;
    }

    @NotNull
    public final InterfaceMetadata getInterfaceMetadata(@NotNull IrClassSymbol irClass2) {
        InterfaceMetadata interfaceMetadata;
        Intrinsics.checkNotNullParameter((Object)irClass2, (String)"irClass");
        Map<IrClassSymbol, InterfaceMetadata> $this$getOrPut$iv = this.interfaceMetadataCache;
        boolean $i$f$getOrPut = false;
        InterfaceMetadata value$iv = $this$getOrPut$iv.get(irClass2);
        if (value$iv == null) {
            boolean bl = false;
            InterfaceMetadata answer$iv = new InterfaceMetadata((IrClass)irClass2.getOwner(), this.backendContext.getIrBuiltIns());
            $this$getOrPut$iv.put(irClass2, answer$iv);
            interfaceMetadata = answer$iv;
        } else {
            interfaceMetadata = value$iv;
        }
        return interfaceMetadata;
    }

    @NotNull
    public final WasmSymbol<WasmFunction> referenceFunction(@NotNull IrFunctionSymbol irFunction2) {
        Intrinsics.checkNotNullParameter((Object)irFunction2, (String)"irFunction");
        return this.wasmFragment.getFunctions().reference(irFunction2);
    }

    @NotNull
    public final WasmSymbol<WasmGlobal> referenceGlobalField(@NotNull IrFieldSymbol irField) {
        Intrinsics.checkNotNullParameter((Object)irField, (String)"irField");
        return this.wasmFragment.getGlobalFields().reference(irField);
    }

    @NotNull
    public final WasmSymbol<WasmGlobal> referenceGlobalVTable(@NotNull IrClassSymbol irClass2) {
        Intrinsics.checkNotNullParameter((Object)irClass2, (String)"irClass");
        return this.wasmFragment.getGlobalVTables().reference(irClass2);
    }

    @NotNull
    public final WasmSymbol<WasmGlobal> referenceGlobalClassITable(@NotNull IrClassSymbol irClass2) {
        Intrinsics.checkNotNullParameter((Object)irClass2, (String)"irClass");
        return this.wasmFragment.getGlobalClassITables().reference(irClass2);
    }

    private final WasmSymbol<WasmTypeDeclaration> referenceNonNothingType(IrClassSymbol irClass2, WasmCompiledModuleFragment.ReferencableAndDefinable<IrClassSymbol, WasmTypeDeclaration> from2) {
        IrType type2 = IrTypesKt.getDefaultType(irClass2);
        if (!(!IrTypePredicatesKt.isNothing(type2))) {
            boolean bl = false;
            String string2 = "Can't reference Nothing type";
            throw new IllegalArgumentException(string2.toString());
        }
        return from2.reference(irClass2);
    }

    @NotNull
    public final WasmSymbol<WasmTypeDeclaration> referenceGcType(@NotNull IrClassSymbol irClass2) {
        Intrinsics.checkNotNullParameter((Object)irClass2, (String)"irClass");
        return this.referenceNonNothingType(irClass2, this.wasmFragment.getGcTypes());
    }

    @NotNull
    public final WasmSymbol<WasmTypeDeclaration> referenceVTableGcType(@NotNull IrClassSymbol irClass2) {
        Intrinsics.checkNotNullParameter((Object)irClass2, (String)"irClass");
        return this.referenceNonNothingType(irClass2, this.wasmFragment.getVTableGcTypes());
    }

    @NotNull
    public final WasmSymbol<WasmTypeDeclaration> referenceClassITableGcType(@NotNull IrClassSymbol irClass2) {
        Intrinsics.checkNotNullParameter((Object)irClass2, (String)"irClass");
        return this.referenceNonNothingType(irClass2, this.wasmFragment.getClassITableGcType());
    }

    public final void defineClassITableGcType(@NotNull IrClassSymbol irClass2, @NotNull WasmTypeDeclaration wasmType) {
        Intrinsics.checkNotNullParameter((Object)irClass2, (String)"irClass");
        Intrinsics.checkNotNullParameter((Object)wasmType, (String)"wasmType");
        this.wasmFragment.getClassITableGcType().define(irClass2, wasmType);
    }

    public final boolean isAlreadyDefinedClassITableGcType(@NotNull IrClassSymbol irClass2) {
        Intrinsics.checkNotNullParameter((Object)irClass2, (String)"irClass");
        return this.wasmFragment.getClassITableGcType().getDefined().keySet().contains(irClass2);
    }

    @NotNull
    public final WasmSymbol<Integer> referenceClassITableInterfaceSlot(@NotNull IrClassSymbol irClass2) {
        Intrinsics.checkNotNullParameter((Object)irClass2, (String)"irClass");
        IrType type2 = IrTypesKt.getDefaultType(irClass2);
        if (!(!IrTypePredicatesKt.isNothing(type2))) {
            boolean bl = false;
            String string2 = "Can't reference Nothing type";
            throw new IllegalArgumentException(string2.toString());
        }
        return this.wasmFragment.getClassITableInterfaceSlot().reference(irClass2);
    }

    public final void defineClassITableInterfaceSlot(@NotNull IrClassSymbol irClass2, int slot) {
        Intrinsics.checkNotNullParameter((Object)irClass2, (String)"irClass");
        this.wasmFragment.getClassITableInterfaceSlot().define(irClass2, slot);
    }

    @NotNull
    public final WasmSymbol<WasmFunctionType> referenceFunctionType(@NotNull IrFunctionSymbol irFunction2) {
        Intrinsics.checkNotNullParameter((Object)irFunction2, (String)"irFunction");
        return this.wasmFragment.getFunctionTypes().reference(irFunction2);
    }

    @NotNull
    public final WasmSymbol<Integer> referenceTypeId(@NotNull IrClassSymbol irClass2) {
        Intrinsics.checkNotNullParameter((Object)irClass2, (String)"irClass");
        return this.wasmFragment.getTypeIds().reference(irClass2);
    }

    @NotNull
    public final WasmSymbol<Integer> getStructFieldRef(@NotNull IrField field2) {
        Intrinsics.checkNotNullParameter((Object)field2, (String)"field");
        IrClass klass = IrUtilsKt.getParentAsClass(field2);
        ClassMetadata metadata = this.getClassMetadata(klass.getSymbol());
        int fieldId = metadata.getFields().indexOf(field2) + 2;
        return new WasmSymbol<Integer>(fieldId);
    }

    public final void addJsFun(@NotNull String importName, @NotNull String jsCode) {
        Intrinsics.checkNotNullParameter((Object)importName, (String)"importName");
        Intrinsics.checkNotNullParameter((Object)jsCode, (String)"jsCode");
        ((Collection)this.wasmFragment.getJsFuns()).add(new WasmCompiledModuleFragment.JsCodeSnippet(importName, jsCode));
    }

    public final void addJsModuleImport(@NotNull String module2) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        ((Collection)this.wasmFragment.getJsModuleImports()).add(module2);
    }
}

