/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel.report;

import java.awt.Component;
import java.awt.Font;
import java.util.List;
import javax.swing.JLabel;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.FontLibrary;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.client.gui.panel.report.ReportPanel;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.HighScore;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Turn;

public final class ReportHighScoresPanel
extends ReportPanel {
    public ReportHighScoresPanel(FreeColClient freeColClient, String prefix, List<HighScore> highScores) {
        super(freeColClient, "reportHighScoresAction");
        this.reportPanel.removeAll();
        this.reportPanel.setLayout(new MigLayout("wrap 3, gapx 30", "[][][align right]", ""));
        if (prefix != null) {
            this.reportPanel.add((Component)Utility.localizedLabel(prefix), "span, wrap 10");
        }
        Font font = FontLibrary.getScaledFont(Utility.FONTSPEC_SUBTITLE);
        for (HighScore highScore : highScores) {
            JLabel scoreValue = new JLabel(String.valueOf(highScore.getScore()));
            scoreValue.setFont(font);
            this.reportPanel.add(scoreValue);
            String messageId = highScore.getIndependenceTurn() > 0 ? "report.highScores.president" : "report.highScores.governor";
            Object template = ((StringTemplate)StringTemplate.template(messageId).addName("%name%", highScore.getPlayerName())).addName("%nation%", highScore.getNewLandName());
            JLabel headline = Utility.localizedHeaderLabel(template, 10, Utility.FONTSPEC_SUBTITLE);
            this.reportPanel.add((Component)headline, "span, wrap 10");
            this.reportPanel.add((Component)Utility.localizedLabel("report.highScores.turn"), "skip");
            int retirementTurn = highScore.getRetirementTurn();
            this.reportPanel.add(retirementTurn <= 0 ? Utility.localizedLabel("notApplicable") : Utility.localizedLabel(Turn.getTurnLabel(retirementTurn)));
            this.reportPanel.add((Component)Utility.localizedLabel("report.highScores.score"), "skip");
            this.reportPanel.add(new JLabel(String.valueOf(highScore.getScore())));
            this.reportPanel.add((Component)Utility.localizedLabel("report.highScores.difficulty"), "skip");
            this.reportPanel.add(Utility.localizedLabel(Messages.nameKey(highScore.getDifficulty())));
            this.reportPanel.add((Component)Utility.localizedLabel("report.highScores.independence"), "skip");
            int independenceTurn = highScore.getIndependenceTurn();
            this.reportPanel.add(independenceTurn <= 0 ? Utility.localizedLabel("no") : Utility.localizedLabel(Turn.getTurnLabel(independenceTurn)));
            this.reportPanel.add((Component)Utility.localizedLabel("report.highScores.nation"), "skip");
            this.reportPanel.add(Utility.localizedLabel(highScore.getIndependenceTurn() > 0 ? StringTemplate.name(highScore.getNationName()) : StringTemplate.key(highScore.getOldNationNameKey())));
            this.reportPanel.add((Component)Utility.localizedLabel("report.highScores.nationType"), "skip");
            this.reportPanel.add(Utility.localizedLabel(Messages.nameKey(highScore.getNationTypeId())));
            this.reportPanel.add((Component)Utility.localizedLabel("report.highScores.units"), "skip");
            this.reportPanel.add(new JLabel(String.valueOf(highScore.getUnitCount())));
            this.reportPanel.add((Component)Utility.localizedLabel("report.highScores.colonies"), "skip");
            this.reportPanel.add(new JLabel(String.valueOf(highScore.getColonyCount())));
            this.reportPanel.add((Component)Utility.localizedLabel("report.highScores.retired"), "skip");
            this.reportPanel.add((Component)new JLabel(highScore.getDateString()), "wrap 20");
        }
        this.reportPanel.doLayout();
    }
}

