/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.test.keys.storage;

import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.NoSuchElementException;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.xml.security.keys.storage.StorageResolver;

public class StorageResolverTest
extends TestCase {
    private static final String BASEDIR = System.getProperty("basedir") == null ? "./" : System.getProperty("basedir");
    private static final String SEP = System.getProperty("file.separator");
    static /* synthetic */ Class class$org$apache$xml$security$test$keys$storage$StorageResolverTest;

    public StorageResolverTest() {
        super("KeyStoreResolverTest");
    }

    public StorageResolverTest(String string) {
        super(string);
    }

    public static Test suite() {
        return new TestSuite(class$org$apache$xml$security$test$keys$storage$StorageResolverTest == null ? (class$org$apache$xml$security$test$keys$storage$StorageResolverTest = StorageResolverTest.class$("org.apache.xml.security.test.keys.storage.StorageResolverTest")) : class$org$apache$xml$security$test$keys$storage$StorageResolverTest);
    }

    public void testStorageResolver() throws Exception {
        Object object;
        String string = BASEDIR + SEP + "data" + SEP + "org" + SEP + "apache" + SEP + "xml" + SEP + "security" + SEP + "samples" + SEP + "input";
        FileInputStream fileInputStream = new FileInputStream(string + SEP + "keystore.jks");
        KeyStore keyStore = KeyStore.getInstance("JKS");
        keyStore.load(fileInputStream, "xmlsecurity".toCharArray());
        FileInputStream fileInputStream2 = new FileInputStream(string + SEP + "keystore2.jks");
        KeyStore keyStore2 = KeyStore.getInstance("JCEKS");
        keyStore2.load(fileInputStream2, "xmlsecurity".toCharArray());
        StorageResolver storageResolver = new StorageResolver(keyStore);
        storageResolver.add(keyStore2);
        int n = 0;
        while (storageResolver.hasNext()) {
            object = storageResolver.next();
            StorageResolverTest.assertNotNull((Object)object);
            ++n;
        }
        StorageResolverTest.assertEquals((int)4, (int)n);
        try {
            storageResolver.next();
            StorageResolverTest.fail((String)"Expecting NoSuchElementException");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        object = storageResolver.getIterator();
        this.checkIterator((Iterator)object);
        Iterator iterator = storageResolver.getIterator();
        this.checkIterator(iterator);
        object = storageResolver.getIterator();
        iterator = storageResolver.getIterator();
        while (object.hasNext()) {
            X509Certificate x509Certificate;
            X509Certificate x509Certificate2 = (X509Certificate)object.next();
            if (x509Certificate2.equals(x509Certificate = (X509Certificate)iterator.next())) continue;
            StorageResolverTest.fail((String)"StorageResolver iterators are not independent");
        }
        StorageResolverTest.assertFalse((boolean)iterator.hasNext());
    }

    private void checkIterator(Iterator iterator) {
        int n = 0;
        iterator.hasNext();
        while (iterator.hasNext()) {
            X509Certificate x509Certificate = (X509Certificate)iterator.next();
            x509Certificate.getSubjectDN().getName();
            ++n;
        }
        StorageResolverTest.assertEquals((int)4, (int)n);
        try {
            iterator.next();
            StorageResolverTest.fail((String)"Expecting NoSuchElementException");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

