/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.truffle.lang.python;

import java.util.List;
import java.util.UnknownFormatConversionException;
import org.graalvm.visualvm.heapviewer.truffle.dynamicobject.DynamicObject;
import org.graalvm.visualvm.lib.jfluid.heap.FieldValue;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.jfluid.heap.ObjectArrayInstance;
import org.graalvm.visualvm.lib.jfluid.heap.ObjectFieldValue;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.api.DetailsSupport;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.spi.DetailsProvider;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.spi.DetailsUtils;

public class PythonDetailsProvider
extends DetailsProvider.Basic {
    private static final String PCLASS_MASK = "com.oracle.graal.python.builtins.objects.type.PythonClass+";
    private static final String PMANAGEDCLASS_MASK = "com.oracle.graal.python.builtins.objects.type.PythonManagedClass+";
    private static final String PFUNCTION_MASK = "com.oracle.graal.python.builtins.objects.function.PFunction+";
    private static final String PBUILTIN_FUNCTION_MASK = "com.oracle.graal.python.builtins.objects.function.PBuiltinFunction";
    private static final String PBUILTIN_METHOD_MASK = "com.oracle.graal.python.builtins.objects.method.PBuiltinMethod";
    private static final String PMETHOD_MASK = "com.oracle.graal.python.builtins.objects.method.PMethod";
    private static final String PDECORATEDMETHOD_MASK = "com.oracle.graal.python.builtins.objects.method.PDecoratedMethod";
    private static final String PCELL_MASK = "com.oracle.graal.python.builtins.objects.cell.PCell";
    private static final String PNONE_MASK = "com.oracle.graal.python.builtins.objects.PNone";
    private static final String PLIST_MASK = "com.oracle.graal.python.builtins.objects.list.PList";
    private static final String PSTRING_MASK = "com.oracle.graal.python.builtins.objects.str.PString";
    private static final String BASIC_STORAGE_MASK = "com.oracle.graal.python.runtime.sequence.storage.BasicSequenceStorage+";
    private static final String EMPTY_STORAGE_MASK = "com.oracle.graal.python.runtime.sequence.storage.EmptySequenceStorage";
    private static final String BYTE_STORAGE_MASK = "com.oracle.graal.python.runtime.sequence.storage.ByteSequenceStorage";
    private static final String PTUPLE_MASK = "com.oracle.graal.python.builtins.objects.tuple.PTuple";
    private static final String PMODULE_MASK = "com.oracle.graal.python.builtins.objects.module.PythonModule";
    private static final String PBYTES_MASK = "com.oracle.graal.python.builtins.objects.bytes.PBytes";
    private static final String PCOMPLEX_MASK = "com.oracle.graal.python.builtins.objects.complex.PComplex";
    private static final String PINT_MASK = "com.oracle.graal.python.builtins.objects.ints.PInt";
    private static final String PEXCEPTION_MASK = "com.oracle.graal.python.runtime.exception.PException";
    private static final String PBASEEXCEPTION_MASK = "com.oracle.graal.python.builtins.objects.exception.PBaseException";
    private static final String GETSET_DESCRIPTOR_MASK = "com.oracle.graal.python.builtins.objects.getsetdescriptor.GetSetDescriptor";
    private static final String PBUILTIN_CLASSTYPE_MASK = "com.oracle.graal.python.builtins.PythonBuiltinClassType";
    private static final String PLAZY_STRING_MASK = "com.oracle.graal.python.builtins.objects.str.LazyString";
    private static final String PRANGE_MASK = "com.oracle.graal.python.builtins.objects.range.PRange";
    private static final String PSOCKET_MASK = "com.oracle.graal.python.builtins.objects.socket.PSocket";
    private static final String PFROOT_MASK = "com.oracle.graal.python.nodes.function.FunctionRootNode";
    private static final String PBFROOT_MASK = "com.oracle.graal.python.nodes.function.BuiltinFunctionRootNode";
    private static final String PMFROOT_MASK = "com.oracle.graal.python.nodes.ModuleRootNode";
    private static final String PGFROOT_MASK = "com.oracle.graal.python.nodes.generator.GeneratorFunctionRootNode";
    private static final String PTFROOT_MASK = "com.oracle.graal.python.nodes.control.TopLevelExceptionHandler";
    private static final String DICT_KEY_MASK = "com.oracle.graal.python.builtins.objects.common.EconomicMapStorage$DictKey";
    private static final String METHOD_NODE_MASK = "com.oracle.graal.python.builtins.objects.cext.capi.ExternalFunctionNodes$MethodDescriptorRoot+";

    public PythonDetailsProvider() {
        super(new String[]{PCLASS_MASK, PMANAGEDCLASS_MASK, PFUNCTION_MASK, PNONE_MASK, PLIST_MASK, PSTRING_MASK, BASIC_STORAGE_MASK, PTUPLE_MASK, PMODULE_MASK, PBYTES_MASK, EMPTY_STORAGE_MASK, PINT_MASK, PCOMPLEX_MASK, PEXCEPTION_MASK, PBASEEXCEPTION_MASK, PBUILTIN_FUNCTION_MASK, PBUILTIN_METHOD_MASK, PMETHOD_MASK, PDECORATEDMETHOD_MASK, PCELL_MASK, BYTE_STORAGE_MASK, GETSET_DESCRIPTOR_MASK, PBUILTIN_CLASSTYPE_MASK, PLAZY_STRING_MASK, PRANGE_MASK, PSOCKET_MASK, PFROOT_MASK, PBFROOT_MASK, PMFROOT_MASK, PGFROOT_MASK, PTFROOT_MASK, DICT_KEY_MASK, METHOD_NODE_MASK});
    }

    public String getDetailsString(String className, Instance instance) {
        switch (className) {
            case "com.oracle.graal.python.builtins.objects.type.PythonClass+": 
            case "com.oracle.graal.python.builtins.objects.type.PythonManagedClass+": {
                String name = DetailsUtils.getInstanceFieldString((Instance)instance, (String)"name");
                if (name != null) {
                    return name;
                }
                return DetailsUtils.getInstanceFieldString((Instance)instance, (String)"className");
            }
            case "com.oracle.graal.python.builtins.objects.function.PBuiltinFunction": {
                return DetailsUtils.getInstanceFieldString((Instance)instance, (String)"name");
            }
            case "com.oracle.graal.python.builtins.objects.method.PBuiltinMethod": {
                Object moduleO = instance.getValueOfField("self");
                if (!(moduleO instanceof Instance)) {
                    moduleO = null;
                } else if (!((Instance)moduleO).getJavaClass().getName().equals(PMODULE_MASK)) {
                    moduleO = null;
                }
                String module = moduleO == null ? null : DetailsUtils.getInstanceString((Instance)((Instance)moduleO));
                String function = DetailsUtils.getInstanceFieldString((Instance)instance, (String)"function");
                if (function == null) break;
                return module != null ? module + "." + function : function;
            }
            case "com.oracle.graal.python.builtins.objects.method.PMethod": {
                return DetailsUtils.getInstanceFieldString((Instance)instance, (String)"function");
            }
            case "com.oracle.graal.python.builtins.objects.method.PDecoratedMethod": {
                return DetailsUtils.getInstanceFieldString((Instance)instance, (String)"callable");
            }
            case "com.oracle.graal.python.builtins.objects.cell.PCell": {
                Object refO = instance.getValueOfField("ref");
                if (!(refO instanceof Instance)) {
                    refO = null;
                } else if (((Instance)refO).getJavaClass().getName().equals(PLIST_MASK)) {
                    refO = null;
                } else if (((Instance)refO).getJavaClass().getName().equals(PTUPLE_MASK)) {
                    refO = null;
                }
                return refO == null ? null : DetailsUtils.getInstanceString((Instance)((Instance)refO));
            }
            case "com.oracle.graal.python.builtins.objects.function.PFunction+": {
                String enclName = DetailsUtils.getInstanceFieldString((Instance)instance, (String)"enclosingClassName");
                String name = DetailsUtils.getInstanceFieldString((Instance)instance, (String)"name");
                if (enclName != null && !enclName.isEmpty() && name != null) {
                    return enclName + "." + name;
                }
                return name;
            }
            case "com.oracle.graal.python.builtins.objects.str.PString": {
                String val = DetailsUtils.getInstanceFieldString((Instance)instance, (String)"materializedValue");
                if (val != null) {
                    return val;
                }
                return DetailsUtils.getInstanceFieldString((Instance)instance, (String)"value");
            }
            case "com.oracle.graal.python.builtins.PythonBuiltinClassType": {
                for (Object fv : instance.getFieldValues()) {
                    ObjectFieldValue ofv;
                    if (!(fv instanceof ObjectFieldValue) || !"name".equals((ofv = (ObjectFieldValue)fv).getField().getName())) continue;
                    return DetailsUtils.getInstanceString((Instance)ofv.getInstance());
                }
                break;
            }
            case "com.oracle.graal.python.builtins.objects.PNone": {
                return "None";
            }
            case "com.oracle.graal.python.builtins.objects.list.PList": {
                return DetailsUtils.getInstanceFieldString((Instance)instance, (String)"store");
            }
            case "com.oracle.graal.python.runtime.sequence.storage.BasicSequenceStorage+": {
                return DetailsUtils.getIntFieldValue((Instance)instance, (String)"length", (int)0) + " items";
            }
            case "com.oracle.graal.python.runtime.sequence.storage.EmptySequenceStorage": {
                return "0 items";
            }
            case "com.oracle.graal.python.builtins.objects.tuple.PTuple": {
                String value = DetailsUtils.getInstanceFieldString((Instance)instance, (String)"array");
                if (value == null) {
                    return DetailsUtils.getInstanceFieldString((Instance)instance, (String)"store");
                }
                return value;
            }
            case "com.oracle.graal.python.builtins.objects.module.PythonModule": {
                DynamicObject attrubutes;
                FieldValue nameAttr;
                String value = DetailsUtils.getInstanceFieldString((Instance)instance, (String)"name");
                if (value != null) break;
                Instance storageInst = (Instance)instance.getValueOfField("storage");
                if (storageInst == null && DynamicObject.isDynamicObject(instance)) {
                    storageInst = instance;
                }
                if (storageInst == null || !((nameAttr = (attrubutes = new DynamicObject(storageInst)).getFieldValue("__name__")) instanceof ObjectFieldValue)) break;
                Instance moduleName = ((ObjectFieldValue)nameAttr).getInstance();
                return DetailsSupport.getDetailsString((Instance)moduleName);
            }
            case "com.oracle.graal.python.builtins.objects.bytes.PBytes": {
                String bytes = DetailsUtils.getPrimitiveArrayFieldString((Instance)instance, (String)"bytes", (int)0, (int)-1, (String)",", (String)"...");
                if (bytes != null) break;
                return DetailsUtils.getInstanceFieldString((Instance)instance, (String)"store");
            }
            case "com.oracle.graal.python.builtins.objects.complex.PComplex": {
                Double realObj = (Double)instance.getValueOfField("real");
                Double imagObj = (Double)instance.getValueOfField("imag");
                if (realObj == null || imagObj == null) break;
                return PythonDetailsProvider.complexToString(realObj, imagObj);
            }
            case "com.oracle.graal.python.builtins.objects.ints.PInt": {
                return DetailsUtils.getInstanceFieldString((Instance)instance, (String)"value");
            }
            case "com.oracle.graal.python.runtime.exception.PException": {
                String message = DetailsUtils.getInstanceFieldString((Instance)instance, (String)"message");
                return message != null ? message : DetailsUtils.getInstanceFieldString((Instance)instance, (String)"pythonException");
            }
            case "com.oracle.graal.python.builtins.objects.exception.PBaseException": {
                Instance val;
                ObjectArrayInstance arr;
                Object values;
                Object store;
                String message = DetailsUtils.getInstanceFieldString((Instance)instance, (String)"messageFormat");
                if (message != null) {
                    Object args = instance.getValueOfField("messageArgs");
                    if (args instanceof ObjectArrayInstance) {
                        List vals = ((ObjectArrayInstance)args).getValues();
                        Object[] params = new String[vals.size()];
                        for (int i = 0; i < params.length; ++i) {
                            params[i] = DetailsUtils.getInstanceString((Instance)((Instance)vals.get(i)));
                        }
                        message = PythonDetailsProvider.safeFormatString(3, message, params);
                    }
                    return message;
                }
                Object args = instance.getValueOfField("args");
                if (!(args instanceof Instance) || !((store = ((Instance)args).getValueOfField("store")) instanceof Instance) || !((values = ((Instance)store).getValueOfField("values")) instanceof ObjectArrayInstance) || (arr = (ObjectArrayInstance)values).getLength() <= 0 || (val = (Instance)arr.getValues().get(0)) == null) break;
                return DetailsUtils.getInstanceString((Instance)val);
            }
            case "com.oracle.graal.python.runtime.sequence.storage.ByteSequenceStorage": {
                return DetailsUtils.getPrimitiveArrayFieldString((Instance)instance, (String)"values", (int)0, (int)-1, (String)",", (String)"...");
            }
            case "com.oracle.graal.python.builtins.objects.getsetdescriptor.GetSetDescriptor": {
                return DetailsUtils.getInstanceFieldString((Instance)instance, (String)"name");
            }
            case "com.oracle.graal.python.builtins.objects.str.LazyString": {
                Object vall = instance.getValueOfField("left");
                Object valr = instance.getValueOfField("right");
                String left = DetailsUtils.getInstanceString((Instance)((Instance)vall));
                if (valr == null || left.length() > 160) {
                    return left;
                }
                return left + DetailsUtils.getInstanceString((Instance)((Instance)valr));
            }
            case "com.oracle.graal.python.builtins.objects.range.PRange": {
                int start = DetailsUtils.getIntFieldValue((Instance)instance, (String)"start", (int)0);
                int stop = DetailsUtils.getIntFieldValue((Instance)instance, (String)"stop", (int)0);
                int step = DetailsUtils.getIntFieldValue((Instance)instance, (String)"step", (int)1);
                return "[" + start + ", " + stop + ", " + step + "]";
            }
            case "com.oracle.graal.python.builtins.objects.socket.PSocket": {
                return DetailsUtils.getInstanceFieldString((Instance)instance, (String)"address");
            }
            case "com.oracle.graal.python.nodes.function.FunctionRootNode": {
                return DetailsUtils.getInstanceFieldString((Instance)instance, (String)"functionName");
            }
            case "com.oracle.graal.python.nodes.function.BuiltinFunctionRootNode": {
                return DetailsUtils.getInstanceFieldString((Instance)instance, (String)"name");
            }
            case "com.oracle.graal.python.nodes.ModuleRootNode": {
                return DetailsUtils.getInstanceFieldString((Instance)instance, (String)"name");
            }
            case "com.oracle.graal.python.nodes.generator.GeneratorFunctionRootNode": {
                return DetailsUtils.getInstanceFieldString((Instance)instance, (String)"originalName");
            }
            case "com.oracle.graal.python.nodes.control.TopLevelExceptionHandler": {
                return "<module __main__>";
            }
            case "com.oracle.graal.python.builtins.objects.common.EconomicMapStorage$DictKey": {
                return DetailsUtils.getInstanceFieldString((Instance)instance, (String)"value");
            }
            case "com.oracle.graal.python.builtins.objects.cext.capi.ExternalFunctionNodes$MethodDescriptorRoot+": {
                return DetailsUtils.getInstanceFieldString((Instance)instance, (String)"name");
            }
        }
        return null;
    }

    private static String complexToString(double real, double imag) {
        if (Double.compare(real, 0.0) == 0) {
            return PythonDetailsProvider.toString(imag) + "j";
        }
        String realString = PythonDetailsProvider.toString(real);
        if (real == 0.0) {
            realString = "-0";
        }
        if (Double.compare(imag, 0.0) >= 0) {
            return String.format("(%s+%sj)", realString, PythonDetailsProvider.toString(imag));
        }
        return String.format("(%s-%sj)", realString, PythonDetailsProvider.toString(-imag));
    }

    private static String toString(double value) {
        if (value == Math.floor(value) && value <= 9.223372036854776E18 && value >= -9.223372036854776E18) {
            return Long.toString((long)value);
        }
        return Double.toString(value);
    }

    private static String safeFormatString(int maxIterations, String format, Object ... args) {
        while (maxIterations-- > 0) {
            try {
                return String.format(format, args);
            }
            catch (UnknownFormatConversionException e) {
                format = format.replace("%" + e.getConversion(), "%s");
            }
        }
        return format;
    }
}

