/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * acos(-1.0) => 3.1415927
 * acos(-0.33333334) => 1.9106332
 * acos(0.33333334) => 1.2309594
 * acos(1.0) => 0.0
 */
#version 150

void main()
{
  float[distance(acos(-1.0), 3.1415927) <= 0.0031415927 ? 1 : -1] array0;
  float[distance(acos(-0.33333334), 1.9106332) <= 0.0019106333 ? 1 : -1] array1;
  float[distance(acos(0.33333334), 1.2309594) <= 0.0012309594 ? 1 : -1] array2;
  float[distance(acos(1.0), 0.0) <= 1e-04 ? 1 : -1] array3;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
